/*
 *  linux/arch/mips/toshiba-boards/generic/pmon-low.S
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 2000-2001 Toshiba Corporation
 *
 * $Id: pmon-low.S,v 1.1.1.1 2004/04/07 08:36:50 louistsai Exp $
 */

#include <asm/asm.h>
#include <asm/mipsregs.h>
#include <asm/regdef.h>
#include <asm/addrspace.h>
#include <asm/stackframe.h>
#include <asm/isadep.h>

	.align 5
	NESTED(pmon_trap_low, PT_SIZE, sp)
	.set	noat
	.set	noreorder
	mfc0	k0,CP0_STATUS
	andi	k0,KU_MASK     		/* extract K/U bit */
	xori	k0,KU_KERN
	beqz	k0,1f
	 nop
	/*
	 * Trap from user mode - invoke user exception handler
	 * set up in pmon.c
	 */
	mfc0	k1,CP0_CAUSE
	andi	k1,k1,0x7c
	la	k0,pmon_user_exception_handler
	addu	k0,k0,k1
	lw	k0,0(k0)
	nop
	jr	k0
	nop
1:
	/* jump into PMON */
	la	k0, pmon_vector
	lw	k0, (k0)
	lw	k0, 48(k0)	/* 12:_exception */
	jr	k0
	 nop
	.set	at
	.set	reorder
	END(pmon_trap_low)
