/*
 *  linux/arch/mips/toshiba-boards/generic/prom.c
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 1999-2001 Toshiba Corporation
 *
 * $Id: prom.c,v 1.1.1.1 2004/04/07 08:36:50 louistsai Exp $
 */

#include <linux/config.h>
#include <linux/init.h>
#include <linux/string.h>
#ifdef CONFIG_BLK_DEV_INITRD
#include <linux/blk.h>
#endif
#include <asm/system.h>
#include <asm/mipsregs.h>
#include <asm/io.h>
#include <asm/cpu.h>
#include <asm/bootinfo.h>
#include <asm/toshiba-boards/pmon.h>

/* mips/kernel/setup.c use this. */
char arcs_cmdline[CL_SIZE];

extern int tsdb_prom_init(int argc, char **argv, char **envp);
extern int jmr3927_prom_init(int argc, char **argv, char **envp);
extern int tx4927evb_prom_init(int argc, char **argv, char **envp);
extern int rbtx4927_prom_init(int argc, char **argv, char **envp);
extern int rbtx4925_prom_init(int argc, char **argv, char **envp);

unsigned long toshibaboards_memory_upper;

#ifdef CONFIG_CPU_TX49XX
extern int mips_configk0;
#endif
int mips_ic_disable = 0, mips_dc_disable = 0;
int mips_config_cwfon = 1;
int mips_config_wbon = 1;

int __init prom_init(int argc, char **argv, char **envp)
{
	int i;
	int (*arch_prom_init)(int argc, char **argv, char **envp) = 0;
	unsigned int conf;
	char *envstr = NULL;

#ifdef CONFIG_IP_PNP
	int use_pmon_ipaddr = 0;
#endif
#ifdef CONFIG_BLK_DEV_INITRD
	/* see arch/mips/kernel/setup.c */
	unsigned long tmp;
	unsigned long* initrd_header;
	extern char _end;
	tmp = (((unsigned long)&_end + PAGE_SIZE-1) & PAGE_MASK) - 8; 
	if (tmp < (unsigned long)&_end) 
		tmp += PAGE_SIZE;
	initrd_header = (unsigned long *)tmp;
	initrd_header[0] = 0;	/* default: do not use initrd_header */
#endif
#if defined(CONFIG_CPU_TX39XX) && defined(CONFIG_TOSHIBA_SDB)
	if ((mips_cpu.processor_id & 0xffff) == (PRID_IMP_TX39 | 0x0050)) {
		/* TX39H3: support core-mode only */
		mips_cpu.cputype = CPU_TX39XX;
		mips_cpu.tlbsize = 32;
		mips_cpu.icache.ways = 2;
		mips_cpu.dcache.ways = 2;
	}
	if (mips_cpu.cputype == CPU_TX3927) {
		/* check core-mode */
		if ((*(volatile u32 *)0xfffee004 >> 16) != 0x3927)
			mips_cpu.cputype = CPU_TX39XX;
	}
#endif /* CONFIG_CPU_TX39XX && CONFIG_TOSHIBA_SDB */
	switch(mips_cpu.cputype) {
	case CPU_TX3912:
	case CPU_TX3922:
	case CPU_TX3927:
	case CPU_TX39XX:
		pmon_vector = (struct pmon_vector *)PMON_VECTOR_TX39;
		break;
	case CPU_R4300:
	case CPU_TX49XX:
		pmon_vector = (struct pmon_vector *)PMON_VECTOR_R4K;
		break;
	}
	if (argc <= 0 || strncmp(argv[0], "HCP", 3) == 0)
		pmon_vector = NULL;

#if 1	/* Modified by Ethan on 04/21/2002 */
	toshibaboards_memory_upper = 0x81ffff00; /* at least 32M (we hope) */
#else
	if (pmon_vector) {
		envstr = pmon_vector->getenv("clienttop");
		if (envstr)
			toshibaboards_memory_upper =
				KSEG0ADDR(simple_strtoul(envstr, NULL, 16));
	}
#endif
	/* "mem=" option can override this */
	add_memory_region(0, PHYSADDR(toshibaboards_memory_upper), BOOT_MEM_RAM);

	mips_machgroup = MACH_GROUP_TOSHIBA;
	/* first, determine by "board=" argument */
	envstr = NULL;
	for (i = 1; i < argc; i++) {
		if (strncmp(argv[i], "board=", 6) == 0)
			envstr = argv[i] + 6;
	}

#if 0	/* Removed by Ethan on 04/21/2002 */
	/* next, determine by "board" envvar */
	if (!envstr && pmon_vector)
		envstr = pmon_vector->getenv("board");
#endif

	if (!envstr)
		envstr = "";
	if (strcmp(envstr, "TSDB") == 0)
		mips_machtype = MACH_TOSHIBA_SDB;
	else if (strcmp(envstr, "JMR") == 0)
		mips_machtype = MACH_TOSHIBA_JMR3927;
	else if (strcmp(envstr, "TX4927EVB") == 0)
		mips_machtype = MACH_TOSHIBA_TX4927EVB;
	else if (strcmp(envstr, "RBTX4927") == 0)
		mips_machtype = MACH_TOSHIBA_RBTX4927;
	else if (strcmp(envstr, "RBTX4925") == 0)
		mips_machtype = MACH_TOSHIBA_RBTX4925;
	else {
		/* determine by cputype, PRid */
		switch (mips_cpu.cputype) {
		case CPU_R4300:
			mips_machtype = MACH_TOSHIBA_SDB;
			break;
		case CPU_TX49XX:
			switch (mips_cpu.processor_id & 0xffff) {
			case PRID_IMP_TX49 | 0x2d11: /* TX4955 */
			case PRID_IMP_TX49 | 0x2d20: /* TX4955A */
				mips_machtype = MACH_TOSHIBA_SDB;
				break;
			case PRID_IMP_TX49 | 0x2d21: /* TX4927R1 */
			case PRID_IMP_TX49 | 0x2d22: /* TX4927R2 */
				/* heuristic check for TX4925/TX4926... */
				if ((*(volatile unsigned int *)0xff1fe004) >> 16 == 0x4925 ||
				    (*(volatile unsigned int *)0xff1fe004) >> 16 == 0x4926) {
					mips_machtype = MACH_TOSHIBA_RBTX4925;
				} else {
#ifdef CONFIG_TOSHIBA_RBTX4927
					mips_machtype = MACH_TOSHIBA_RBTX4927;
#else
					mips_machtype = MACH_TOSHIBA_TX4927EVB;
#endif
				}
				break;
			}
			break;
		case CPU_TX3927:
			mips_machtype = MACH_TOSHIBA_JMR3927;
			break;
		case CPU_TX39XX:
			mips_machtype = MACH_TOSHIBA_SDB;
			break;
		}
	}
	switch (mips_machtype) {
#ifdef CONFIG_TOSHIBA_SDB
	case MACH_TOSHIBA_SDB:
		arch_prom_init = tsdb_prom_init;
		break;
#endif
#ifdef CONFIG_TOSHIBA_JMR3927
	case MACH_TOSHIBA_JMR3927:
		arch_prom_init = jmr3927_prom_init;
		break;
#endif
#ifdef CONFIG_TOSHIBA_TX4927EVB
	case MACH_TOSHIBA_TX4927EVB:
		arch_prom_init = tx4927evb_prom_init;
		break;
#endif
#ifdef CONFIG_TOSHIBA_RBTX4927
	case MACH_TOSHIBA_RBTX4927:
		arch_prom_init = rbtx4927_prom_init;
		break;
#endif
#ifdef CONFIG_TOSHIBA_RBTX4925
	case MACH_TOSHIBA_RBTX4925:
	case 0x2d22:
		arch_prom_init = rbtx4925_prom_init;
		break;
#endif
	}

	if (arch_prom_init == 0) {
		pmon_printf("unknwon arch. (PRid %x)\n", mips_cpu.processor_id);
		pmon_halt();
	}

	/* command from ROM Monitor */
	arcs_cmdline[0] = '\0';
	pmon_printf("boot:");
	/* argv[0] = "g" (go command) */
	for (i = 1; i < argc; i++) {
		char *str = argv[i];
		pmon_printf(" %s", str);
		/* check board specific options */
		if (arch_prom_init(-1, &str, NULL)) {
			continue;	/* skip (do not pass to "init") */
		}
		if (strncmp(str, "board=", 6) == 0) {
			continue;
#ifdef CONFIG_CPU_TX49XX
		} else if (strncmp(str, "configk0=", 9) == 0) {
			mips_configk0 = str[9] - '0';
			continue;
#endif
		} else if (strcmp(str, "icdisable") == 0) {
			mips_ic_disable = 1;
			continue;
		} else if (strcmp(str, "dcdisable") == 0) {
			mips_dc_disable = 1;
			continue;
		} else if (strcmp(str, "cwfoff") == 0) {
			mips_config_cwfon = 0;
			continue;
		} else if (strcmp(str, "wboff") == 0) {
			mips_config_wbon = 0;
			continue;
		}
#ifdef CONFIG_IP_PNP
		else if (strncmp(str, "ip=", 3) == 0) {
			if (strcmp(str + 3, "pmon") == 0) {
				use_pmon_ipaddr = 1;
				continue;
			} else {
				use_pmon_ipaddr = -1;
			}
		}
#endif
#ifdef CONFIG_BLK_DEV_INITRD
		else if (strncmp(str, "initrd=", 7) == 0) {
			/* "initrd=start,size" */
			int ints[3];
			get_options(str+7, ARRAY_SIZE(ints), ints);
			if (ints[0] == 2) {
				/* see arch/mips/kernel/setup.c */
				initrd_header[0] = 0x494E5244;
				initrd_header[1] = (unsigned long)ints[2];
				memmove(&initrd_header[2], (void *)ints[1],
					ints[2]);
				/* now setup_arch can find initrd */
			}
			continue;
		}
#endif
		strcat(arcs_cmdline, str);
		if (i < argc - 1)
			strcat(arcs_cmdline, " ");
	}
	pmon_printf("\n");

#if 0	/* Removed by Ethan on 04/21/2002 */
#ifdef CONFIG_IP_PNP
	/* use PMON's ipaddr if not specified */
#if !(defined(CONFIG_IP_PNP_BOOTP) || defined(CONFIG_IP_PNP_DHCP) || \
	defined(CONFIG_IP_PNP_RARP))
	if (use_pmon_ipaddr == 0) {
		use_pmon_ipaddr = 1;
		/* if "root=/dev/xxx" (except for /dev/nfs) is
		   specified, "ip=" may not be needed. */
		for (i = 1; i < argc; i++) {
			if (strncmp(argv[i], "root=", 5) == 0 &&
			    strcmp(argv[i]+5, "/dev/nfs") != 0) {
				use_pmon_ipaddr = 0;
				break;
			}
		}
	}
#endif
	if (use_pmon_ipaddr > 0) {
		char *ipaddr = NULL;
		char tmpstr[128];
		if (pmon_vector)
			ipaddr = pmon_vector->getenv("ipaddr");
		if (!ipaddr)
			ipaddr = "";
		sprintf(tmpstr, "ip=%s:::::eth0:", ipaddr);
		if (arcs_cmdline[0])
			strcat(arcs_cmdline, " ");
		strcat(arcs_cmdline, tmpstr);
	}
#endif /* CONFIG_IP_PNP */
#endif

	/* if cache enabled, flush and disable here */
	switch (mips_cpu.processor_id & 0xff00) {
	case PRID_IMP_TX39:	/* TX39 core */
		conf = read_32bit_cp0_register(CP0_CONF);
		if ((conf & (TX39_CONF_ICE | TX39_CONF_DCE)) != 0 &&
		    pmon_vector) {
			pmon_vector->flush_cache(1/*DCACHE*/);
			pmon_vector->flush_cache(0/*ICACHE*/);
			conf &= ~(TX39_CONF_ICE | TX39_CONF_DCE);
			write_32bit_cp0_register(CP0_CONF, conf);
		}
		break;
	case PRID_IMP_TX49:	/* TX49 core */
		conf = read_32bit_cp0_register(CP0_CONFIG);
		if ((conf & (TX49_CONF_IC | TX49_CONF_DC)) != (TX49_CONF_IC | TX49_CONF_DC) &&
		    pmon_vector) {
			pmon_vector->flush_cache(1/*DCACHE*/);
			pmon_vector->flush_cache(0/*ICACHE*/);
			conf |= (TX49_CONF_IC | TX49_CONF_DC);
			write_32bit_cp0_register(CP0_CONFIG, conf);
		}
		break;
	}

	return arch_prom_init(argc, argv, envp);
}

char * __init prom_getcmdline(void)
{
	return &(arcs_cmdline[0]);
}

void __init prom_free_prom_memory(void)
{
}

const char *get_system_type(void)
{
	static char system[32];
	int called = 0;
	const char *toshiba_system_strings[] = {
#if 1 /* does not support */
		"Unknown", "Unknown", "Unknown",
#else
		"Pallas", "TopasCE", "JMR",
#endif
		"JMR TX3927", "SDB R4xxx", "TX4927 EVB", "RBTX4927", "RBTX4925"
	};

	if (called == 0) {
		called = 1;
		strcpy(system, "Toshiba ");
		strcat(system, toshiba_system_strings[mips_machtype]);
	}

	return system;
}
