/*
 *  linux/arch/mips/toshiba-boards/rbtx4927/rtc.c
 * $Id: rtc.c,v 1.1.1.1 2004/04/07 08:36:50 louistsai Exp $
 *
 * RTC routines for Dallas chip.
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 2000-2001 Toshiba Corporation
 */
#include <asm/mc146818rtc.h>	/* bad name... */
#include <asm/toshiba-boards/rbtx4927.h>

static unsigned char rbtx4927_rtc_read_data(unsigned long addr)
{
	return *(rbtx4927_bramrtc_ptr + addr);
}

static void rbtx4927_rtc_write_data(unsigned char data, unsigned long addr)
{
	*(rbtx4927_bramrtc_ptr + addr) = data;
}

static int rbtx4927_rtc_bcd_mode(void)
{
	return 1;
}

struct rtc_ops rbtx4927_rtc_ops = {
	&rbtx4927_rtc_read_data,
	&rbtx4927_rtc_write_data,
	&rbtx4927_rtc_bcd_mode
};
