/*
 *  linux/arch/mips/toshiba-boards/tsdb/int-handler.S
 *
 * Copyright (C) 1999-2001 Toshiba Corporation
 *
 * $Id: int-handler.S,v 1.1.1.1 2004/04/07 08:36:50 louistsai Exp $
 */

#include <asm/asm.h>
#include <asm/mipsregs.h>
#include <asm/regdef.h>
#include <asm/stackframe.h>
#include <asm/toshiba-boards/tsdb.h>

	/* A lot of complication here is taken away because:
	 *
	 * 1) We handle one interrupt and return, sitting in a loop
	 *    and moving across all the pending IRQ bits in the cause
	 *    register is _NOT_ the answer, the common case is one
	 *    pending IRQ so optimize in that direction.
	 *
	 * 2) We need not check against bits in the status register
	 *    IRQ mask, that would make this routine slow as hell.
	 *
	 * 3) Linux only thinks in terms of all IRQs on or all IRQs
	 *    off, nothing in between like BSD spl() brain-damage.
	 *
	 * We handle the IRQ according to _our_ priority which is:
	 *
	 * Highest ----     R4k Timer
	 *                  USC (HeartBeat, etc.)
	 *                  IOC (UART, etc.)
	 *                  OnBoard Ether
	 * Lowest  ----     PCI
	 *
	 * then we just return, if multiple IRQs are pending then
	 * we will just take another exception, big deal.
	 */

	.text
	.set	noreorder
	.set	noat
	.align	5
	NESTED(tsdb_IRQ, PT_SIZE, sp)
	SAVE_ALL
	CLI
	.set	at
	lw	s0, PT_CAUSE(sp)
#if 1
	lw	t0, PT_STATUS(sp)		# get enabled interrupts
	and	s0, t0		# isolate allowed ones
#endif
#if 1 /* XXX DEBUG */
	srl	t0, s0, 8
	nor	t0, zero, t0
	lui	t1, %hi(TSDB_LED_ADDR)
	sb	t0, %lo(TSDB_LED_ADDR)(t1)
#endif
	andi	t0, s0, (CAUSEF_IP0 << TSDB_TIMER_INT)
#if 1 /* in case of tsdb_use_ext_timer != 0 */
	beqz	t0, 1f
	 nop
	mfc0	t0, CP0_STATUS
	andi	t0, (STATUSF_IP0 << TSDB_TIMER_INT)
#endif
	bnez	t0, local_int
	 li	a1, TSDB_IRQ_LOCAL_TIMER
1:
	andi	t0, s0, (CAUSEF_IP0 << TSDB_USC_INT)
	bnez	t0, usc_int
	 nop
	andi	t0, s0, (CAUSEF_IP0 << TSDB_IOC_INT)
	bnez	t0, ioc_int
	 nop
	andi	t0, s0, (CAUSEF_IP0 << TSDB_ETHER_INT)
	bnez	t0, local_int
	 li	a1, TSDB_IRQ_LOCAL_ETHER
	andi	t0, s0, (CAUSEF_IP0 << TSDB_PCI_INT)
	bnez	t0, pci_int
	 nop
	andi	t0, s0, (CAUSEF_IP0 << TSDB_SOFT_INT0)
	bnez	t0, local_int
	 li	a1, TSDB_IRQ_LOCAL_SOFT0
	andi	t0, s0, (CAUSEF_IP0 << TSDB_SOFT_INT1)
	bnez	t0, local_int
	 li	a1, TSDB_IRQ_LOCAL_SOFT1
	j	spurious_interrupt
	 nop
local_int:
	jal	tsdb_local_irqdispatch
	 move	a0, sp
	j	ret_from_irq
	 nop
usc_int:
	jal	tsdb_usc_irqdispatch
	 move	a0, sp
	j	ret_from_irq
	 nop
ioc_int:
	jal	tsdb_ioc_irqdispatch
	 move	a0, sp
	j	ret_from_irq
	 nop
pci_int:
	jal	tsdb_pci_irqdispatch
	 move	a0, sp
	bltz	v0,1f
	 nop
	j	ret_from_irq
	 nop
1:
	j	spurious_interrupt
	 nop
	END(tsdb_IRQ)
