/*
 *  linux/arch/mips/toshiba-boards/tsdb/time.c
 *
 * Copyright (C) 1999-2001 Toshiba Corporation
 *
 * $Id: time.c,v 1.1.1.1 2004/04/07 08:36:50 louistsai Exp $
 */
#include <linux/errno.h>
#include <linux/init.h>
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/param.h>
#include <linux/string.h>
#include <linux/mm.h>
#include <linux/interrupt.h>

#include <asm/bootinfo.h>
#include <asm/mipsregs.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/cpu.h>
#include <asm/time.h>

#include <asm/toshiba-boards/tsdb.h>

#if 1	/* XXX */
int tsdb_timer_led = 0;
#endif

static void
tsdb_timer_interrupt(int irq, void *dev_id, struct pt_regs *regs)
{
	timer_interrupt(irq, dev_id, regs);

#if 1	/* XXX blink led */
	if (tsdb_timer_led && jiffies % HZ == 0)
		tsdb_led_toggle(0);
#endif
}


/* We use onchip r4k counter or USC timer as our system wide timer interrupt running at 100HZ. */
int tsdb_use_ext_timer = 0;

extern void rtc_ds1742_init(void);
extern void rtc_ds1553_init(void);

void __init tsdb_time_init(void)
{
	unsigned int ct0;
	struct v320usc_reg *usc = (struct v320usc_reg *)TSDB_USC_BASE;
	int i;

	if (mips_cpu.cputype == CPU_TX39XX)
		tsdb_use_ext_timer = 1;

	if (tsdb_old_rtc()) {
		rtc_ds1742_init();
	} else {
		rtc_ds1553_init();
	}

	printk("calculating counter_frequency... ");

	/* clear HeartBeat Int. */
	usc->int_stat = USC_INTF_HBI;
	/* waiting for a new tick. */
	while (!(usc->int_stat & USC_INTF_HBI))
		;
	ct0 = read_32bit_cp0_register(CP0_COUNT);
	for (i = 0; i < 16; i++) {
		/* clear HeartBeat Int. */
		usc->int_stat = USC_INTF_HBI;
		/* waiting for a next tick. */
		while (!(usc->int_stat & USC_INTF_HBI))
			;
	}
	mips_counter_frequency =
		(read_32bit_cp0_register(CP0_COUNT) - ct0) / 16 * HZ;
}

extern int setup_irq(unsigned int irq, struct irqaction *irqaction);
void __init tsdb_timer_setup(struct irqaction *irq)
{
	/* wrap default timer interupt handler */
	irq->handler = tsdb_timer_interrupt;

	if (tsdb_use_ext_timer) {
		/* disable counter interrupt(IM7) */
		clear_cp0_status(STATUSF_IP7);

		/* enable USC heartbeat interrupt */
		setup_irq(TSDB_IRQ_USC_HBI, irq);
	} else {
		unsigned int count;

		/* we are using the cpu counter for timer interrupts */
		setup_irq(TSDB_IRQ_LOCAL_TIMER, irq);

		/* to generate the first timer interrupt */
		count = read_32bit_cp0_register(CP0_COUNT);
		write_32bit_cp0_register(CP0_COMPARE, count + mips_counter_frequency / HZ);
	}
	printk("%08x(%d)\n", mips_counter_frequency, mips_counter_frequency);
}
