/* $Id: kbd.c,v 1.1.1.1 2004/04/07 08:36:50 louistsai Exp $
 *
 * Based on arch/mips/lib/kbd-std.c
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Routines for standard PC style keyboards accessible via I/O ports.
 *
 * Copyright (C) 2000-2001 Toshiba Corporation
 */
#include <linux/config.h>
#include <linux/ioport.h>
#include <linux/sched.h>
#include <linux/pc_keyb.h>
#include <asm/keyboard.h>
#include <asm/io.h>
#include <asm/toshiba-boards/tx4927evb.h>

#define KEYBOARD_IRQ	TX4927EVB_IRQ_IOC_KB
#define AUX_IRQ	TX4927EVB_IRQ_IOC_MOUSE
#define TX4927EVB_KBD_PORT	(TX4927EVB_KBD_ADDR - mips_io_port_base)
#define TX4927EVB_KBD_DATA_REG	TX4927EVB_KBD_PORT
#define TX4927EVB_KBD_STATUS_REG	(TX4927EVB_KBD_PORT+4)
#define TX4927EVB_KBD_CNTL_REG	(TX4927EVB_KBD_PORT+4)

static void tx4927evb_kbd_request_region(void)
{
	request_region(TX4927EVB_KBD_PORT, 16, "keyboard");
}

static int tx4927evb_kbd_request_irq(void (*handler)(int, void *, struct pt_regs *))
{
	return request_irq(KEYBOARD_IRQ, handler, 0, "keyboard", NULL);
}

static int tx4927evb_aux_request_irq(void (*handler)(int, void *, struct pt_regs *))
{
	return request_irq(AUX_IRQ, handler, 0, "PS/2 Mouse", NULL);
}

static void tx4927evb_aux_free_irq(void)
{
	free_irq(AUX_IRQ, NULL);
}

static unsigned char tx4927evb_kbd_read_input(void)
{
	return inb(TX4927EVB_KBD_DATA_REG);
}

static void tx4927evb_kbd_write_output(unsigned char val)
{
	int status;

	do {
		status = inb(TX4927EVB_KBD_CNTL_REG);
	} while (status & KBD_STAT_IBF);
	outb(val, TX4927EVB_KBD_DATA_REG);
	wbflush();
}

static void tx4927evb_kbd_write_command(unsigned char val)
{
	int status;

	do {
		status = inb(TX4927EVB_KBD_CNTL_REG);
	} while (status & KBD_STAT_IBF);
	outb(val, TX4927EVB_KBD_CNTL_REG);
	wbflush();
}

static unsigned char tx4927evb_kbd_read_status(void)
{
	return inb(TX4927EVB_KBD_STATUS_REG);
}

struct kbd_ops tx4927evb_kbd_ops = {
	tx4927evb_kbd_request_region,
	tx4927evb_kbd_request_irq,

	tx4927evb_aux_request_irq,
	tx4927evb_aux_free_irq,

	tx4927evb_kbd_read_input,
	tx4927evb_kbd_write_output,
	tx4927evb_kbd_write_command,
	tx4927evb_kbd_read_status
};
