/*
 * linux/arch/mips/toshiba-boards/tx4927evb/setup.c
 * $Id: setup.c,v 1.1.1.1 2004/04/07 08:36:50 louistsai Exp $
 *
 * Setup pointers to hardware-dependent routines.
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 2000-2001 Toshiba Corporation
 */

#include <linux/config.h>
#include <linux/init.h>
#include <linux/types.h>
#include <linux/ioport.h>
#include <linux/kdev_t.h>
#include <linux/pci.h>
#include <linux/delay.h>
#include <asm/system.h>
#include <asm/reboot.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/toshiba-boards/pmon.h>
#include <asm/toshiba-boards/pci.h>
#include <asm/toshiba-boards/tx4927evb.h>
#include <asm/mc146818rtc.h>	/* bad name... */
#include <asm/ns87338.h>
#include <asm/bootinfo.h>
#include <asm/cpu.h>
#include <asm/pci.h>
#include <asm/time.h>
#include <asm/mipsregs.h>
#include <asm/ptrace.h>
#include <asm/keyboard.h>
#if defined(CONFIG_SERIAL)
#include <linux/serial.h>
#include <asm/serial.h>
#endif
#if defined(CONFIG_SERIAL_TXX927)
#include <asm/serial_txx927.h>
#endif

/*static*/ int tx4927evb_ccfg_toeon = 1;
/*static*/ int tx4927evb_pcic_trdyto = 0;	/* default: disabled */

extern struct rtc_ops tx4927evb_rtc_ops;
extern struct kbd_ops tx4927evb_kbd_ops;
extern struct pci_ops tx4927evb_pci_ops;
extern int tx4927evb_pci_map_irq(struct pci_dev *dev, u8 slot, u8 pin);
extern void tx4927evb_irq_setup(void) __init;
extern void tx4927evb_time_init(void) __init;
extern void tx4927evb_timer_setup(struct irqaction *irq) __init;
extern int mips_parport_base;
extern int mips_parport_irq;

#ifdef CONFIG_REMOTE_DEBUG
extern int __init early_serial_kgdb_setup(struct serial_struct *req);
extern int __init early_serial_txx927_kgdb_setup(int line, unsigned long base, int irq, int baud_base);
extern void breakpoint(void);
#define TOMON(s) printk(s); breakpoint(); pmon_halt()
#else
#define TOMON(s) pmon_printf(s); pmon_halt()
#endif
extern void wait_for_keypress(void);

static inline void printk_ll(const char *fmt, unsigned long long val)
{
	printk(fmt, (unsigned long)(val >> 32), (unsigned long)val);
}

static void tx4927evb_machine_restart(char *command)
{
	cli();
	printk("Rebooting...");
	*tx4927evb_softreset_ptr = 1;
}

static void tx4927evb_machine_halt(void)
{
	cli();
	printk("Press any key to reboot.\n");
	wait_for_keypress();
	*tx4927evb_softreset_ptr = 1;
}

static void tx4927evb_machine_power_off(void)
{
	cli();
	printk("Press any key to reboot.\n");
	wait_for_keypress();
	*tx4927evb_softreset_ptr = 1;
}

extern void (*ibe_board_handler)(struct pt_regs *regs);
extern void (*dbe_board_handler)(struct pt_regs *regs);
static void tx4927evb_be_board_handler(struct pt_regs *regs)
{
	extern void tx4927_report_pcic_status(void);
        printk("%cBE exception at 0x%08lx\n",
	       (regs->cp0_cause & (1<<2)) ? 'D' : 'I', regs->cp0_epc);
        printk("ccfg:%08lx, ", (unsigned long)tx4927_ccfgptr->ccfg);
        printk_ll("tear:%02lx_%08lx\n", tx4927_ccfgptr->tear);
	tx4927_report_pcic_status();
	show_regs(regs);
	TOMON("BusError!\n");
	while(1);
}
void __init tx4927evb_setup_be_board_handler(void)
{
	ibe_board_handler = tx4927evb_be_board_handler;
	dbe_board_handler = tx4927evb_be_board_handler;
}

/* utility routines for LED Display */
void tx4927evb_leddisp_puts(const char *s)
{
	int i;
	for (i = 0; i < 8; i++) {
		char c;
		if (*s)
			c = *s++;
		else
			c = ' ';
		tx4927evb_leddisp_putc(i, c);
	}
}
void tx4927evb_leddisp_put(unsigned long val)
{
	int i;
	for (i = 7; i >= 0; i--) {
		unsigned char v = val & 0x0f;
		char c = v < 10 ? (v + '0') : (v - 10 + 'A');
		tx4927evb_leddisp_putc(i, c);
		val >>= 4;
	}
}

int tx4927evb_gbus_clock = 100000000; /* 100MHz */
static int tx4927evb_master_clock = 100000000; /* 100MHz */
static int tx4927evb_cpu_clock = 200000000; /* 200MHz */
int tx4927evb_pci66;	/* 0:auto, 1:on(force), -1:off(disable) */

unsigned long tx4927evb_ce_base[8];
static unsigned long tx4927evb_ce_size[8];

#ifdef CONFIG_PCI
static void __init tx4927evb_pci66_setup(void)
{
	int pciclk, pciclkin = 1;

	if (tx4927_ccfgptr->ccfg & TX4927_CCFG_PCI66)
		return;

	/* Reset PCI Bus */
	*tx4927evb_pcireset_ptr = 1;
	/* Reset PCIC */
	tx4927_ccfgptr->clkctr |= TX4927_CLKCTR_PCIRST;

	/* Assert M66EN */
	tx4927_ccfgptr->ccfg |= TX4927_CCFG_PCI66;
	/* set PCICLK 66MHz */
	if (tx4927_ccfgptr->pcfg & TX4927_PCFG_PCICLKEN_ALL) {
		unsigned int pcidivmode = 0;
		pcidivmode = (unsigned long)tx4927_ccfgptr->ccfg & TX4927_CCFG_PCIDIVMODE_MASK;
		if (tx4927evb_cpu_clock >= 170000000) {
			/* CPU 200MHz */
			pcidivmode = TX4927_CCFG_PCIDIVMODE_3;
			pciclk = tx4927evb_cpu_clock / 3;
		} else {
			/* CPU 166MHz */
			pcidivmode = TX4927_CCFG_PCIDIVMODE_2_5;
			pciclk = tx4927evb_cpu_clock * 2 / 5;
		}
		tx4927_ccfgptr->ccfg =
			(tx4927_ccfgptr->ccfg & ~TX4927_CCFG_PCIDIVMODE_MASK)
			| pcidivmode;
		printk(KERN_DEBUG "PCICLK: ccfg:%08lx\n",
		       (unsigned long)tx4927_ccfgptr->ccfg);
	} else {
		int pciclk_setting = *tx4927evb_pci_clk_ptr;
		/* Workaround for older FPGA */
		if (*tx4927evb_fpga_rev_ptr <= 3)
			pciclk_setting <<= 3;
		pciclkin = 0;
		pciclk = 66666666;
		pciclk_setting &= ~TX4927EVB_PCI_CLK_MASK;
		pciclk_setting |= TX4927EVB_PCI_CLK_66;
		*tx4927evb_pci_clk_ptr = pciclk_setting;
		printk(KERN_DEBUG "PCICLK: pci_clk:%02x\n",
		       *tx4927evb_pci_clk_ptr);
	}

	udelay(10000);

	/* clear PCIC reset */
	tx4927_ccfgptr->clkctr &= ~TX4927_CLKCTR_PCIRST;
	/* clear PCI reset */
	*tx4927evb_pcireset_ptr = 0;
}

/* setup tx4927evb_pci_{mem,io}_{base,size} */
static unsigned long tx4927evb_pci_mem_base;
static unsigned long tx4927evb_pci_mem_size = 0x08000000;	/* MAX 128M */
static unsigned long tx4927evb_pci_io_base;
static unsigned long tx4927evb_pci_io_size = 0x01000000;	/* MAX 16M */

static unsigned long __init
tx4927evb_setup_pci_region(int n,
			   unsigned long *bases,
			   unsigned long *sizes,
			   unsigned long begin,
			   unsigned long end,
			   unsigned long *size)
{
	unsigned long base;
	unsigned long sz = *size;
	int i;

	for (; sz; sz /= 2) {
		for (base = begin / sz * sz; base < end; base += sz) {
			for (i = 0; i < n; i++) {
				if (sizes[i] &&
				    base <= bases[i] + (sizes[i] - 1) &&
				    base + (sz - 1) >= bases[i])
					break;
			}
			if (i == n) {
				*size = sz;
				return base;
			}
		}
	}
	return 0;
}
static void __init tx4927evb_setup_pci_regions(void)
{
	unsigned long base[4+8+1];
	unsigned long size[4+8+1];
	unsigned long mbegin, mend;
	int i;

	if (tx4927evb_pci_mem_base || tx4927evb_pci_io_base)
		return;	/* done */

	for (i = 0; i < sizeof(base) / sizeof(base[0]); i++)
		base[i] = size[i] = 0;
	for (i = 0; i < 4; i++) {
		if (!((unsigned long)tx4927_sdramcptr->cr[i] & 0x00000400))
			continue;	/* disabled */
		base[i] = (unsigned long)(tx4927_sdramcptr->cr[i] >> 49) << 21;
		size[i] = ((unsigned long)(tx4927_sdramcptr->cr[i] >> 33) + 1) << 21;
	}
	for (i = 0; i < 8; i++) {
		if (!((unsigned long)tx4927_ebuscptr->cr[i] & 0x8))
			continue;	/* disabled */
		base[i+4] = tx4927evb_ce_base[i];
		size[i+4] = tx4927evb_ce_size[i];
	}
	mbegin = base[0] + size[0];	/* end of SDRAM ch 0 */
	mend = base[4];	/* begin of CE0 */

	tx4927evb_pci_mem_base =
		tx4927evb_setup_pci_region(sizeof(base) / sizeof(base[0]),
					   base, size, mbegin, mend,
					   &tx4927evb_pci_mem_size);
	base[4+8] = tx4927evb_pci_mem_base;
	size[4+8] = tx4927evb_pci_mem_size;

	tx4927evb_pci_io_base =
		tx4927evb_setup_pci_region(sizeof(base) / sizeof(base[0]),
					   base, size, mbegin, mend,
					   &tx4927evb_pci_io_size);
}

static void __init tx4927evb_pci_setup(void)
{
	static int called = 0;
	int i;
	if (!called) {
		printk("TX4927 PCIC -- DID:%04x VID:%04x RID:%02x Arbiter:%s\n",
		       (unsigned short)(tx4927_pcicptr->pciid >> 16),
		       (unsigned short)(tx4927_pcicptr->pciid & 0xffff),
		       (unsigned short)(tx4927_pcicptr->pciccrev & 0xff),
		       (!(tx4927_ccfgptr->ccfg & TX4927_CCFG_PCIXARB)) ? "External" : "Internal");
		called = 1;
	}
	printk("TX4927 PCIC --%s PCICLK:",
	       (tx4927_ccfgptr->ccfg & TX4927_CCFG_PCI66) ? " PCI66" : "");
	if (tx4927_ccfgptr->pcfg & TX4927_PCFG_PCICLKEN_ALL) {
		int pciclk = 0;
		switch ((unsigned long)tx4927_ccfgptr->ccfg & TX4927_CCFG_PCIDIVMODE_MASK) {
		case TX4927_CCFG_PCIDIVMODE_2_5:
			pciclk = tx4927evb_cpu_clock * 2 / 5; break;
		case TX4927_CCFG_PCIDIVMODE_3:
			pciclk = tx4927evb_cpu_clock / 3; break;
		case TX4927_CCFG_PCIDIVMODE_5:
			pciclk = tx4927evb_cpu_clock / 5; break;
		case TX4927_CCFG_PCIDIVMODE_6:
			pciclk = tx4927evb_cpu_clock / 6; break;
		}
		printk("Internal(%dMHz)", pciclk / 1000000);
	} else {
		int pciclk = 0;
		int pciclk_setting = *tx4927evb_pci_clk_ptr;
		/* Workaround for older FPGA */
		if (*tx4927evb_fpga_rev_ptr <= 3)
			pciclk_setting <<= 3;
		switch (pciclk_setting & TX4927EVB_PCI_CLK_MASK) {
		case TX4927EVB_PCI_CLK_33:
			pciclk = 33333333; break;
		case TX4927EVB_PCI_CLK_25:
			pciclk = 25000000; break;
		case TX4927EVB_PCI_CLK_66:
			pciclk = 66666666; break;
		case TX4927EVB_PCI_CLK_50:
			pciclk = 50000000; break;
		}
		printk("External(%dMHz)", pciclk / 1000000);
	}
	printk("\n");

	/* GB->PCI mappings */
	tx4927_pcicptr->g2piomask = (tx4927evb_pci_io_size - 1) >> 4;
	tx4927_pcicptr->g2piogbase = tx4927evb_pci_io_base |
#ifdef __BIG_ENDIAN
		TX4927_PCIC_G2PIOGBASE_ECHG
#else
		TX4927_PCIC_G2PIOGBASE_BSDIS
#endif
		;
	tx4927_pcicptr->g2piopbase = 0;
	for (i = 0; i < 3; i++) {
		tx4927_pcicptr->g2pmmask[i] = 0;
		tx4927_pcicptr->g2pmgbase[i] = 0;
		tx4927_pcicptr->g2pmpbase[i] = 0;
	}
	if (tx4927evb_pci_mem_base) {
		tx4927_pcicptr->g2pmmask[0] = (tx4927evb_pci_mem_size - 1) >> 4;
		tx4927_pcicptr->g2pmgbase[0] = tx4927evb_pci_mem_base |
#ifdef __BIG_ENDIAN
			TX4927_PCIC_G2PMnGBASE_ECHG
#else
			TX4927_PCIC_G2PMnGBASE_BSDIS
#endif
			;
		tx4927_pcicptr->g2pmpbase[0] = tx4927evb_pci_mem_base;
	}
	/* PCI->GB mappings (I/O 256B) */
	tx4927_pcicptr->p2giopbase = 0; /* 256B */
	tx4927_pcicptr->p2giogbase = 0;
	/* PCI->GB mappings (MEM 512MB (64MB on R1.x)) */
	tx4927_pcicptr->p2gm0plbase = 0;
	tx4927_pcicptr->p2gm0pubase = 0;
	tx4927_pcicptr->p2gmgbase[0] = 0 |
		TX4927_PCIC_P2GMnGBASE_TMEMEN |
#ifdef __BIG_ENDIAN
		TX4927_PCIC_P2GMnGBASE_TECHG
#else
		TX4927_PCIC_P2GMnGBASE_TBSDIS
#endif
		;
	/* PCI->GB mappings (MEM 16MB) */
	tx4927_pcicptr->p2gm1plbase = 0xffffffff;
	tx4927_pcicptr->p2gm1pubase = 0xffffffff;
	tx4927_pcicptr->p2gmgbase[1] = 0;
	/* PCI->GB mappings (MEM 1MB) */
	tx4927_pcicptr->p2gm2pbase = 0xffffffff; /* 1MB */
	tx4927_pcicptr->p2gmgbase[2] = 0;

	tx4927_pcicptr->pciccfg &= TX4927_PCIC_PCICCFG_LBWC_MASK;
	/* Enable Initiator Memory Space */
	if (tx4927evb_pci_mem_base)
		tx4927_pcicptr->pciccfg |= TX4927_PCIC_PCICCFG_IMSE(0);
	/* Enable Initiator I/O Space, Config */
	tx4927_pcicptr->pciccfg |=
		TX4927_PCIC_PCICCFG_IISE |
		TX4927_PCIC_PCICCFG_ICAE |
		TX4927_PCIC_PCICCFG_ATR;

	/* Do not use MEMMUL, MEMINF: YMFPCI card causes M_ABORT. */
	tx4927_pcicptr->pcicfg1 = 0;

	if (tx4927evb_pcic_trdyto >= 0) {
		tx4927_pcicptr->g2ptocnt &= ~0xff;
		tx4927_pcicptr->g2ptocnt |= (tx4927evb_pcic_trdyto & 0xff);
		printk(KERN_DEBUG "TX4927 PCIC -- TRDYTO:%02lx\n",
		       tx4927_pcicptr->g2ptocnt & 0xff);
	}

	/* Clear All Local Bus Status */
	tx4927_pcicptr->pcicstatus = TX4927_PCIC_PCICSTATUS_ALL;
	/* Enable All Local Bus Interrupts */
	tx4927_pcicptr->pcicmask = TX4927_PCIC_PCICSTATUS_ALL;
	/* Clear All Initiator Status */
	tx4927_pcicptr->g2pstatus = TX4927_PCIC_G2PSTATUS_ALL;
	/* Enable All Initiator Interrupts */
	tx4927_pcicptr->g2pmask = TX4927_PCIC_G2PSTATUS_ALL;
	/* Clear All PCI Status Error */
	tx4927_pcicptr->pcistatus =
		(tx4927_pcicptr->pcistatus & 0x0000ffff) |
		(TX4927_PCIC_PCISTATUS_ALL << 16);
	/* Enable All PCI Status Error Interrupts */
	tx4927_pcicptr->pcimask = TX4927_PCIC_PCISTATUS_ALL;

	/* PCIC Int => IRC IRQ16 */
	tx4927_pcicptr->pcicfg2 =
		(tx4927_pcicptr->pcicfg2 & 0xffffff00) |
		TX4927_IR_PCIC;

	if (!(tx4927_ccfgptr->ccfg & TX4927_CCFG_PCIXARB)) {
		/* XXX */
	} else {
		/* Reset Bus Arbiter */
		tx4927_pcicptr->pbacfg = TX4927_PCIC_PBACFG_RPBA;
		/*
		 * swap reqBP and reqXP (raise priority of PCI-ISA bridge).
		 * SLC90E66(PCI-ISA bridge) are connected to REQ2 on
		 * PCI Backplane board.
		 */
		tx4927_pcicptr->pbareqport = 0x72543610;
		tx4927_pcicptr->pbabm = 0;
		/* Use Fixed ParkMaster (required by PCI-ISA bridge) */
		tx4927_pcicptr->pbacfg = TX4927_PCIC_PBACFG_FIXPA;
		/* Enable Bus Arbiter */
		tx4927_pcicptr->pbacfg |= TX4927_PCIC_PBACFG_PBAEN;
	}

	tx4927_pcicptr->pcistatus = PCI_COMMAND_MASTER |
		PCI_COMMAND_MEMORY |
		PCI_COMMAND_PARITY | PCI_COMMAND_SERR;
}
#endif /* CONFIG_PCI */

static void __init tx4927_setup(void)
{
	int i;
	int cpuclk = 0;
	unsigned long divmode;

	/* SDRAMC,EBUSC are configured by PROM */
	for (i = 0; i < 8; i++) {
		if (!(tx4927_ebuscptr->cr[i] & 0x8))
			continue;	/* disabled */
		tx4927evb_ce_base[i] = (unsigned long)(tx4927_ebuscptr->cr[i] >> 48) << 20;
		tx4927evb_ce_size[i] = 0x00100000 << ((unsigned long)(tx4927_ebuscptr->cr[i] >> 8) & 0xf);
	}

	/*
	 * ASSUMPTION: PCIDIVMODE is configured for PCI 33MHz or 66MHz.
	 * PCIDIVMODE[12:11]'s initial value are given by S9[4:3] (ON:0, OFF:1).
	 * CPU 166MHz: PCI 66MHz : PCIDIVMODE: 00 (1/2.5)
	 * CPU 200MHz: PCI 66MHz : PCIDIVMODE: 01 (1/3)
	 * CPU 166MHz: PCI 33MHz : PCIDIVMODE: 10 (1/5)
	 * CPU 200MHz: PCI 33MHz : PCIDIVMODE: 11 (1/6)
	 * i.e. S9[3]: ON (83MHz), OFF (100MHz)
	 */
	switch ((unsigned long)tx4927_ccfgptr->ccfg & TX4927_CCFG_PCIDIVMODE_MASK) {
	case TX4927_CCFG_PCIDIVMODE_2_5:
	case TX4927_CCFG_PCIDIVMODE_5:
		cpuclk = 166000000;	/* 166MHz */
		break;
	default:
		cpuclk = 200000000;	/* 200MHz */
	}
	tx4927evb_cpu_clock = cpuclk;
	/* ASSUMPTION: DIVMODE is configured for CPU 166MHz or 200MHz. */
	divmode = (unsigned long)tx4927_ccfgptr->ccfg & TX4927_CCFG_DIVMODE_MASK;
	switch (divmode) {
	case TX4927_CCFG_DIVMODE_2:
		tx4927evb_gbus_clock = cpuclk / 2; break;
	case TX4927_CCFG_DIVMODE_3:
		tx4927evb_gbus_clock = cpuclk / 3; break;
	case TX4927_CCFG_DIVMODE_4:
		tx4927evb_gbus_clock = cpuclk / 4; break;
	case TX4927_CCFG_DIVMODE_2_5:
		tx4927evb_gbus_clock = cpuclk * 2 / 5; break;
	}
	switch ((unsigned long)tx4927_ccfgptr->ccfg & TX4927_CCFG_DIVMODE2_MASK) {
	case TX4927_CCFG_DIVMODE2_1:
		tx4927evb_master_clock = tx4927evb_gbus_clock; break;
	case TX4927_CCFG_DIVMODE2_4:
		tx4927evb_master_clock = tx4927evb_gbus_clock / 4; break;
	}

	/* CCFG */
	/* enable Timeout BusError */
	if (tx4927evb_ccfg_toeon)
		tx4927_ccfgptr->ccfg |= TX4927_CCFG_TOE;

	/* clear BusErrorOnWrite flag */
	tx4927_ccfgptr->ccfg &= ~TX4927_CCFG_BEOW;

	/* DMA selection */
	tx4927_ccfgptr->pcfg &= ~TX4927_PCFG_DMASEL_ALL;

	printk("TX4927 -- %dMHz(M%dMHz) CRIR:%08lx ",
	       cpuclk / 1000000, tx4927evb_master_clock / 1000000,
	       (unsigned long)tx4927_ccfgptr->crir);
	printk_ll("CCFG:%03lx_%08lx ", tx4927_ccfgptr->ccfg);
	printk_ll("PCFG:%08lx_%08lx\n", tx4927_ccfgptr->pcfg);

	printk("TX4927 SDRAMC --");
	for (i = 0; i < 4; i++) {
		unsigned long ram_base;
		if (!((unsigned long)tx4927_sdramcptr->cr[i] & 0x00000400))
			continue;	/* disabled */
		ram_base = (unsigned long)(tx4927_sdramcptr->cr[i] >> 49) << 21;
		if (ram_base >= 0x20000000)
			continue;	/* high memory (ignore) */
		printk(" CR%d:", i);
		printk_ll("%08lx_%08lx", tx4927_sdramcptr->cr[i]);
	}
	printk_ll(" TR:%01lx_%08lx\n", tx4927_sdramcptr->tr);

	/* IRC */
	/* disable interrupt control */
	tx4927_ircptr->cer = 0;
	/* mask all IRC interrupts */
	tx4927_ircptr->imr = 0;
	for (i = 0; i < TX4927_NUM_IR / 4; i++) {
		tx4927_ircptr->ilr[i] = 0;
	}
	/* setup IRC interrupt mode (Low Active) */
	for (i = 0; i < TX4927_NUM_IR / 16; i++) {
		tx4927_ircptr->cr[i] = 0;
	}

	/* TMR */
	/* disable all timers */
	for (i = 0; i < TX4927_NR_TMR; i++) {
		tx4927_tmrptr(i)->tcr = TXx927_TMTCR_CRE;
		tx4927_tmrptr(i)->tisr = 0;
		tx4927_tmrptr(i)->cpra = 0xffffffff;
		tx4927_tmrptr(i)->itmr = 0;
		tx4927_tmrptr(i)->ccdr = 0;
		tx4927_tmrptr(i)->pgmr = 0;
	}

	/* DMA */
	tx4927_dmaptr->mcr = 0;
	for (i = 0; i < sizeof(tx4927_dmaptr->ch) / sizeof(tx4927_dmaptr->ch[0]); i++) {
		/* reset channel */
		tx4927_dmaptr->ch[i].ccr = TX4927_DMA_CCR_CHRST;
#ifdef __BIG_ENDIAN
		tx4927_dmaptr->ch[i].ccr = 0;
#else
		tx4927_dmaptr->ch[i].ccr = TX4927_DMA_CCR_LE;
#endif
	}
	/* enable DMA */
	tx4927_dmaptr->mcr = TX4927_DMA_MCR_MSTEN;

	/* PCIC */
#ifdef CONFIG_PCI
	tx4927evb_setup_pci_regions();
	if (tx4927evb_pci66 > 0) {
		tx4927evb_pci66_setup();
	} else {
		/* Reset PCI Bus */
		*tx4927evb_pcireset_ptr = 1;
		/* Reset PCIC */
		tx4927_ccfgptr->clkctr |= TX4927_CLKCTR_PCIRST;
		udelay(10000);
		/* clear PCIC reset */
		tx4927_ccfgptr->clkctr &= ~TX4927_CLKCTR_PCIRST;
		*tx4927evb_pcireset_ptr = 0;
	}
	tx4927evb_pci_setup();
#endif

	/* PIO */
	tx4927_pioptr->maskcpu = 0;
	tx4927_pioptr->maskext = 0;
}

/* callback routine from pcibios_init() */
static void __init tx4927evb_pci66_init(void)
{
	tx4927evb_pci66_setup();
	/* Reinitialize PCIC */
	tx4927evb_pci_setup();
}

extern int early_premier3_setup(unsigned long base, int irq);
extern int toshibaboards_probe_ieee1394_board(unsigned long base);
static void __init tx4927evb_check_ieee1394_board(void)
{
	unsigned long long ebccr2;

	ebccr2 = tx4927_ebuscptr->cr[2];
	/* Normal submode */
	tx4927_ebuscptr->cr[2] =
		(ebccr2 & 0xffffffffffc00000ull) | 0x0010f208;
	printk_ll(KERN_DEBUG "EBCCR2 %08lx_%08lx\n", tx4927_ebuscptr->cr[2]);
	if (toshibaboards_probe_ieee1394_board(TX4927EVB_PREMIER3_BASE) == 0) {
		/* External ACK* submode */
		tx4927_ebuscptr->cr[2] =
			(ebccr2 & 0xffffffffffc00000ull) | 0x0013f208;
#ifdef CONFIG_IEEE1394_PREMIER3
		early_premier3_setup(TX4927EVB_PREMIER3_BASE, TX4927EVB_IRQ_PREMIER3);
#endif
	} else {
		tx4927_ebuscptr->cr[2] = ebccr2;
	}
	printk_ll(KERN_DEBUG "EBCCR2 %08lx_%08lx\n", tx4927_ebuscptr->cr[2]);
}

static struct resource tx4927evb_ebus_resources[8] = {
	{ "EBUS0", 0, 0, IORESOURCE_MEM },
	{ "EBUS1", 0, 0, IORESOURCE_MEM },
	{ "EBUS2", 0, 0, IORESOURCE_MEM },
	{ "EBUS3", 0, 0, IORESOURCE_MEM },
	{ "EBUS4", 0, 0, IORESOURCE_MEM },
	{ "EBUS5", 0, 0, IORESOURCE_MEM },
	{ "EBUS6", 0, 0, IORESOURCE_MEM },
	{ "EBUS7", 0, 0, IORESOURCE_MEM },
};
static struct resource tx4927_reg_resource = {
	"TX4927", TX4927_REG_BASE, TX4927_REG_BASE+TX4927_REG_SIZE, IORESOURCE_MEM
};

static struct resource tx4927evb_fpga_resource;

void __init tx4927evb_setup(void)
{
	int i;
	unsigned char spio_id;
#if defined(CONFIG_SERIAL)
	struct serial_struct req;
#endif
	unsigned long spio_config;

	tx4927_setup();

	board_time_init = tx4927evb_time_init;
	board_timer_setup = tx4927evb_timer_setup;
	irq_setup = tx4927evb_irq_setup;
	/* map ioport 0 to PCI I/O space address 0 */
	set_io_port_base(KSEG1ADDR(tx4927evb_pci_io_base));

	/* setup PCI area */
	toshibaboards_pci_io_resource.start = 0;
	toshibaboards_pci_io_resource.end = tx4927evb_pci_io_size - 1;
	toshibaboards_pci_mem_resource.start = tx4927evb_pci_mem_base;
	toshibaboards_pci_mem_resource.end =
		tx4927evb_pci_mem_base + tx4927evb_pci_mem_size - 1;

	/* TX4927 internal registers */
	iomem_resource.end = 0xffffffff;	/* 4GB */
	request_resource(&iomem_resource, &tx4927_reg_resource);
	/* reserve EBUS area */
	for (i = 0; i < 8; i++) {
		tx4927evb_ebus_resources[i].start = tx4927evb_ce_base[i];
		tx4927evb_ebus_resources[i].end =
			tx4927evb_ce_base[i] + tx4927evb_ce_size[i] - 1;
		if (tx4927evb_ebus_resources[i].start) {
			request_resource(&iomem_resource,
					 &tx4927evb_ebus_resources[i]);
		}
	}
	tx4927evb_fpga_resource.name = "FPGA Registers";
	tx4927evb_fpga_resource.start =
		virt_to_bus((void *)TX4927EVB_FPGA_REG_ADDR);
	tx4927evb_fpga_resource.end =
		virt_to_bus((void *)TX4927EVB_FPGA_REG_ADDR) + 0x32 - 1;
	tx4927evb_fpga_resource.flags = IORESOURCE_MEM | IORESOURCE_BUSY;
	request_resource(&tx4927evb_ebus_resources[3], &tx4927evb_fpga_resource);

	/* disable all OnBoard I/O interrupts */
	for (i = 0; i < TX4927EVB_NUM_IOC_INTREGS; i++)
		*tx4927evb_imask_ptr(i) = 0;

	_machine_restart = tx4927evb_machine_restart;
	_machine_halt = tx4927evb_machine_halt;
	_machine_power_off = tx4927evb_machine_power_off;

#ifdef CONFIG_VT
	kbd_ops = &tx4927evb_kbd_ops;
#endif
	rtc_ops = &tx4927evb_rtc_ops;
	toshibaboards_pci_ops = &tx4927evb_pci_ops;
	if (tx4927evb_pci66 == 0)
		toshibaboards_pci66_init = tx4927evb_pci66_init;
	toshibaboards_pci_map_irq = tx4927evb_pci_map_irq;

	/* TX4927-SIO DTR on */
	*tx4927evb_sio_stat_ptr = 0;

	/* Enable Serial/Parallel Port (may be done by Monitor) */
	spio_config = TX4927EVB_SUPERIO_CONFIG - mips_io_port_base;
	ns87338_writeb(spio_config, FER,
		       ns87338_readb(spio_config, FER) |
		       FER_SCC1 | FER_SCC2 | FER_LPT);
	ns87338_writeb(spio_config, FAR,
		       (ns87338_readb(spio_config, FAR) & ~FAR_LPT_MASK) | FAR_LPTB);
	ns87338_writeb(spio_config, CLK,
		       CLK_SRC_14MHz | CLK_MUL_ENA);

	*tx4927evb_led_ptr = 0xff;
	tx4927evb_leddisp_puts("EVBrev");
	tx4927evb_leddisp_putc(6, (*tx4927evb_board_rev_ptr >> 4) + '0');
	tx4927evb_leddisp_putc(7, (*tx4927evb_board_rev_ptr & 0x0f) + '0');
	spio_id = ns87338_readb(spio_config, SID);
	printk("TOSHIBA TX4927 EVB (Rev %d) --- FPGA(Rev %d)",
	       *tx4927evb_board_rev_ptr, *tx4927evb_fpga_rev_ptr);
	if (spio_id != 0xff)
		printk(" SuperIO(ID %x)", spio_id);
	printk(" DIPSW:%02x,%02x\n",
	       *tx4927evb_dipsw3_ptr, *tx4927evb_dipsw6_ptr);

	tx4927evb_check_ieee1394_board();

#if defined(CONFIG_SERIAL)
	/* loop until early_serial_setup() returns error. */
	for(i = 0; ; i++) {
		memset(&req, 0, sizeof(struct serial_struct));
		req.line = i;
		if (i < 2 && spio_id != 0xff) {
			unsigned long base =
				(i == 0) ? TX4927EVB_UART0_BASE : TX4927EVB_UART1_BASE;
			req.baud_base = TX4927EVB_BASE_BAUD;
			req.port = base - mips_io_port_base;
			req.irq = TX4927EVB_IRQ_IOC_SIO(i);
			req.flags = STD_COM_FLAGS;
			req.io_type = SERIAL_IO_PORT;
			req.type = PORT_16550A;
		}
		if (early_serial_setup(&req))
			break;
#ifdef CONFIG_REMOTE_DEBUG
		early_serial_kgdb_setup(&req);
#endif
	}
#endif
#if defined(CONFIG_SERIAL_TXX927)
	for(i = 0; i < 2; i++) {
		/* use Pre-scaler T0 (1/2) */
		early_serial_txx927_setup(i, 
					  TX4927_SIO_REG(i),
					  TX4927EVB_IRQ_IRC_SIO(i),
					  TX4927EVB_IMCLK / 2 / 16, /* not constant! */
					  TXx927_SERIAL_HAVE_CTS_LINE);
#ifdef CONFIG_REMOTE_DEBUG
		early_serial_txx927_kgdb_setup(i, 
					       TX4927_SIO_REG(i),
					       TX4927EVB_IRQ_IRC_SIO(i),
					       TX4927EVB_IMCLK / 2 / 16);
#endif
	}
#endif

	if (spio_id != 0xff) {
		unsigned long tmp;
		mips_parport_base = TX4927EVB_LPT_ADDR - mips_io_port_base;
		mips_parport_irq = TX4927EVB_IRQ_IOC_PIO;

		/* Enable ECP mode, set bit 2 of the CTR first */
		outb(0x04, mips_parport_base + 2);
		tmp = ns87338_readb(spio_config, PCR);
#if 0
		tmp |= PCR_EPP_ENABLE;
#endif
		tmp |= (PCR_EPP_IEEE | PCR_ECP_ENABLE | PCR_ECP_CLK_ENA);
		ns87338_writeb(spio_config, PCR, tmp);

		/* LPT CTR bit 5 controls direction of parallel port */
		tmp = ns87338_readb(spio_config, PTR);
		tmp |= PTR_LPT_REG_DIR;
		ns87338_writeb(spio_config, PTR, tmp);

		/* Configure IRQ to Push Pull, Level Low */
		tmp = ns87338_readb(spio_config, PCR);
		tmp &= ~(PCR_IRQ_ODRAIN);
		tmp |= PCR_IRQ_POLAR;
		ns87338_writeb(spio_config, PCR, tmp);

		/* Enable Zero Wait State for ECP */
		tmp = ns87338_readb(spio_config, FCR);
		tmp |= FCR_ZWS_ENA;
		ns87338_writeb(spio_config, FCR, tmp);
	}
}
