/* $Id: jmi39io2_ether.c,v 1.1.1.1 2004/04/07 08:36:54 louistsai Exp $
 * jmi39io2_ether.c: Wrapper for OnBoard Ether drivers for TJSYS JMI-TX39IO2 board.
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 2000-2001 Toshiba Corporation
 */

#include <linux/config.h>
#include <linux/init.h>
#include <linux/netdevice.h>
#include <asm/bootinfo.h>

extern int ne_probe(struct net_device *);

static int jmi39io2_ether_irq;
static unsigned long jmi39io2_ether_port;
int __init early_jmi39io2_ether_setup(unsigned long port, int irq)
{
	jmi39io2_ether_port = port;
	jmi39io2_ether_irq = irq;
	return 0;
}

static int jmi39io2_ether_disable;
static int __init jmi39io2_ether_setup(char *str)
{
	if (strcmp(str, "off") == 0)
		jmi39io2_ether_disable = 1;
	return 0;
}
__setup("jmi39io2_ether=", jmi39io2_ether_setup);

static struct net_device this_device;

int __init jmi39io2_ether_init(void)
{
	if (jmi39io2_ether_disable ||
	    !jmi39io2_ether_irq || !jmi39io2_ether_port)
		return -ENODEV;

	/* set here to prevent auto-detection */
	this_device.base_addr = jmi39io2_ether_port;
	this_device.irq = jmi39io2_ether_irq;
	this_device.init = ne_probe;

#if 1 /* XXX in little endian, probe fails after poweron reset. why? */
	{
		int ret = register_netdev(&this_device);
		if (ret != -ENXIO)
			return ret;
		printk(KERN_INFO "NE*000 probe again without signature checking...\n");
		this_device.mem_end = 0xbad;
	}
#endif
	return register_netdev(&this_device);
}

module_init(jmi39io2_ether_init);
