/* $Id: rbtx4925_ether.c,v 1.1.1.1 2004/04/07 08:36:57 louistsai Exp $
 * rbtx4925_ether.c: Wrapper for OnBoard Ether drivers for TOSHIBA RBTX4925 board.
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 2001 Toshiba Corporation
 */

#include <linux/config.h>
#include <linux/version.h>
#include <linux/init.h>
#include <linux/netdevice.h>
#include <asm/bootinfo.h>
#include <asm/io.h>
#include <asm/toshiba-boards/rbtx4925.h>

extern int ne_probe(struct net_device *);

static int rbtx4925_ether_disable;
static int __init rbtx4925_ether_setup(char *str)
{
	if (strcmp(str, "off") == 0)
		rbtx4925_ether_disable = 1;
	return 0;
}
__setup("rbtx4925_ether=", rbtx4925_ether_setup);

static struct net_device this_device;

int __init rbtx4925_ether_init(void)
{
	if (!(mips_machgroup == MACH_GROUP_TOSHIBA &&
	      mips_machtype == MACH_TOSHIBA_RBTX4925))
		return -ENODEV;

	/* set here to prevent auto-detection */
	if (rbtx4925_ether_disable)
		return -ENODEV;
	this_device.base_addr = RBTX4925_ETHER_ADDR - mips_io_port_base;
	this_device.irq = RBTX4925_IRQ_ETHER;
	this_device.mem_end = 0xbad2;	/* no signature checking, force byte access */
	this_device.init = ne_probe;
	return register_netdev(&this_device);
}

module_init(rbtx4925_ether_init);
