#include "lib_bzip.h"
#include "lib_bzip_private.h"
#include <linux/fs.h>
#include <linux/ext2_fs_c.h>
#ifdef MODULE
# include <linux/module.h>
#endif

#define MAX(a,b) ((a)>(b)?(a):(b))

#if 0
void *bzip2_work_area;
#endif

size_t bzip_init(int action)
{
	switch (action) {
		case EXT2_ALG_INIT_COMPRESS:
			return MAX(sizeof(Lib_Bzip_Encode_Storage_Ty),
					sizeof(Lib_Bzip_Decode_Storage_Ty));
		case EXT2_ALG_INIT_DECOMPRESS:
			return sizeof(Lib_Bzip_Decode_Storage_Ty);
		default:
			return 0;
	}
   /* sizeof(encoding space) == 147268,
      sizeof(decoding space) == 144180
      (though this may have changed slightly by the time you read
      this comment). */
}


#ifdef MODULE

int init_module(void)
{
	struct ext2_algorithm bzip_alg;

	bzip_alg.name = NULL;
	bzip_alg.avail = 1;
	bzip_alg.init = ext2_iBZIP2;
	bzip_alg.compress = ext2_wBZIP2;
	bzip_alg.decompress = ext2_rBZIP2;

	return ext2_register_compression_module(EXT2_BZIP2_ALG, 
			MAX(sizeof(Lib_Bzip_Encode_Storage_Ty),
				sizeof(Lib_Bzip_Decode_Storage_Ty)),
			sizeof(Lib_Bzip_Decode_Storage_Ty),
			&bzip_alg);
}

void cleanup_module(void)
{
	ext2_unregister_compression_module(EXT2_BZIP2_ALG);
}

#endif
