
/*-------------------------------------------------------------*/
/*-- bzip-like decompression of 32KB blocks     lib_bzip_d.c --*/
/*-------------------------------------------------------------*/

/*--
  This file is part of lib_bzip, a block-sorting compression 
  library designed to compress 32kbyte blocks, for on-the-fly
  disk compression/decompression.

  Version 0.02, 4-Jan-1998

  Copyright (C) 1996, 1997, 1998 by Julian Seward.
     Guildford, Surrey, UK
     email: jseward@acm.org

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
--*/


#include "lib_bzip_private.h"
#include "lib_bzip.h"

#ifdef __KERNEL__
# include <linux/linkage.h>
# include <asm/param.h>
# include <linux/string.h>
# include <linux/sched.h>
# define __NO_VERSION__
# include <linux/module.h>

static unsigned long next_brk = 0;
extern unsigned long volatile jiffies;

/* Time slice of a fifth of a second. */
# define MAYBE_SCHEDULE do {            \
   if (jiffies > next_brk) {            \
      schedule();                       \
      next_brk = jiffies + HZ / 5;      \
   }} while(0)

#else

# include <string.h>
# define MAYBE_SCHEDULE do { } while(0)

#endif


/*---------------------------------------------*/
/*--
   Bit stream reading stuff.
--*/

static void 
bsInit_d ( Lib_Bzip_Decode_Storage_Ty *dst )
{
   dst->inctr = 0;
   dst->bsLive = 0;
   dst->bsBuff = 0;
}


#define bsNEEDR(nz)                                   \
do {	                                              \
   while (dst->bsLive < nz) {                          \
      Int32 zzi = (Int32)(dst->inbuff[dst->inctr++]);   \
      dst->bsBuff = (dst->bsBuff << 8) | (zzi & 0xffL); \
      dst->bsLive += 8;                                \
   }                                                  \
} while(0)


static inline
UInt32 
bsR ( Lib_Bzip_Decode_Storage_Ty *dst, Int32 n )
{
   UInt32 v;
   bsNEEDR ( n );
   v = (dst->bsBuff >> (dst->bsLive-n)) & ((1 << n)-1);
   dst->bsLive -= n;
   return v;
}

/*---------------------------------------------*/
static void 
makeMaps_d ( Lib_Bzip_Decode_Storage_Ty *dst )
{
   Int32 i;
   dst->nInUse = 0;
   for (i = 0; i < 256; i++)
      if (dst->inUse[i]) {
         dst->seqToUnseq[dst->nInUse] = i;
         dst->nInUse++;
      }
}


/*---------------------------------------------*/
static void 
recvDecodingTables ( Lib_Bzip_Decode_Storage_Ty *dst )
{
   Int32  i, j, t, nSelectors, alphaSize;
   Int32  minLen, maxLen;
   Bool inUse16[16];

   dst->origPtr = bsR ( dst, 16 );

   /*--- Receive the mapping table ---*/
   for (i = 0; i < 16; i++)
      if (bsR(dst, 1) == 1) 
         inUse16[i] = True; else 
         inUse16[i] = False;

   for (i = 0; i < 256; i++) dst->inUse[i] = False;

   for (i = 0; i < 16; i++)
      if (inUse16[i])
         for (j = 0; j < 16; j++)
            if (bsR(dst, 1) == 1) dst->inUse[i * 16 + j] = True;

   makeMaps_d (dst);
   alphaSize = dst->nInUse + RUNBASE;

   /*--- Now the selectors ---*/
   nSelectors = bsR ( dst, 10 );
   for (i = 0; i < nSelectors; i++)
      dst->selector[i] = bsR(dst, 1);

   /*--- Now the coding tables ---*/
   for (t = 0; t < N_GROUPS; t++) {
      Int32 curr = bsR ( dst, 5 );
      for (i = 0; i < alphaSize; i++) {
         while (bsR(dst, 1) == 1) {
            if (bsR(dst, 1) == 0) curr++; else curr--;
         }
         dst->len[t][i] = curr;
      }
   }

   /*--- Create the Huffman decoding tables ---*/
   for (t = 0; t < N_GROUPS; t++) {
      minLen = 32;
      maxLen = 0;
      for (i = 0; i < alphaSize; i++) {
         if (dst->len[t][i] > maxLen) maxLen = dst->len[t][i];
         if (dst->len[t][i] < minLen) minLen = dst->len[t][i];
      }
      hbCreateDecodeTables ( 
         &(dst->limit[t][0]), &(dst->base[t][0]),
         &(dst->perm[t][0]), &(dst->len[t][0]),
         minLen, maxLen, alphaSize
      );
      dst->minLens[t] = minLen;
   }
}


/*---------------------------------------------*/
#define GET_MTF_VAL(lval)                 \
do {                                      \
   Int32 zn, zvec, zj;                    \
   if (groupPos == 0) {                   \
      groupNo++;                          \
      groupPos = G_SIZE;                  \
      gSel = dst->selector[groupNo];       \
      gMinlen = dst->minLens[gSel];        \
      gLimit = &(dst->limit[gSel][0]);     \
      gPerm = &(dst->perm[gSel][0]);       \
      gBase = &(dst->base[gSel][0]);       \
   }                                      \
   groupPos--;                            \
   zn = gMinlen; zvec = bsR ( dst, zn );       \
   while (zvec > gLimit[zn]) {            \
      zn++; zj = bsR ( dst, 1 );               \
      zvec = (zvec << 1) | zj;            \
   };                                     \
   lval = gPerm[zvec - gBase[zn]];        \
} while(0)


/*---------------------------------------------*/
static void 
decodeBlock ( Lib_Bzip_Decode_Storage_Ty *dst,
              UInt32* cc, 
              UChar*  mtfa, 
              Int32*  mtfbase )
{
   Int32  nextSym;
   Int32  EOB, groupNo, groupPos, gSel;
   Int32  gMinlen = 0;
   Int32* gLimit = NULL;
   Int32* gBase = NULL;
   Int32* gPerm = NULL;

   Int32 lastR, op;

   /*--
      Now passed in from caller, so as to keep stack
      frame small.
   UInt32 cc[256];
   UChar  mtfa   [MTFA_SIZE];
   Int32  mtfbase[256 / MTFL_SIZE];
   --*/

   MAYBE_SCHEDULE;

   recvDecodingTables (dst);

   EOB      = dst->nInUse + RUNBASE - 1;
   groupNo  = -1;
   groupPos = 0;

   memset(cc, 0, 256 * sizeof(*cc));

   //-- MTF init
   {
      unsigned i, j, k;

      k = MTFA_SIZE-1;
      for (i = 256 / MTFL_SIZE; i-- > 0;) {
         for (j = MTFL_SIZE; j-- > 0;) {
            mtfa[k] = (UChar)(i * MTFL_SIZE + j);
            k--;
         }
         mtfbase[i] = k + 1;
      }
   }
   //-- end MTF init

   lastR = -1;

   MAYBE_SCHEDULE;

   GET_MTF_VAL(nextSym);

   while (True) {

      if (nextSym < RUNBASE) {
         UChar ch;
         Int32 sum = -1;
         Int32 N = 1;
         do {
            if (nextSym == RUNA) sum = sum + (0+1) * N;
            else if (nextSym == RUNB) sum = sum + (1+1) * N;
            N = N * RUNBASE;
            GET_MTF_VAL(nextSym);
         }
            while (nextSym < RUNBASE);

         sum++;
         ch = dst->seqToUnseq[ mtfa[mtfbase[0]] ];

         while (sum > 0) {
            lastR++;
            dst->tvec[lastR] = (ch << 24) | cc[ch];
            cc[ch]++;
            sum--;
         };

         continue;

      } else if (nextSym == EOB) {

         break;

      } else {

         UChar tmp, ch;
         lastR++;

         //-- tmp = MTF ( nextSym-(RUNBASE-1) );
         {
            Int32 i, j, k, n, p, lno, off;
            n = (Int32)(nextSym - (RUNBASE-1) );

            if (n < MTFL_SIZE) { // avoid general-case expense
               p = mtfbase[0];
               tmp = mtfa[p+n];
               while (n > 3) {
                  Int32 z = p+n;
                  mtfa[(z)  ] = mtfa[(z)-1];
                  mtfa[(z)-1] = mtfa[(z)-2];
                  mtfa[(z)-2] = mtfa[(z)-3];
                  mtfa[(z)-3] = mtfa[(z)-4];
                  n -= 4;
               }
               while (n > 0) { mtfa[(p+n)] = mtfa[(p+n)-1]; n--; };
               mtfa[p] = tmp;
            } else { // general case
               lno = n / MTFL_SIZE;
               off = n % MTFL_SIZE;
               p = mtfbase[lno] + off;
               tmp = mtfa[p];
               while (p > mtfbase[lno]) { mtfa[p] = mtfa[p-1]; p--; };
               mtfbase[lno]++;
               while (lno > 0) {
                  mtfbase[lno]--;
                  mtfa[mtfbase[lno]] = mtfa[mtfbase[lno-1] + MTFL_SIZE - 1];
                  lno--;
               }
               mtfbase[0]--;
               mtfa[mtfbase[0]] = tmp;
               if (mtfbase[0] == 0) {
                  k = MTFA_SIZE-1;
                  for (i = 256 / MTFL_SIZE-1; i >= 0; i--) {
                     for (j = MTFL_SIZE-1; j >= 0; j--) {
                        mtfa[k] = mtfa[mtfbase[i] + j];
                        k--;
                     }
                     mtfbase[i] = k + 1;
                  }
	       }
            }
         }
         //-- end tmp = MTF ( nextSym-(RUNBASE-1) );

         ch = dst->seqToUnseq[tmp];
         dst->tvec[lastR] = (ch << 24) | cc[ch]; 
         cc[ch]++;

         GET_MTF_VAL(nextSym);
         continue;
      }
   }

   MAYBE_SCHEDULE;

   /* */
   {
      UInt32 k;
      unsigned i;
      Int32 sum;

      k = dst->origPtr;
      sum = 0;
      for (i = 0; i < 256; i++) {
	 sum += cc[i];
	 cc[i] = sum - cc[i];
      }

      op = lastR+1;
      dst->nblock = op;
      while (op > 0) {
	 UInt32 u;
	 UChar v;
	 u = dst->tvec[k]; 
	 v = u >> 24; 
	 k = (u & 0x00ffffff) + cc[v];
	 op--; dst->outbuff[op] = v;
      }
   }
}


/*---------------------------------------------*/
static void 
unrandomiseBlock ( Lib_Bzip_Decode_Storage_Ty *dst )
{
   Int32 i;
   RAND_DECLS;

   for (i = 0; i < dst->nblock; i++) {
      RAND_UPD_MASK;
      dst->outbuff[i] ^= RAND_MASK;
   }
}

/*---------------------------------------------*/
size_t 
bzip_uncompressBlock ( unsigned char *in_buf, 
		       unsigned char *out_buf,
		       void *heap,
		       size_t num_in_buf, /* unused */
		       size_t num_out_buf, /* unused */
		       int param ) /* unused */
{
   Lib_Bzip_Decode_Storage_Ty *dst;

   MOD_INC_USE_COUNT;

#if 0
   dst = (Lib_Bzip_Decode_Storage_Ty *) bzip2_work_area_D;
#else
   dst = (Lib_Bzip_Decode_Storage_Ty *) heap;
#endif
   dst->inbuff = in_buf;
   dst->outbuff = out_buf;

   bsInit_d (dst);

   if (bsR ( dst, 8 ) != 0xa2) {
      MOD_DEC_USE_COUNT;
      return 0;
   }

   dst->randomised = False;
   if (bsR(dst, 1) == 1) dst->randomised = True;

   decodeBlock ( dst,
                 &(dst->cc_tmp[0]),
		 &(dst->mtfa_tmp[0]),
		 &(dst->mtfbase_tmp[0]) );

   if (dst->randomised) unrandomiseBlock(dst);

   MOD_DEC_USE_COUNT;
   return dst->nblock;
}


/*-------------------------------------------------------------*/
/*-- end                                        lib_bzip_d.c --*/
/*-------------------------------------------------------------*/
