/* This file contains support for assert() and
   contains the various debugging parameters.

   Previously EXT2_COMPR_REPORT was in ext2_fs.h, but changing that file
   causes most of the kernel to be rebuilt during subsequent compiles. */

/* At some stage it would be nice to have a CONFIG_ option 
   for the amount of time to spend catching bugs.  It would be
   an int from 0 through 100, where 0 means `don't do any assert's
   at all', n means `try not to spend more than n% of total system
   (kernel) time in debugging'. */

#undef  NDEBUG /* fixme: #define this for release */
#include <linux/assert.h>

/* fs_assert: Like assert(), but truth of expression depends on
   integrity of fs as well as on program logic. */
#define fs_assert(_x) assert(_x)

#undef  EXT2_COMPR_REPORT
#ifdef  EXT2_COMPR_REPORT
# undef  EXT2_COMPR_REPORT_PUT
# define EXT2_COMPR_REPORT_WA
# undef  EXT2_COMPR_REPORT_ALLOC  /* disk allocation etc. */
# undef  EXT2_COMPR_REPORT_ALGORITHMS /* Compression algorithms */
# undef  EXT2_COMPR_REPORT_VERBOSE /* Various things I don't think
				      useful at the moment. */
#endif
