/***********************************************************************
**
**	lzv.c -- an extremly fast compression/decompression-method
**
**	Written by Hermann Vogt
**
**		v 0.3 -- 94/03/08	aCembler version of rLZV built in.
**		v 0.2 -- 94/03/04	Changes for usage with DouBle 0.2 built in.
**		v 0.1 -- 94/03/01	Intensivly tested, removed all known bugs.
**		v 0.0 -- 94/02/21	First Version.
**
**	Copyright (c) 1994 Hermann Vogt. Redistribution of this file is
**	permitted under the GNU Public Licence.
**
**	The method presented here is faster and compresses better
**	than lzrw1 and lzrw1-a. I named it lzv for "Lev-Zimpel-Vogt".
**	It uses ideas introduced by Ross Williams in his algorithm lzrw1
**	[R. N. Williams (1991): "An Extremly Fast ZIV-Lempel Data
**	Compression Algorithm", Proceedings IEEE Data Compression
**	Conference, Snowbird, Utah, 362-371] and by Fiala and Green in their
**	algorithm a1 [E. R. Fiala, D. H. Greene (1989): "Data Compression
**	with Finite Windows", Communications of the ACM, 4, 490-505].
**	Because lzv differs strongly from both, I hope there will be no
**	patent problems. The hashing-method has been stolen from Jean-loup
**	Gailly's (patent free) gzip.
**
**	KNOWN PROBLEMS:
**	-	My english is very bad.
**  -	Badly commented. (I hope this will be better in the next
**		version.)
**	-	I'm not sure if lzv is free from patent problems.
**
***********************************************************************/

#define	MLL	32		/*	Maximum len of chain of literals	*/
#define	MML	(8+256)		/*	Maximum len of match			*/
#define	MOFF	8191		/*	Maximum offset				*/
#define	HSIZ	16384		/*	Size of Hashtable			*/

typedef	unsigned char	uch;
typedef	unsigned short	ush;
typedef	unsigned int	uit;

#if 0
unsigned short *ext2_lzv1_htab = ((unsigned short*) 0L);
#endif

#ifdef __KERNEL__
# include <linux/linkage.h>
# include <linux/sched.h>
# include <asm/param.h>
static unsigned long next_brk = 0;
extern unsigned long volatile jiffies;
#endif

int ext2_LZV1_compress (uch *in, uch *out, ush *heap, int len, int out_len)
{
	uit hval, op, ip, l_len, m_pos, m_off, m_len, maxlen;
	ush *ext2_lzv1_htab = heap;

	maxlen = out_len;
	hval = ((in[0] << 5) ^ in[1]) & (HSIZ - 1);
	ip = op = l_len = 0;
	do {
		hval = ((hval << 5) ^ in[ip+2]) & (HSIZ - 1);
		m_pos = ext2_lzv1_htab[hval];
		ext2_lzv1_htab[hval] = ip;

#if 0
		/* 
		 *	If you want to compress more than 64K, uncomment
		 *	the following lines.
		 */

		m_pos = (ip &~0xffff) + m_pos;
		if (m_pos >= ip && m_pos >= 0x10000)
		  m_pos -= 0x10000;
#endif

#ifdef __KERNEL__
		/* Time slice of a fifth of a second. */
		if (jiffies > next_brk)
		  {
		    schedule();
		    next_brk = jiffies + HZ / 5;  
		  }
#endif

		if (m_pos < ip &&
				in[m_pos] == in[ip] &&
				(m_off = ip - m_pos - 1) <= MOFF &&
				ip + 4 < len &&
				*(ush *)(in+m_pos+1) == *(ush *)(in+ip+1)) {
			/*	We have found a match	*/
			uit look = len - ip - 2;
			if (look > MML) look = MML;
			m_len = 2;
			do {
				m_len++;
			} while(m_len != look && in[ip+m_len] == in[m_pos+m_len]);

			if (op + 2 + l_len + 3 >= maxlen) return 0;
			if (l_len != 0) {
				out[op++] = (l_len - 1) << 3;
				do {
					out[op++] = in[ip-l_len--];
				} while (l_len != 0);
			}
			m_len -= 2;
			if (m_len <= 6) {
				out[op++] = m_len | ((m_off >> 5) & 0xf8);
			}
			else {
				out[op++] = 0x07 | ((m_off >> 5) & 0xf8);
				out[op++] = m_len - 7;
			}
			out[op++] = m_off & 0xff;
			ip++;
			hval = ((hval << 5) ^ in[ip+2]) & (HSIZ - 1);
			ext2_lzv1_htab[hval] = ip;
			ip++;
			do {
				hval = ((hval << 5) ^ in[ip+2]) & (HSIZ - 1);
				ext2_lzv1_htab[hval] = ip;
				ip++;
				m_len--;
			} while (0 != m_len);
		}
		else {
			/*	No match found	*/
			ip++;
			l_len++;
			if (MLL == l_len) {
				if (op + 2 + MLL >= maxlen) return 0;
				out[op++] = 0xf8;
				do {
					out[op++] = in[ip-l_len--];
				} while (l_len != 0);
			}
		}
	} while (ip < len);
	if (l_len != 0) {
		if (op + l_len + 3 >= maxlen) return 0;
		out[op++] = (l_len - 1) << 3;
		do {
			out[op++] = in[ip-l_len--];
		} while (l_len != 0);
	}
	return op;
}

#ifndef LZV_ASM

int ext2_LZV1_decompress (uch const * const in, uch * const out, int ilen, int len)
{
	register uit tbuf, c_len;
	uch * const out_end = out + len;
	register uch *op = out;
	uch const * const in_end = in + ilen;
	register uch const *ip = in;

	do {
		tbuf = *ip++;
 		c_len = tbuf & 0x07;
		if (0 == c_len) {
			c_len = (tbuf >> 3) + 1;
			do *op++ = *ip++;
			while (--c_len); /* effic: memcpy()? */
		} else {
			register uch *m_pos;

			if (0x07 == c_len) c_len = *ip++ + 7;
			m_pos = op - 1 - (((uit) (tbuf & 0xf8) << 5) | *ip++);
#ifndef EXT2_NO_ERRCHK
			/* If we don't check this then we segfault (if in user
                           space) or leave process in uninteruptible state (if
                           in kernel) if the data is corrupt. */
			if (m_pos < out)
			  return 0; /* Compression error. */
#endif
			*op++ = *m_pos++;
			*op++ = *m_pos++;
			do *op++ = *m_pos++;
			while (--c_len);
		}
	} while (op < out_end && ip < in_end);
	return op - out;
#if 0
	if(ip > in_end) return 0;
	return (ip - in);
#endif
}

#else

/*
**	aCembler version
**
**	IMPORTANT: Use gcc -O2 -fomit-frame-pointer!!!
*/

int ext2_LZV1_decompress (uch *in, uch *out, int ilen, int len)
{
	register uit tbuf;
	register uch *ip;
	register uch *op asm ("%edi");
	register uch *m_pos asm ("%esi");
	uch *out_end, *in_end;
	register uit c_len asm ("%ecx");

	ip = in;
	op = out;
	out_end = out + len;
	in_end = in + ilen;
	asm volatile ("cld");
	do {
		tbuf = *ip++;
		c_len = tbuf & 0x07;
		if (0 == c_len) {
			c_len = (tbuf >> 3) + 1;
			m_pos = ip;
			ip += c_len;
			asm volatile ("rep; movsb"
				: /* no output */
				: "g" (m_pos), "g" (op), "g" (c_len));
		}
		else {
			if (0x07 == c_len) c_len = *ip++ + 9;
			else c_len += 2;
			m_pos = op - 1 - (((uit) (tbuf & 0xf8) << 5) | *ip++);
			asm volatile ("rep; movsb"
				: /* no output */
				: "g" (m_pos), "g" (op), "g" (c_len));
		}
	} while (op < out_end && ip < in_end);

	return op-out;
#if 0
	if(ip > in_end) return 0;
	return (ip-in);
#endif
}

#endif

