/*
 * fdc37m81x.h: Configuration Register Description for the
 *            SMSC FDC37M81x (SuperIO).
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 2001 Toshiba Corporation
 */

#ifndef _ASM_FDC37M81X_H
#define _ASM_FDC37M81X_H

/*
 * Controll Register Index Values
 */
/* Global Config Registers */
#define FDC37M81x_CONFIG_INDEX	0x00
#define FDC37M81x_CONFIG_DATA	0x01
#define FDC37M81x_CONF		0x02
#define FDC37M81x_INDEX		0x03
#define FDC37M81x_DNUM		0x07
#define FDC37M81x_DID		0x20
#define FDC37M81x_DREV		0x21
#define FDC37M81x_PCNT		0x22
#define FDC37M81x_PMGT		0x23
#define FDC37M81x_OSC		0x24
#define FDC37M81x_CONFPA0	0x26
#define FDC37M81x_CONFPA1	0x27
#define FDC37M81x_TEST4		0x2B
#define FDC37M81x_TEST5		0x2C
#define FDC37M81x_TEST1		0x2D
#define FDC37M81x_TEST2		0x2E
#define FDC37M81x_TEST3		0x2F

/* Logical device number */
#define FDC37M81x_SERIAL1	0x04
#define FDC37M81x_SERIAL2	0x05
#define FDC37M81x_KBD	0x07

/* Logical Config Registers */
#define FDC37M81x_ACTIVE	0x30
#define FDC37M81x_BASEADDR0	0x60
#define FDC37M81x_BASEADDR1	0x61
#define FDC37M81x_INT		0x70
#define FDC37M81x_INT2		0x72
#define FDC37M81x_MODE		0xF0

#define FDC37M81x_CONFIG_ENTER	0x55
#define FDC37M81x_CONFIG_EXIT	0xaa

#ifdef __KERNEL__
#include <asm/io.h>

static inline unsigned char
fdc37m81x_readb(unsigned long port, unsigned char index)
{
	outb(index, port + FDC37M81x_CONFIG_INDEX);
	return inb(port + FDC37M81x_CONFIG_DATA);
}
static inline void
fdc37m81x_writeb(unsigned long port, unsigned char index, unsigned char data)
{
	outb(index, port + FDC37M81x_CONFIG_INDEX);
	outb(data, port + FDC37M81x_CONFIG_DATA);
}

#endif

#endif
