#ifndef __FLASH_H__
#define __FLASH_H__

enum {
	FL_IMMEDIATE,
	FL_INTERVAL,
};

#define GENCONF_ADDR		0x2000
#define USERACCOUNT_ADDR	0x4000
#define EXTCONF_ADDR		0x4000
#define DHCPLEASE_ADDR		0x6000
#define EVENTLOG_ADDR		0xa000
#define LA_GRPSHARE_ADDR	0x3e0000
#define LA_USER_ADDR		0x3f0000
#define USERSHARE_ADDR		0x3f0000

typedef struct {
	int		policy;

	int		short_term_interval;
	int		long_term_interval;
	int		dirty;
	int		dirty_threshold;
	int		write_force;

	unsigned int	base;
	unsigned int	size;
	void		*buf_base;
	int		last_time_modified;
	struct semaphore sem;
} REGION_INFO;

typedef struct {
	int		type;
	unsigned int	offset;
	unsigned int	size;
	REGION_INFO	*reg_info;
} ACCESS_CONF;

#endif	// __FLASH_H__
