/*
 * Defines for the TJSYS JMI-3927IO2.
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 2000-2001 Toshiba Corporation
 */
#ifndef __ASM_TOSHIBA_BOARDS_JMI39IO2_H 
#define __ASM_TOSHIBA_BOARDS_JMI39IO2_H 

#define JMI39IO2_ISAMEM_BASE(base)	(base)
#define JMI39IO2_ISAIO_BASE(base)	((base) + 0x01000000)
#define JMI39IO2_ISAC_BASE(base)	((base) + 0x02000000)
#define JMI39IO2_LCDVGA_REG_BASE(base)	((base) + 0x03000000)
#define JMI39IO2_LCDVGA_MEM_BASE(base)	((base) + 0x03800000)

#define JMI39IO2_ISAC_REV_ADDR(base)	(JMI39IO2_ISAC_BASE(base) + 0x00000000)
#define JMI39IO2_ISAC_EINTS_ADDR(base)	(JMI39IO2_ISAC_BASE(base) + 0x00200000)
#define JMI39IO2_ISAC_EINTM_ADDR(base)	(JMI39IO2_ISAC_BASE(base) + 0x00300000)
#define JMI39IO2_ISAC_NMI_ADDR(base)	(JMI39IO2_ISAC_BASE(base) + 0x00400000)
#define JMI39IO2_ISAC_LED_ADDR(base)	(JMI39IO2_ISAC_BASE(base) + 0x00500000)
#define JMI39IO2_ISAC_INTP_ADDR(base)	(JMI39IO2_ISAC_BASE(base) + 0x00800000)
#define JMI39IO2_ISAC_INTS1_ADDR(base)	(JMI39IO2_ISAC_BASE(base) + 0x00900000)
#define JMI39IO2_ISAC_INTS2_ADDR(base)	(JMI39IO2_ISAC_BASE(base) + 0x00a00000)
#define JMI39IO2_ISAC_INTM_ADDR(base)	(JMI39IO2_ISAC_BASE(base) + 0x00b00000)

/* bits for ISAC_REV (high byte) */
#define JMI39IO2_IDT_MASK	0xfc
#define JMI39IO2_REV_MASK	0x03
#define JMI39IO2_ISAC_IDT	0x20

/* bits for ISAC_EINTS/ISAC_EINTM (high byte) */
#define JMI39IO2_ISAC_EINTB_IOCHK	2
#define JMI39IO2_ISAC_EINTB_BWTH	4
#define JMI39IO2_ISAC_EINTF_IOCHK	(1 << JMI39IO2_ISAC_EINTB_IOCHK)
#define JMI39IO2_ISAC_EINTF_BWTH	(1 << JMI39IO2_ISAC_EINTB_BWTH)

/* bits for ISAC_LED (high byte) */
#define JMI39IO2_ISAC_LED_ISALED	0x01
#define JMI39IO2_ISAC_LED_USRLED	0x02

#define JMI39IO2_NR_IRQ_ISAC	8

/* bits for ISAC_INTS/ISAC_INTM/ISAC_INTP (high byte) */
#define JMI39IO2_ISAC_INTB_IRQ5	0
#define JMI39IO2_ISAC_INTB_IRQKB	1
#define JMI39IO2_ISAC_INTB_IRQMOUSE	2
#define JMI39IO2_ISAC_INTB_IRQ4	3
#define JMI39IO2_ISAC_INTB_IRQ12	4
#define JMI39IO2_ISAC_INTB_IRQ3	5
#define JMI39IO2_ISAC_INTB_IRQ10	6
#define JMI39IO2_ISAC_INTB_ISAER	7
#define JMI39IO2_ISAC_INTF_IRQ5		(1 << JMI39IO2_ISAC_INTB_IRQ5)
#define JMI39IO2_ISAC_INTF_IRQKB	(1 << JMI39IO2_ISAC_INTB_IRQKB)
#define JMI39IO2_ISAC_INTF_IRQMOUSE	(1 << JMI39IO2_ISAC_INTB_IRQMOUSE)
#define JMI39IO2_ISAC_INTF_IRQ4		(1 << JMI39IO2_ISAC_INTB_IRQ4)
#define JMI39IO2_ISAC_INTF_IRQ12	(1 << JMI39IO2_ISAC_INTB_IRQ12)
#define JMI39IO2_ISAC_INTF_IRQ3		(1 << JMI39IO2_ISAC_INTB_IRQ3)
#define JMI39IO2_ISAC_INTF_IRQ10	(1 << JMI39IO2_ISAC_INTB_IRQ10)
#define JMI39IO2_ISAC_INTF_ISAER	(1 << JMI39IO2_ISAC_INTB_ISAER)

#ifndef _LANGUAGE_ASSEMBLY

#define jmi39io2_isac_reg_out(d, a)	((*(volatile unsigned char *)(a)) = (d))
#define jmi39io2_isac_reg_in(a)		(*(volatile unsigned char *)(a))

/* LED macro */
#define jmi39io2_io_led_set(base, n/*0-3*/)	jmi39io2_isac_reg_out((n), JMI39IO2_ISAC_LED_ADDR(base))

/* DIPSW macro */
#define jmi39io2_io_dipsw(base)	(jmi39io2_isac_reg_in(JMI39IO2_ISAC_LED_ADDR(base)) >> 4)

#endif /* _LANGUAGE_ASSEMBLY */

/* INTs */

/* RTL8019AS 10M Ether (JMI-3927IO2:JPW2:2-3 Short) */
#define JMI39IO2_INT_ETHER	3
/* RTL8019AS 10M Ether (JMI-3927IO2:JPW2:1-2 Short) */
#define JMI39IO2_INT_ETHER_ALT	0
/* ISAC (ISA, PCMCIA, KEYBOARD, MOUSE) */
#define JMI39IO2_INT_ISAC	2

/* I/O Ports */
/* RTL8019AS 10M Ether */
#define JMI39IO2_ETHER_ADDR(base)	(JMI39IO2_ISAIO_BASE(base) + 0x280)
#define JMI39IO2_PCMCIA_ADDR(base)	(JMI39IO2_ISAIO_BASE(base) + 0x3e0)
#define JMI39IO2_KBD_ADDR(base)	(JMI39IO2_ISAIO_BASE(base) + 0x00800060)
#define JMI39IO2_IDE_ADDR(base)	(JMI39IO2_ISAIO_BASE(base) + 0x001001f0)

#ifndef _LANGUAGE_ASSEMBLY
extern unsigned long jmi39io2_iob_base;
extern int jmi39io2_isac_irq_base;
extern void jmi39io2_init(unsigned long base, int isac_irq);
#define have_jmi39io2()	(jmi39io2_iob_base != 0)
extern void jmi39io2_isac_irq_init(void);
extern int jmi39io2_isac_irqroute(void);
extern void jmi39io2_kbd_init(void);
extern void jmi39io2_ide_init(void);
extern int early_jmi39io2_ether_setup(unsigned long port, int irq);
extern int early_e1355_setup(unsigned long reg_base, unsigned long fb_base);
#endif /* _LANGUAGE_ASSEMBLY */

#endif /* __ASM_TOSHIBA_BOARDS_JMI39IO2_H */
