#ifndef _ASM_SHMBUF_H
#define _ASM_SHMBUF_H

/* 
 * The shmid64_ds structure for the MIPS architecture.
 * Note extra padding because this structure is passed back and forth
 * between kernel and user space.
 *
 * Pad space is left for:
 * - 2 miscellaneous 32-bit values
 */

struct shmid64_ds {
	struct ipc64_perm	shm_perm;	/* operation perms */
	size_t			shm_segsz;	/* size of segment (bytes) */
	__kernel_time_t		shm_atime;	/* last attach time */
	__kernel_time_t		shm_dtime;	/* last detach time */
	__kernel_time_t		shm_ctime;	/* last change time */
	__kernel_pid_t		shm_cpid;	/* pid of creator */
	__kernel_pid_t		shm_lpid;	/* pid of last operator */
#ifdef CONFIG_MIPS_RH70_WORKAROUND
/* MIPS RedHat 7.0's bits/ipc.h, bits/sem.h, bits/shm.h are obsolete. */
/* see /usr/include/bit/shm.h in MIPS RedHat 7.0 */
	unsigned short		shm_nattch;
	unsigned short		__unused0;
#else
	unsigned long		shm_nattch;	/* no. of current attaches */
#endif
	unsigned long		__unused1;
	unsigned long		__unused2;
};

struct shminfo64 {
	unsigned long	shmmax;
	unsigned long	shmmin;
	unsigned long	shmmni;
	unsigned long	shmseg;
	unsigned long	shmall;
#ifndef CONFIG_MIPS_RH70_WORKAROUND
/* MIPS RedHat 7.0's bits/ipc.h, bits/sem.h, bits/shm.h are obsolete. */
/* see /usr/include/bit/shm.h in MIPS RedHat 7.0 */
	unsigned long	__unused1;
	unsigned long	__unused2;
	unsigned long	__unused3;
	unsigned long	__unused4;
#endif
};

#endif /* _ASM_SHMBUF_H */
