/*
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 2001 Toshiba Corporation
 */
#ifndef __ASM_TOSHIBA_BOARDS_RBTX4925_H 
#define __ASM_TOSHIBA_BOARDS_RBTX4925_H 

#include <asm/tx4925.h>
#include <asm/addrspace.h>
#include <asm/toshiba-boards/irq.h>

/* CS */
#if 1
/* use PMON's setting */
extern unsigned long rbtx4925_ce_base[8];
#define RBTX4925_CE0	rbtx4925_ce_base[0]
#define RBTX4925_CE1	rbtx4925_ce_base[1]
#define RBTX4925_CE2	rbtx4925_ce_base[2]
#define RBTX4925_CE3	rbtx4925_ce_base[3]
#define RBTX4925_CE4	rbtx4925_ce_base[4]
#define RBTX4925_CE5	rbtx4925_ce_base[5]
#define RBTX4925_CE6	rbtx4925_ce_base[6]
#define RBTX4925_CE7	rbtx4925_ce_base[7]
#else
#define RBTX4925_CE0	0x1e000000	/* 16M */
#define RBTX4925_CE1	0x1c000000	/* 16M */
#define RBTX4925_CE2	0x1b000000	/* 1M */
#define RBTX4925_CE3	0x10000000	/* 64M */
#endif

/* Address map */
#define RBTX4925_FPGA_REG_ADDR	(KSEG1 + RBTX4925_CE2 + 0x00000000)
#define RBTX4925_BOARD_REV_ADDR	(KSEG1 + RBTX4925_CE2 + 0x00000000)
#define RBTX4925_FPGA_REV_ADDR	(KSEG1 + RBTX4925_CE2 + 0x00000002)
#define RBTX4925_CFGA_STAT_ADDR	(KSEG1 + RBTX4925_CE2 + 0x00000004)
#define RBTX4925_CFGD_STAT_ADDR	(KSEG1 + RBTX4925_CE2 + 0x00000006)
#define RBTX4925_LED_ADDR	(KSEG1 + RBTX4925_CE2 + 0x00001000)
#define RBTX4925_DIPSW_ADDR	(KSEG1 + RBTX4925_CE2 + 0x00001002)
#define RBTX4925_IMASK_ADDR	(KSEG1 + RBTX4925_CE2 + 0x00002000)
#define RBTX4925_INTPOL_ADDR	(KSEG1 + RBTX4925_CE2 + 0x00002002)
#define RBTX4925_ISTAT_ADDR	(KSEG1 + RBTX4925_CE2 + 0x00002004)
#define RBTX4925_IMSTAT_ADDR	(KSEG1 + RBTX4925_CE2 + 0x00002006)
#define RBTX4925_SOFTINT_ADDR	(KSEG1 + RBTX4925_CE2 + 0x00003000)
#define RBTX4925_SIODTR_ADDR	(KSEG1 + RBTX4925_CE2 + 0x00003002)
#define RBTX4925_IMASK2_ADDR	(KSEG1 + RBTX4925_CE2 + 0x00004000)
#define RBTX4925_INTPOL2_ADDR	(KSEG1 + RBTX4925_CE2 + 0x00004002)
#define RBTX4925_ISTAT2_ADDR	(KSEG1 + RBTX4925_CE2 + 0x00004004)
#define RBTX4925_IMSTAT2_ADDR	(KSEG1 + RBTX4925_CE2 + 0x00004006)
#define RBTX4925_PIOSEL_ADDR	(KSEG1 + RBTX4925_CE2 + 0x00005000)
#define RBTX4925_SSFDC_WP_ADDR	(KSEG1 + RBTX4925_CE2 + 0x00005002)
#define RBTX4925_SOFTRESET_ADDR	(KSEG1 + RBTX4925_CE2 + 0x00007000)
#define RBTX4925_SOFTRESETLOCK_ADDR	(KSEG1 + RBTX4925_CE2 + 0x00007002)
#define RBTX4925_PCIRESET_ADDR	(KSEG1 + RBTX4925_CE2 + 0x00007004)
#define RBTX4925_PCMCIA_BASE	(KSEG1 + RBTX4925_CE2 + 0x00010000)
#define RBTX4925_ETHER_BASE	(KSEG1 + RBTX4925_CE2 + 0x00020000)

/* JMI-TX39IO2 */
#define RBTX4925_IOB_BASE	(KSEG1 + RBTX4925_CE3)

/* Ethernet port address */
#define RBTX4925_ETHER_ADDR	(RBTX4925_ETHER_BASE + 0x280)

/* bits for ISTAT/IMASK/IMSTAT */
#define RBTX4925_INTB_PCID	0
#define RBTX4925_INTB_PCIC	1
#define RBTX4925_INTB_PCIB	2
#define RBTX4925_INTB_PCIA	3
#define RBTX4925_INTB_DSR	4
#define RBTX4925_INTB_INT2	5
#define RBTX4925_INTB_INT3	6
#define RBTX4925_INTB_SWI	7
#define RBTX4925_INTF_PCID	(1 << RBTX4925_INTB_PCID)
#define RBTX4925_INTF_PCIC	(1 << RBTX4925_INTB_PCIC)
#define RBTX4925_INTF_PCIB	(1 << RBTX4925_INTB_PCIB)
#define RBTX4925_INTF_PCIA	(1 << RBTX4925_INTB_PCIA)
#define RBTX4925_INTF_DSR	(1 << RBTX4925_INTB_DSR)
#define RBTX4925_INTF_INT2	(1 << RBTX4925_INTB_INT2)
#define RBTX4925_INTF_INT3	(1 << RBTX4925_INTB_INT3)
#define RBTX4925_INTF_SWI	(1 << RBTX4925_INTB_SWI)
/* bits for ISTAT2/IMASK2/IMSTAT2 */
#define RBTX4925_INT2B_PCMCIA	0
#define RBTX4925_INT2F_PCMCIA	(1 << RBTX4925_INT2B_PCMCIA)
/* bits for PIOSEL */
#define RBTX4925_PIOSEL_SIO(ch)	(0x01<<(ch))
#define RBTX4925_PIOSEL_NOPCTOE	0x04
#define RBTX4925_PIOSEL_NOSMART	0x08
#define RBTX4925_PIOSEL_NOACLINK	0x10
#define RBTX4925_PIOSEL_NOPCMCIA	0x20

#ifndef _LANGUAGE_ASSEMBLY
#define rbtx4925_board_rev_ptr	\
	((volatile unsigned char *)RBTX4925_BOARD_REV_ADDR)
#define rbtx4925_fpga_rev_ptr	\
	((volatile unsigned char *)RBTX4925_FPGA_REV_ADDR)
#define rbtx4925_cfga_ptr	\
	((volatile unsigned char *)RBTX4925_CFGA_ADDR)
#define rbtx4925_cfgd_ptr	\
	((volatile unsigned char *)RBTX4925_CFGD_ADDR)
#define rbtx4925_led_ptr	\
	((volatile unsigned char *)RBTX4925_LED_ADDR)
#define rbtx4925_dipsw_ptr	\
	((volatile unsigned char *)RBTX4925_DIPSW_ADDR)
#define rbtx4925_imask_ptr	\
	((volatile unsigned char *)RBTX4925_IMASK_ADDR)
#define rbtx4925_intpol_ptr	\
	((volatile unsigned char *)RBTX4925_INTPOL_ADDR)
#define rbtx4925_istat_ptr	\
	((volatile unsigned char *)RBTX4925_ISTAT_ADDR)
#define rbtx4925_imstat_ptr	\
	((volatile unsigned char *)RBTX4925_IMSTAT_ADDR)
#define rbtx4925_softint_ptr	\
	((volatile unsigned char *)RBTX4925_SOFTINT_ADDR)
#define rbtx4925_siodtr_ptr	\
	((volatile unsigned char *)RBTX4925_SIODTR_ADDR)
#define rbtx4925_imask2_ptr	\
	((volatile unsigned char *)RBTX4925_IMASK2_ADDR)
#define rbtx4925_intpol2_ptr	\
	((volatile unsigned char *)RBTX4925_INTPOL2_ADDR)
#define rbtx4925_istat2_ptr	\
	((volatile unsigned char *)RBTX4925_ISTAT2_ADDR)
#define rbtx4925_imstat2_ptr	\
	((volatile unsigned char *)RBTX4925_IMSTAT2_ADDR)
#define rbtx4925_piosel_ptr	\
	((volatile unsigned char *)RBTX4925_PIOSEL_ADDR)
#define rbtx4925_ssfdc_wp_ptr	\
	((volatile unsigned char *)RBTX4925_SSFDC_WP_ADDR)
#define rbtx4925_softreset_ptr	\
	((volatile unsigned char *)RBTX4925_SOFTRESET_ADDR)
#define rbtx4925_softresetlock_ptr	\
	((volatile unsigned char *)RBTX4925_SOFTRESETLOCK_ADDR)
#define rbtx4925_pcireset_ptr	\
	((volatile unsigned char *)RBTX4925_PCIRESET_ADDR)

#define rbtx4925_led_on(n)	(*rbtx4925_led_ptr |= 1<<(n))
#define rbtx4925_led_off(n)	(*rbtx4925_led_ptr = *rbtx4925_led_ptr &~ (1<<(n)))
#define rbtx4925_led_toggle(n)	(*rbtx4925_led_ptr = *rbtx4925_led_ptr ^(1<<(n)))

/* clock */
#define RBTX4925_MASTER_CLOCK	20000000 /* 20MHz */
#define RBTX4925_GBUSCLK	(RBTX4925_MASTER_CLOCK * 4) /* fixed */
#define RBTX4925_IMCLK		(RBTX4925_GBUSCLK / 2) /* fixed */

#endif /* _LANGUAGE_ASSEMBLY */


/*
 * IRQ mappings
 */

#define RBTX4925_SOFT_INT0	0	/* not used */
#define RBTX4925_SOFT_INT1	1	/* not used */
#define RBTX4925_IRC_INT	2
#define RBTX4925_TIMER_INT	7

/* These are the virtual IRQ numbers, we divide all IRQ's into
 * 'spaces', the 'space' determines where and how to enable/disable
 * that particular IRQ on an RBTX4925 machine.  Add new 'spaces' as new
 * IRQ hardware is supported.
 */
#define RBTX4925_NR_IRQ_LOCAL	8
#define RBTX4925_NR_IRQ_IRC	32	/* On-Chip IRC */
#define RBTX4925_NR_IRQ_IOC	8
#define RBTX4925_NR_IRQ_IOC2	8
#define RBTX4925_NR_IRQ_PCMCIA	8
#define RBTX4925_NR_IRQ_ISAC	8	/* JMI-TX39IO2 ISA */

#define RBTX4925_IRQ_LOCAL	NR_ISA_IRQS
#define RBTX4925_IRQ_IRC	(RBTX4925_IRQ_LOCAL + RBTX4925_NR_IRQ_LOCAL)
#define RBTX4925_IRQ_IOC	(RBTX4925_IRQ_IRC + RBTX4925_NR_IRQ_IRC)
#define RBTX4925_IRQ_IOC2	(RBTX4925_IRQ_IOC + RBTX4925_NR_IRQ_IOC)
#define RBTX4925_IRQ_PCMCIA	(RBTX4925_IRQ_IOC2 + RBTX4925_NR_IRQ_IOC2)
#define RBTX4925_IRQ_ISAC	(RBTX4925_IRQ_PCMCIA + RBTX4925_NR_IRQ_PCMCIA)
#define RBTX4925_IRQ_END	RBTX4925_IRQ_ISAC

#define RBTX4925_IRQ_LOCAL_SOFT0	(RBTX4925_IRQ_LOCAL + RBTX4925_SOFT_INT0)
#define RBTX4925_IRQ_LOCAL_SOFT1	(RBTX4925_IRQ_LOCAL + RBTX4925_SOFT_INT0)
#define RBTX4925_IRQ_LOCAL_IRC	(RBTX4925_IRQ_LOCAL + RBTX4925_IRC_INT)
#define RBTX4925_IRQ_LOCAL_TIMER	(RBTX4925_IRQ_LOCAL + RBTX4925_TIMER_INT)
#define RBTX4925_IRQ_IRC_WTOERR	(RBTX4925_IRQ_IRC + TX4925_IR_WTOERR)
#define RBTX4925_IRQ_IRC_INT(n)	(RBTX4925_IRQ_IRC + TX4925_IR_INT(n))
#define RBTX4925_IRQ_IRC_NDFMC	(RBTX4925_IRQ_IRC + TX4925_IR_NDFMD)
#define RBTX4925_IRQ_IRC_SIO(n)	(RBTX4925_IRQ_IRC + TX4925_IR_SIO(n))
#define RBTX4925_IRQ_IRC_DMA(n)	(RBTX4925_IRQ_IRC + TX4925_IR_DMA(n))
#define RBTX4925_IRQ_IRC_PIO	(RBTX4925_IRQ_IRC + TX4925_IR_PIO)
#define RBTX4925_IRQ_IRC_PDMAC	(RBTX4925_IRQ_IRC + TX4925_IR_PDMAC)
#define RBTX4925_IRQ_IRC_PCIC	(RBTX4925_IRQ_IRC + TX4925_IR_PCIC)
#define RBTX4925_IRQ_IRC_TMR(n)	(RBTX4925_IRQ_IRC + TX4925_IR_TMR(n))
#define RBTX4925_IRQ_IRC_SPI	(RBTX4925_IRQ_IRC + TX4925_IR_SPI)
#define RBTX4925_IRQ_IRC_RTC	(RBTX4925_IRQ_IRC + TX4925_IR_RTC)
#define RBTX4925_IRQ_IRC_ACLC	(RBTX4925_IRQ_IRC + TX4925_IR_ACLC)
#define RBTX4925_IRQ_IRC_ACLCPME	(RBTX4925_IRQ_IRC + TX4925_IR_ACLCPME)
#define RBTX4925_IRQ_IRC_CHI	(RBTX4925_IRQ_IRC + TX4925_IR_CHI)
#define RBTX4925_IRQ_IRC_PCIERR	(RBTX4925_IRQ_IRC + TX4925_IR_PCIERR)
#define RBTX4925_IRQ_IRC_PCIPME	(RBTX4925_IRQ_IRC + TX4925_IR_PCIPME)
#define RBTX4925_IRQ_IOC_PCID	(RBTX4925_IRQ_IOC + RBTX4925_INTB_PCID)
#define RBTX4925_IRQ_IOC_PCIC	(RBTX4925_IRQ_IOC + RBTX4925_INTB_PCIC)
#define RBTX4925_IRQ_IOC_PCIB	(RBTX4925_IRQ_IOC + RBTX4925_INTB_PCIB)
#define RBTX4925_IRQ_IOC_PCIA	(RBTX4925_IRQ_IOC + RBTX4925_INTB_PCIA)
#define RBTX4925_IRQ_IOC_DSR	(RBTX4925_IRQ_IOC + RBTX4925_INTB_DSR)
#define RBTX4925_IRQ_IOC_INT2	(RBTX4925_IRQ_IOC + RBTX4925_INTB_INT2)
#define RBTX4925_IRQ_IOC_INT3	(RBTX4925_IRQ_IOC + RBTX4925_INTB_INT3)
#define RBTX4925_IRQ_IOC_SWI	(RBTX4925_IRQ_IOC + RBTX4925_INTB_SWI)
#define RBTX4925_IRQ_IOC_PCMCIA	(RBTX4925_IRQ_IOC2 + RBTX4925_INT2B_PCMCIA)

/* Modem (Do not use this. Set W1 to OPEN and use RBTX4925_IRQ_IOC_DSR */
/* #define RBTX4925_IRQ_MODEM	RBTX4925_IRQ_IRC_INT(5) */
/* IOC (PCI, etc) */
#define RBTX4925_IRQ_IOCINT	RBTX4925_IRQ_IRC_INT(0)
/* Onboard 10M Ether */
#define RBTX4925_IRQ_ETHER	RBTX4925_IRQ_IRC_INT(1)


/* LinkUp L1121 register definitions */
#define L1121_IDR1	0x00
#define L1121_IDR2	0x04
#define L1121_IDR3	0x08
#define L1121_IDR4	0x0c
#define L1121_SR	0x10
#define L1121_ISR	0x14
#define L1121_EISR	0x18
#define L1121_CR1	0x24
#define L1121_CR2	0x28
#define L1121_IER	0x2c
#define L1121_ESNR	0x30
#define L1121_ITSR	0x34
#define L1121_ECLR	0x38
#define L1121_CR3	0x3c
#define L1121_DACCR	0x40
#define L1121_DACDR	0x44

#define L1121_IDR1_VAL	0x01
#define L1121_IDR2_VAL	0x10
#define L1121_IDR3_VAL	0x12
#define L1121_IDR4_VAL	0x01
/* for SR, ISR, EISR, IER, ESNR, ITSR, ECLR */
#define L1121_CD1	7
#define L1121_CD2	6
#define L1121_IOIS16	5 /* IOIS16/WRP */
#define L1121_VS1	4
#define L1121_VS2	3
#define L1121_BVD1	2
#define L1121_BVD2	1
#define L1121_RDY	0
#define L1121_SR_CD1	(1<<L1121_CD1)
#define L1121_SR_CD2	(1<<L1121_CD2)
#define L1121_SR_IOIS16	(1<<L1121_IOIS16)
#define L1121_SR_VS1	(1<<L1121_VS1)
#define L1121_SR_VS2	(1<<L1121_VS2)
#define L1121_SR_BVD1	(1<<L1121_BVD1)
#define L1121_SR_BVD2	(1<<L1121_BVD2)
#define L1121_SR_RDY	(1<<L1121_RDY)
#define L1121_CR1_SOE	0x80
#define L1121_CR1_APOE	0x20
#define L1121_CR1_RESET	0x10
#define L1121_CR1_STOE	0x08
#define L1121_CR1_BIG	0x04
#define L1121_CR1_IRQP	0x02
#define L1121_CR1_DIRP	0x01
#define L1121_CR2_PDCS	0x80
#define L1121_CR2_RTRIM2	0x40
#define L1121_CR2_RTRIM1	0x20
#define L1121_CR2_DISS	0x10
#define L1121_CR2_S4	0x08
#define L1121_CR2_S3	0x04
#define L1121_CR2_S2	0x02
#define L1121_CR2_S1	0x01
#define L1121_CR3_MIO	0x10
#define L1121_CR3_CCDIE	0x08
#define L1121_CR3_WIRQE	0x04
#define L1121_CR3_WOR16E	0x02
#define L1121_CR3_WORWE	0x01

#define L1121_inb(reg)  (*(volatile unsigned char *)(RBTX4925_PCMCIA_BASE + (reg)))
#define L1121_outb(val, reg)  (*(volatile unsigned char *)(RBTX4925_PCMCIA_BASE + (reg)) = (val))

#endif /* __ASM_TOSHIBA_BOARDS_RBTX4925_H */
