/*
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 2000-2001 Toshiba Corporation
 */
#ifndef __ASM_TOSHIBA_BOARDS_TX4927EVB_H 
#define __ASM_TOSHIBA_BOARDS_TX4927EVB_H 

#include <asm/tx4927.h>
#include <asm/addrspace.h>
#include <asm/toshiba-boards/irq.h>

/* CS */
#if 1
/* use PMON's setting */
extern unsigned long tx4927evb_ce_base[8];
#define TX4927EVB_CE0	tx4927evb_ce_base[0]
#define TX4927EVB_CE1	tx4927evb_ce_base[1]
#define TX4927EVB_CE2	tx4927evb_ce_base[2]
#define TX4927EVB_CE3	tx4927evb_ce_base[3]
#define TX4927EVB_CE4	tx4927evb_ce_base[4]
#define TX4927EVB_CE5	tx4927evb_ce_base[5]
#define TX4927EVB_CE6	tx4927evb_ce_base[6]
#define TX4927EVB_CE7	tx4927evb_ce_base[7]
#else
#define TX4927EVB_CE0	0x1f000000	/* 16M */
#define TX4927EVB_CE1	0x1e000000	/* 16M */
#define TX4927EVB_CE2	0x1d000000	/* 16M */
#define TX4927EVB_CE3	0x17f00000	/* 1M */
#define TX4927EVB_CE4	0x14000000	/* 32M */
#define TX4927EVB_CE5	0x17000000	/* 4M */
#define TX4927EVB_CE6	0x16000000	/* 4M */
#define TX4927EVB_CE7	0x16400000	/* 4M */
#endif

/* Address map */
#define TX4927EVB_LEDDISP_BASE	(KSEG1 + TX4927EVB_CE3 + 0x00000000)
#define TX4927EVB_BRAMRTC_BASE	(KSEG1 + TX4927EVB_CE3 + 0x00010000)
#define TX4927EVB_SUPERIO_BASE	(KSEG1 + TX4927EVB_CE3 + 0x00020000)
#define TX4927EVB_KBD_BASE	(KSEG1 + TX4927EVB_CE3 + 0x00030000)
#define TX4927EVB_FPGA_REG_ADDR	(KSEG1 + TX4927EVB_CE3 + 0x00040000)
#define TX4927EVB_DIPSW3_ADDR	(KSEG1 + TX4927EVB_CE3 + 0x00040000)
#define TX4927EVB_DIPSW6_ADDR	(KSEG1 + TX4927EVB_CE3 + 0x00040001)
#define TX4927EVB_LED_ADDR	(KSEG1 + TX4927EVB_CE3 + 0x00040002)
#define TX4927EVB_SOFTRESET_ADDR	(KSEG1 + TX4927EVB_CE3 + 0x00040003)
#define TX4927EVB_PCIRESET_ADDR	(KSEG1 + TX4927EVB_CE3 + 0x00040004)
#define TX4927EVB_SOFTINT_ADDR	(KSEG1 + TX4927EVB_CE3 + 0x00040005)
#define TX4927EVB_INTPOL_ADDR	(KSEG1 + TX4927EVB_CE3 + 0x00040006)
#define TX4927EVB_INTPOL2_ADDR	(KSEG1 + TX4927EVB_CE3 + 0x00040007)
#define TX4927EVB_NUM_IOC_INTREGS	5
#define TX4927EVB_ISTAT_ADDR(n)	(KSEG1 + TX4927EVB_CE3 + 0x00040010 + (n))
#define TX4927EVB_IMASK_ADDR(n)	(KSEG1 + TX4927EVB_CE3 + 0x00040015 + (n))
#define TX4927EVB_IMSTAT_ADDR(n)	(KSEG1 + TX4927EVB_CE3 + 0x0004001a + (n))
#define TX4927EVB_NMI_STAT_ADDR	(KSEG1 + TX4927EVB_CE3 + 0x0004001f)
#define TX4927EVB_PCI_CLK_ADDR	(KSEG1 + TX4927EVB_CE3 + 0x00040020)
#define TX4927EVB_EXB_STAT_ADDR	(KSEG1 + TX4927EVB_CE3 + 0x00040021)
#define TX4927EVB_SIO_STAT_ADDR	(KSEG1 + TX4927EVB_CE3 + 0x00040022)
#define TX4927EVB_FPGA_REV_ADDR	(KSEG1 + TX4927EVB_CE3 + 0x00040030)
#define TX4927EVB_BOARD_REV_ADDR	(KSEG1 + TX4927EVB_CE3 + 0x00040031)

#define TX4927EVB_ETHER_BASE		(KSEG1 + TX4927EVB_CE4)

#define TX4927EVB_EXB0_BASE		(KSEG1 + TX4927EVB_CE6)
#define TX4927EVB_EXB1_BASE		(KSEG1 + TX4927EVB_CE7)

/* SuperIO Configuration Register */
#define TX4927EVB_SUPERIO_CONFIG	(TX4927EVB_SUPERIO_BASE + 0x398)
/* SuperIO SCC base address */
#define TX4927EVB_UART0_BASE	(TX4927EVB_SUPERIO_BASE + 0x3f8)
#define TX4927EVB_UART1_BASE	(TX4927EVB_SUPERIO_BASE + 0x2f8)
#if 1
#define TX4927EVB_BASE_BAUD	(24000000 / 13 / 16)	/* 24MHz, prescaler:13 */
#else
#define TX4927EVB_BASE_BAUD	(14318180 / 13 / 16)	/* 14.318MHz, prescaler:13 */
#endif
/* SuperIO Parallel port address (LPTB) */
#define TX4927EVB_LPT_ADDR	(TX4927EVB_SUPERIO_BASE + 0x378)

/* Ethernet port address (Jumperless Mode) */
#define TX4927EVB_ETHER_ADDR	(TX4927EVB_ETHER_BASE + 0x01000280)

/* Keyboard/Mouse */
#define TX4927EVB_KBD_ADDR	(TX4927EVB_KBD_BASE + 0x60)

/* IEEE1394 board */
#define TX4927EVB_JMY1394_BASE	(KSEG1 + TX4927EVB_CE2)
#define TX4927EVB_PREMIER3_BASE	(TX4927EVB_JMY1394_BASE + 0x00100000)

/* bits for ISTAT0/IMASK0/IMSTAT0 */
#define TX4927EVB_INT0B_RTC	0
#define TX4927EVB_INT0B_MOUSE	1
#define TX4927EVB_INT0B_KB	2
#define TX4927EVB_INT0B_PIO	3
#define TX4927EVB_INT0B_SIO(n)	(4 + (n))
#define TX4927EVB_INT0F_RTC	(1 << TX4927EVB_INT0B_RTC)
#define TX4927EVB_INT0F_MOUSE	(1 << TX4927EVB_INT0B_MOUSE)
#define TX4927EVB_INT0F_KB	(1 << TX4927EVB_INT0B_KB)
#define TX4927EVB_INT0F_PIO	(1 << TX4927EVB_INT0B_PIO)
#define TX4927EVB_INT0F_SIO(n)	(1 << TX4927EVB_INT0B_SIO(n))

/* bits for ISTAT1/IMASK1/IMSTAT1 */
#define TX4927EVB_INT1B_EXBINT(n)	(n)
#define TX4927EVB_INT1B_EXPIN	2
#define TX4927EVB_INT1B_IDSR(n)	(3 + (n) * 2)
#define TX4927EVB_INT1B_IDCD(n)	(4 + (n) * 2)
#define TX4927EVB_INT1F_EXBINT(n)	(1 << TX4927EVB_INT1B_EXBINT(n))
#define TX4927EVB_INT1F_EXPIN	(1 << TX4927EVB_INT1B_EXPIN)
#define TX4927EVB_INT1F_IDSR(n)	(1 << TX4927EVB_INT1B_IDSR(n))
#define TX4927EVB_INT1F_IDCD(n)	(1 << TX4927EVB_INT1B_IDCD(n))

/* bits for ISTAT2/IMASK2/IMSTAT2 */
#define TX4927EVB_INT2B_SOFTINT	0
#define TX4927EVB_INT2B_PUSHSW	1
#define TX4927EVB_INT2F_SOFTINT	(1 << TX4927EVB_INT2B_SOFTINT)
#define TX4927EVB_INT2F_PUSHSW	(1 << TX4927EVB_INT2B_PUSHSW)

/* bits for ISTAT3/IMASK3/IMSTAT3 */
#define TX4927EVB_INT3B_PCID	0
#define TX4927EVB_INT3B_PCIC	1
#define TX4927EVB_INT3B_PCIB	2
#define TX4927EVB_INT3B_PCIA	3
#define TX4927EVB_INT3F_PCID	(1 << TX4927EVB_INT3B_PCID)
#define TX4927EVB_INT3F_PCIC	(1 << TX4927EVB_INT3B_PCIC)
#define TX4927EVB_INT3F_PCIB	(1 << TX4927EVB_INT3B_PCIB)
#define TX4927EVB_INT3F_PCIA	(1 << TX4927EVB_INT3B_PCIA)

/* bits for ISTAT4/IMASK4/IMSTAT4 */
#define TX4927EVB_INT4B_LANC	0
#define TX4927EVB_INT4F_LANC	(1 << TX4927EVB_INT4B_LANC)

/* bits for NMI_STAT */
#define TX4927EVB_INTB_NMI_EXB	0
#define TX4927EVB_INTB_NMI_EXP	1
#define TX4927EVB_INTB_NMI_PSW	2
#define TX4927EVB_INTF_NMI_EXB	(1 << TX4927EVB_INTB_NMI_EXB)
#define TX4927EVB_INTF_NMI_EXP	(1 << TX4927EVB_INTB_NMI_EXP)
#define TX4927EVB_INTF_NMI_PSW	(1 << TX4927EVB_INTB_NMI_PSW)

/* bits for PCI_CLK (S6) */
#define TX4927EVB_PCI_CLK_HOST	0x80
#define TX4927EVB_PCI_CLK_MASK	(0x0f << 3)
#define TX4927EVB_PCI_CLK_33	(0x01 << 3)
#define TX4927EVB_PCI_CLK_25	(0x04 << 3)
#define TX4927EVB_PCI_CLK_66	(0x09 << 3)
#define TX4927EVB_PCI_CLK_50	(0x0c << 3)
#define TX4927EVB_PCI_CLK_ACK	0x04
#define TX4927EVB_PCI_CLK_ACE	0x02
#define TX4927EVB_PCI_CLK_ENDIAN	0x01

/* bits for SIO_STAT */
#define TX4927EVB_SIO_STAT_RI(ch)	(0x01 << (ch * 4))
#define TX4927EVB_SIO_STAT_DSR(ch)	(0x02 << (ch * 4))
#define TX4927EVB_SIO_STAT_DCD(ch)	(0x04 << (ch * 4))
#define TX4927EVB_SIO_STAT_DTR(ch)	(0x08 << (ch * 4))

#ifndef _LANGUAGE_ASSEMBLY
#define tx4927evb_leddisp_ptr	\
	((volatile unsigned char *)TX4927EVB_LEDDISP_BASE)
#define tx4927evb_bramrtc_ptr	\
	((volatile unsigned char *)TX4927EVB_BRAMRTC_BASE)
#define tx4927evb_dipsw3_ptr	\
	((volatile unsigned char *)TX4927EVB_DIPSW3_ADDR)
#define tx4927evb_dipsw6_ptr	\
	((volatile unsigned char *)TX4927EVB_DIPSW6_ADDR)
#define tx4927evb_led_ptr	\
	((volatile unsigned char *)TX4927EVB_LED_ADDR)
#define tx4927evb_softreset_ptr	\
	((volatile unsigned char *)TX4927EVB_SOFTRESET_ADDR)
#define tx4927evb_pcireset_ptr	\
	((volatile unsigned char *)TX4927EVB_PCIRESET_ADDR)
#define tx4927evb_softint_ptr	\
	((volatile unsigned char *)TX4927EVB_SOFTINT_ADDR)
#define tx4927evb_intpol_ptr	\
	((volatile unsigned char *)TX4927EVB_INTPOL_ADDR)
#define tx4927evb_intpol2_ptr	\
	((volatile unsigned char *)TX4927EVB_INTPOL2_ADDR)
#define tx4927evb_istat_ptr(n)	\
	((volatile unsigned char *)TX4927EVB_ISTAT_ADDR(n))
#define tx4927evb_imask_ptr(n)	\
	((volatile unsigned char *)TX4927EVB_IMASK_ADDR(n))
#define tx4927evb_imstat_ptr(n)	\
	((volatile unsigned char *)TX4927EVB_IMSTAT_ADDR(n))
#define tx4927evb_nmi_stat_ptr	\
	((volatile unsigned char *)TX4927EVB_NMI_STAT_ADDR)
#define tx4927evb_pci_clk_ptr	\
	((volatile unsigned char *)TX4927EVB_PCI_CLK_ADDR)
#define tx4927evb_exb_stat_ptr	\
	((volatile unsigned char *)TX4927EVB_EXB_STAT_ADDR)
#define tx4927evb_sio_stat_ptr	\
	((volatile unsigned char *)TX4927EVB_SIO_STAT_ADDR)
#define tx4927evb_fpga_rev_ptr	\
	((volatile unsigned char *)TX4927EVB_FPGA_REV_ADDR)
#define tx4927evb_board_rev_ptr	\
	((volatile unsigned char *)TX4927EVB_BOARD_REV_ADDR)

#define tx4927evb_led_on(n)	(*tx4927evb_led_ptr |= 1<<(n))
#define tx4927evb_led_off(n)	(*tx4927evb_led_ptr = *tx4927evb_led_ptr &~ (1<<(n)))
#define tx4927evb_led_toggle(n)	(*tx4927evb_led_ptr = *tx4927evb_led_ptr ^(1<<(n)))
#define tx4927evb_leddisp_addr(addr)	(tx4927evb_leddisp_ptr+((addr)<<2))
#define tx4927evb_leddisp_putc(n, c)	(*tx4927evb_leddisp_addr(0x38|((n)&7)) = (c))
extern void tx4927evb_leddisp_puts(const char *s);
extern void tx4927evb_leddisp_put(unsigned long val);

/* clock */
extern int tx4927evb_master_clock;
extern int tx4927evb_gbus_clock;
#define TX4927EVB_GBUSCLK	tx4927evb_gbus_clock
#define TX4927EVB_IMCLK		(TX4927EVB_GBUSCLK / 2)

#endif /* _LANGUAGE_ASSEMBLY */


/*
 * IRQ mappings
 */

#define TX4927EVB_SOFT_INT0	0	/* not used */
#define TX4927EVB_SOFT_INT1	1	/* not used */
#define TX4927EVB_IRC_INT	2
#define TX4927EVB_TIMER_INT	7

/* These are the virtual IRQ numbers, we divide all IRQ's into
 * 'spaces', the 'space' determines where and how to enable/disable
 * that particular IRQ on an TX4927EVB machine.  Add new 'spaces' as new
 * IRQ hardware is supported.
 */
#define TX4927EVB_NR_IRQ_LOCAL	8
#define TX4927EVB_NR_IRQ_IRC	32	/* On-Chip IRC */
#define TX4927EVB_NR_IRQ_IOC	8	/* IOC0, ... IOC4 */

#define TX4927EVB_IRQ_LOCAL	NR_ISA_IRQS
#define TX4927EVB_IRQ_IRC	(TX4927EVB_IRQ_LOCAL + TX4927EVB_NR_IRQ_LOCAL)
#define TX4927EVB_IRQ_IOC0	(TX4927EVB_IRQ_IRC + TX4927EVB_NR_IRQ_IRC)
#define TX4927EVB_IRQ_IOC(n)	(TX4927EVB_IRQ_IOC0 + TX4927EVB_NR_IRQ_IOC*(n))
#define TX4927EVB_IRQ_END	TX4927EVB_IRQ_IOC(5)

#define TX4927EVB_IRQ_LOCAL_SOFT0	(TX4927EVB_IRQ_LOCAL + TX4927EVB_SOFT_INT0)
#define TX4927EVB_IRQ_LOCAL_SOFT1	(TX4927EVB_IRQ_LOCAL + TX4927EVB_SOFT_INT0)
#define TX4927EVB_IRQ_LOCAL_IRC	(TX4927EVB_IRQ_LOCAL + TX4927EVB_IRC_INT)
#define TX4927EVB_IRQ_LOCAL_TIMER	(TX4927EVB_IRQ_LOCAL + TX4927EVB_TIMER_INT)
#define TX4927EVB_IRQ_IRC_ECCERR	(TX4927EVB_IRQ_IRC + TX4927_IR_ECCERR)
#define TX4927EVB_IRQ_IRC_WTOERR	(TX4927EVB_IRQ_IRC + TX4927_IR_WTOERR)
#define TX4927EVB_IRQ_IRC_INT(n)	(TX4927EVB_IRQ_IRC + TX4927_IR_INT(n))
#define TX4927EVB_IRQ_IRC_SIO(n)	(TX4927EVB_IRQ_IRC + TX4927_IR_SIO(n))
#define TX4927EVB_IRQ_IRC_DMA(n)	(TX4927EVB_IRQ_IRC + TX4927_IR_DMA(n))
#define TX4927EVB_IRQ_IRC_PIO	(TX4927EVB_IRQ_IRC + TX4927_IR_PIO)
#define TX4927EVB_IRQ_IRC_PDMAC	(TX4927EVB_IRQ_IRC + TX4927_IR_PDMAC)
#define TX4927EVB_IRQ_IRC_PCIC	(TX4927EVB_IRQ_IRC + TX4927_IR_PCIC)
#define TX4927EVB_IRQ_IRC_TMR(n)	(TX4927EVB_IRQ_IRC + TX4927_IR_TMR(n))
#define TX4927EVB_IRQ_IRC_PCIERR	(TX4927EVB_IRQ_IRC + TX4927_IR_PCIERR)
#define TX4927EVB_IRQ_IRC_PCIPMA	(TX4927EVB_IRQ_IRC + TX4927_IR_PCIPMA)
#define TX4927EVB_IRQ_IRC_ACLC	(TX4927EVB_IRQ_IRC + TX4927_IR_ACLC)
#define TX4927EVB_IRQ_IRC_ACKCPMA	(TX4927EVB_IRQ_IRC + TX4927_IR_ACKCPMA)
#define TX4927EVB_IRQ_IOC_RTC	(TX4927EVB_IRQ_IOC(0) + TX4927EVB_INT0B_RTC)
#define TX4927EVB_IRQ_IOC_MOUSE	(TX4927EVB_IRQ_IOC(0) + TX4927EVB_INT0B_MOUSE)
#define TX4927EVB_IRQ_IOC_KB	(TX4927EVB_IRQ_IOC(0) + TX4927EVB_INT0B_KB)
#define TX4927EVB_IRQ_IOC_PIO	(TX4927EVB_IRQ_IOC(0) + TX4927EVB_INT0B_PIO)
#define TX4927EVB_IRQ_IOC_SIO(n)	(TX4927EVB_IRQ_IOC(0) + TX4927EVB_INT0B_SIO(n))
#define TX4927EVB_IRQ_IOC_EXBINT(n)	(TX4927EVB_IRQ_IOC(1) + TX4927EVB_INT1B_EXBINT(n))
#define TX4927EVB_IRQ_IOC_EXPIN	(TX4927EVB_IRQ_IOC(1) + TX4927EVB_INT1B_EXPIN)
#define TX4927EVB_IRQ_IOC_IDSR(n)	(TX4927EVB_IRQ_IOC(1) + TX4927EVB_INT1B_IDSR(n))
#define TX4927EVB_IRQ_IOC_IDCD(n)	(TX4927EVB_IRQ_IOC(1) + TX4927EVB_INT1B_IDCD(n))
#define TX4927EVB_IRQ_IOC_SOFTINT	(TX4927EVB_IRQ_IOC(2) + TX4927EVB_INT2B_SOFTINT)
#define TX4927EVB_IRQ_IOC_PUSHSW	(TX4927EVB_IRQ_IOC(2) + TX4927EVB_INT2B_PUSHSW)
#define TX4927EVB_IRQ_IOC_PCID	(TX4927EVB_IRQ_IOC(3) + TX4927EVB_INT3B_PCID)
#define TX4927EVB_IRQ_IOC_PCIC	(TX4927EVB_IRQ_IOC(3) + TX4927EVB_INT3B_PCIC)
#define TX4927EVB_IRQ_IOC_PCIB	(TX4927EVB_IRQ_IOC(3) + TX4927EVB_INT3B_PCIB)
#define TX4927EVB_IRQ_IOC_PCIA	(TX4927EVB_IRQ_IOC(3) + TX4927EVB_INT3B_PCIA)
#define TX4927EVB_IRQ_IOC_LANC	(TX4927EVB_IRQ_IOC(4) + TX4927EVB_INT4B_LANC)

#define TX4927EVB_IRQ_PREMIER3	TX4927EVB_IRQ_IOC_EXBINT(0)

#endif /* __ASM_TOSHIBA_BOARDS_TX4927EVB_H */
