/*
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 2000-2001 Toshiba Corporation
 */
#ifndef __ASM_MIPS_TX4925_H 
#define __ASM_MIPS_TX4925_H 

#include <asm/txx927.h>

#define TX4925_REG_BASE	0xff1f0000
#define TX4925_REG_SIZE	0x00010000

#define TX4925_SDRAMC_REG	(TX4925_REG_BASE + 0x8000)
#define TX4925_EBUSC_REG	(TX4925_REG_BASE + 0x9000)
#define TX4925_DMA_REG		(TX4925_REG_BASE + 0xb000)
#define TX4925_NDFMC_REG	(TX4925_REG_BASE + 0xc000)
#define TX4925_PCIC_REG		(TX4925_REG_BASE + 0xd000)
#define TX4925_CCFG_REG		(TX4925_REG_BASE + 0xe000)
#define TX4925_NR_TMR	3
#define TX4925_TMR_REG(ch)	((TX4925_REG_BASE + 0xf000) + (ch) * 0x100)
#define TX4925_NR_SIO	2
#define TX4925_SIO_REG(ch)	((TX4925_REG_BASE + 0xf300) + (ch) * 0x100)
#define TX4925_PIO_REG		(TX4925_REG_BASE + 0xf500)
#define TX4925_IRC_REG		(TX4925_REG_BASE + 0xf600)
#define TX4925_ACLC_REG		(TX4925_REG_BASE + 0xf700)
#define TX4925_RTC_REG		(TX4925_REG_BASE + 0xf900)

#ifndef _LANGUAGE_ASSEMBLY

#include <asm/byteorder.h>

struct tx4925_sdramc_reg {
	volatile unsigned long cr[4];
	volatile unsigned long unused0[4];
	volatile unsigned long tr;
	volatile unsigned long unused1[2];
	volatile unsigned long cmd;
	volatile unsigned long sfcmd;
};

struct tx4925_ebusc_reg {
	struct {
		volatile unsigned long cr;
		volatile unsigned long bar;
	} ch[8];
};

struct tx4925_dma_reg {
	struct tx4925_dma_ch_reg {
		volatile unsigned long cha;
		volatile unsigned long sar;
		volatile unsigned long dar;
		volatile unsigned long cntr;
		volatile unsigned long sair;
		volatile unsigned long dair;
		volatile unsigned long ccr;
		volatile unsigned long csr;
	} ch[4];
	volatile unsigned long unused[9];
	volatile unsigned long mfdr;
	volatile unsigned long mcr;
};

struct tx4925_ndfmc_reg {
	volatile unsigned long dtr;
	volatile unsigned long mcr;
	volatile unsigned long sr;
	volatile unsigned long isr;
	volatile unsigned long imr;
	volatile unsigned long spr;
	volatile unsigned long rstr;
};

struct tx4925_irc_reg {
	volatile unsigned long cer;
	volatile unsigned long cr[2];
	volatile unsigned long unused0;
	volatile unsigned long ilr[8];
	volatile unsigned long unused1[4];
	volatile unsigned long imr;
	volatile unsigned long unused2[7];
	volatile unsigned long scr;
	volatile unsigned long unused3[7];
	volatile unsigned long ssr;
	volatile unsigned long unused4[7];
	volatile unsigned long csr;
};

struct tx4925_pcic_reg {
	volatile unsigned long pciid;
	volatile unsigned long pcistatus;
	volatile unsigned long pciccrev;
	volatile unsigned long pcicfg1;
	volatile unsigned long p2gm0plbase;		/* +10 */
	volatile unsigned long p2gm1plbase;
	volatile unsigned long p2gm2pbase;
	volatile unsigned long p2giopbase;
	volatile unsigned long unused0[3];		/* +20 */
	volatile unsigned long pcisid;
	volatile unsigned long unused1;		/* +30 */
	volatile unsigned long pcicapptr;
	volatile unsigned long unused2;
	volatile unsigned long pcicfg2;
	volatile unsigned long g2ptocnt;		/* +40 */
	volatile unsigned long unused3[7];
	volatile unsigned long g2pcfg;		/* +60 */
	volatile unsigned long g2pstatus;
	volatile unsigned long g2pmask;
	volatile unsigned long unused4[7];
	volatile unsigned long pcisstatus;
	volatile unsigned long pcimask;
	volatile unsigned long p2gcfg;		/* +90 */
	volatile unsigned long p2gstatus;
	volatile unsigned long p2gmask;
	volatile unsigned long p2gccmd;
	volatile unsigned long unused5[24];		/* +a0 */
	volatile unsigned long pbareqport;		/* +100 */
	volatile unsigned long pbacfg;
	volatile unsigned long pbastatus;
	volatile unsigned long pbamask;
	volatile unsigned long pbabm;		/* +110 */
	volatile unsigned long pbacreq;
	volatile unsigned long pbacgnt;
	volatile unsigned long pbacstate;
	volatile unsigned long g2pm0gbase __attribute__ ((aligned (8))); /* +120 */
	volatile unsigned long g2pm1gbase __attribute__ ((aligned (8)));
	volatile unsigned long g2pm2gbase __attribute__ ((aligned (8)));
	volatile unsigned long g2piogbase __attribute__ ((aligned (8)));
	volatile unsigned long g2pmmask[3] __attribute__ ((aligned (8)));	/* +140 */
	volatile unsigned long g2piomask;
	volatile unsigned long g2pm0pbase __attribute__ ((aligned (8)));		/* +150 */
	volatile unsigned long g2pm1pbase __attribute__ ((aligned (8)));
	volatile unsigned long g2pm2pbase __attribute__ ((aligned (8)));
	volatile unsigned long g2piopbase __attribute__ ((aligned (8)));
	volatile unsigned long pciccfg __attribute__ ((aligned (8)));	/* +170 */
	volatile unsigned long pcicstatus;
	volatile unsigned long pcicmask;
	volatile unsigned long unused6;
	volatile unsigned long p2gm0gbase;		/* +180 */
	volatile unsigned long p2gm0ctr;
	volatile unsigned long p2gm1gbase;
	volatile unsigned long p2gm1ctr;
	volatile unsigned long p2gm2gbase;
	volatile unsigned long p2gm2ctr;
	volatile unsigned long p2giogbase;
	volatile unsigned long p2gioctr;
	volatile unsigned long g2pcfgadrs;		/* +1a0 */
	volatile unsigned long g2pcfgdata;
	volatile unsigned long unused7[2];
	volatile unsigned long g2pidadrs __attribute__ ((aligned (8)));	/* +1b0 */
	volatile unsigned long g2piddata __attribute__ ((aligned (8)));
	volatile unsigned long g2pidcmd __attribute__ ((aligned (8)));
	volatile unsigned long g2pintack __attribute__ ((aligned (8)));
	volatile unsigned long g2pspc;
	volatile unsigned long unused8[12];		/* +1d0 */
	volatile unsigned long pdmca;		/* +200 */
	volatile unsigned long pdmga;
	volatile unsigned long pdmpa;
	volatile unsigned long pdmctr;
	volatile unsigned long pdmcfg;
	volatile unsigned long pdmsts;
};

struct tx4925_ccfg_reg {
	volatile unsigned long ccfg;
	volatile unsigned long revid;
	volatile unsigned long pcfg;
	volatile unsigned long toea;
	volatile unsigned long pdnctr;
	volatile unsigned long unused0;
	volatile unsigned long garbp;
	volatile unsigned long unused1;
	volatile unsigned long tocnt;
	volatile unsigned long drqctr;
	volatile unsigned long clkctr;
	volatile unsigned long garbc;
	volatile unsigned long ramp;
	volatile unsigned long jmpadr;
};

struct tx4925_rtc_reg {
	volatile unsigned long rtchi;
	volatile unsigned long rtclo;
	volatile unsigned long alarmhi;
	volatile unsigned long alarmlo;
	volatile unsigned long rtcctrl;
	volatile unsigned long rtcint;
};

#endif /* _LANGUAGE_ASSEMBLY */

/*
 * SDRAMC
 */

/*
 * EBUSC
 */

/*
 * DMA
 */
/* bits for MCR */
#define TX4925_DMA_MCR_EIS(ch)	(0x10000000<<(ch))
#define TX4925_DMA_MCR_DIS(ch)	(0x01000000<<(ch))
#define TX4925_DMA_MCR_RSFIF	0x00000080
#define TX4925_DMA_MCR_FIFUM(ch)	(0x00000008<<(ch))
#define TX4925_DMA_MCR_RPRT	0x00000002
#define TX4925_DMA_MCR_MSTEN	0x00000001

/* bits for CCRn */
#define TX4925_DMA_CCR_IMMCHN	0x20000000
#define TX4925_DMA_CCR_USEXFSZ	0x10000000
#define TX4925_DMA_CCR_LE	0x08000000
#define TX4925_DMA_CCR_DBINH	0x04000000
#define TX4925_DMA_CCR_SBINH	0x02000000
#define TX4925_DMA_CCR_CHRST	0x01000000
#define TX4925_DMA_CCR_RVBYTE	0x00800000
#define TX4925_DMA_CCR_ACKPOL	0x00400000
#define TX4925_DMA_CCR_REQPL	0x00200000
#define TX4925_DMA_CCR_EGREQ	0x00100000
#define TX4925_DMA_CCR_CHDN	0x00080000
#define TX4925_DMA_CCR_DNCTL	0x00060000
#define TX4925_DMA_CCR_EXTRQ	0x00010000
#define TX4925_DMA_CCR_INTRQD	0x0000e000
#define TX4925_DMA_CCR_INTENE	0x00001000
#define TX4925_DMA_CCR_INTENC	0x00000800
#define TX4925_DMA_CCR_INTENT	0x00000400
#define TX4925_DMA_CCR_CHNEN	0x00000200
#define TX4925_DMA_CCR_XFACT	0x00000100
#define TX4925_DMA_CCR_SMPCHN	0x00000020
#define TX4925_DMA_CCR_XFSZ(order)	(((order) << 2) & 0x0000001c)
#define TX4925_DMA_CCR_XFSZ_1W	TX4925_DMA_CCR_XFSZ(2)
#define TX4925_DMA_CCR_XFSZ_2W	TX4925_DMA_CCR_XFSZ(3)
#define TX4925_DMA_CCR_XFSZ_4W	TX4925_DMA_CCR_XFSZ(4)
#define TX4925_DMA_CCR_XFSZ_8W	TX4925_DMA_CCR_XFSZ(5)
#define TX4925_DMA_CCR_XFSZ_16W	TX4925_DMA_CCR_XFSZ(6)
#define TX4925_DMA_CCR_XFSZ_32W	TX4925_DMA_CCR_XFSZ(7)
#define TX4925_DMA_CCR_MEMIO	0x00000002
#define TX4925_DMA_CCR_SNGAD	0x00000001

/* bits for CSRn */
#define TX4925_DMA_CSR_CHNEN	0x00000400
#define TX4925_DMA_CSR_STLXFER	0x00000200
#define TX4925_DMA_CSR_CHNACT	0x00000100
#define TX4925_DMA_CSR_ABCHC	0x00000080
#define TX4925_DMA_CSR_NCHNC	0x00000040
#define TX4925_DMA_CSR_NTRNFC	0x00000020
#define TX4925_DMA_CSR_EXTDN	0x00000010
#define TX4925_DMA_CSR_CFERR	0x00000008
#define TX4925_DMA_CSR_CHERR	0x00000004
#define TX4925_DMA_CSR_DESERR	0x00000002
#define TX4925_DMA_CSR_SORERR	0x00000001

/*
 * NDFMC
 */

/* NDFMCR : NDFMC Mode Control */
#define TX4925_NDFMCR_WE	0x80
#define TX4925_NDFMCR_ECC_ALL	0x60
#define TX4925_NDFMCR_ECC_RESET	0x60
#define TX4925_NDFMCR_ECC_READ	0x40
#define TX4925_NDFMCR_ECC_ON	0x20
#define TX4925_NDFMCR_ECC_OFF	0x00
#define TX4925_NDFMCR_CE	0x10
#define TX4925_NDFMCR_BSPRT	0x04
#define TX4925_NDFMCR_ALE	0x02
#define TX4925_NDFMCR_CLE	0x01

/* NDFMCR : NDFMC Status */
#define TX4925_NDFSR_BUSY	0x80

/* NDFMCR : NDFMC Reset */
#define TX4925_NDFRSTR_RST	0x01

/*
 * IRC
 */
#define TX4925_IR_MAX_LEVEL	7

/* IRCER : Int. Control Enable */
#define TX4925_IRCER_ICE	0x00000001

/* IRCR : Int. Control */
#define TX4925_IRCR_LOW	0x00000000
#define TX4925_IRCR_HIGH	0x00000001
#define TX4925_IRCR_DOWN	0x00000002
#define TX4925_IRCR_UP	0x00000003

/* IRSCR : Int. Status Control */
#define TX4925_IRSCR_EIClrLE	0x00000100
#define TX4925_IRSCR_EIClrL_MASK	0x0000000f

/* IRCSR : Int. Current Status */
#define TX4925_IRCSR_IF	0x00010000
#define TX4925_IRCSR_ILV_MASK	0x00000700
#define TX4925_IRCSR_IVL_MASK	0x0000001f

#define TX4925_IR_WTOERR	1
#define TX4925_NUM_IR_INT	8
#define TX4925_IR_INT(n)	(2 + (n))
#define TX4925_IR_NDFMC	11
#define TX4925_NUM_IR_SIO	2
#define TX4925_IR_SIO(n)	(12 + (n))
#define TX4925_NUM_IR_DMA	4
#define TX4925_IR_DMA(n)	(14 + (n))
#define TX4925_IR_PIO	18
#define TX4925_IR_PDMAC	19
#define TX4925_IR_PCIC	10
#define TX4925_NUM_IR_TMR	3
#define TX4925_IR_TMR(n)	(21 + (n))
#define TX4925_IR_SPI	24
#define TX4925_IR_RTC	25
#define TX4925_IR_ACLC	26
#define TX4925_IR_ACLCPME	27
#define TX4925_IR_CHI	28
#define TX4925_IR_PCIERR	29
#define TX4925_IR_PCIPME	30
#define TX4925_NUM_IR	32

/*
 * PCIC
 */
/* bits for PCICMD */
/* see PCI_COMMAND_XXX in linux/pci.h */

/* bits for PCISTAT */
/* see PCI_STATUS_XXX in linux/pci.h */

/* bits for IOBA/MBA */
/* see PCI_BASE_ADDRESS_XXX in linux/pci.h */

/* bits for G2PCFG */
#define TX4925_PCIC_G2PCFG_BSWAPM0	0x00000800
#define TX4925_PCIC_G2PCFG_BSWAPM1	0x00000400
#define TX4925_PCIC_G2PCFG_BSWAPM2	0x00000200
#define TX4925_PCIC_G2PCFG_BSWAPIO	0x00000100
#define TX4925_PCIC_G2PCFG_G2PM0EN	0x00000080
#define TX4925_PCIC_G2PCFG_G2PM1EN	0x00000040
#define TX4925_PCIC_G2PCFG_G2PM2EN	0x00000020
#define TX4925_PCIC_G2PCFG_G2PIOEN	0x00000010
#define TX4925_PCIC_G2PCFG_IRBER	0x00000008
#define TX4925_PCIC_G2PCFG_BSWAPI	0x00000002
#define TX4925_PCIC_G2PCFG_ASERR	0x00000001

/* bits for G2PSTATUS/G2PMASK */
#define TX4925_PCIC_G2PSTATUS_ALL	0x000001ff
#define TX4925_PCIC_G2PSTATUS_IOBFE	0x00000100
#define TX4925_PCIC_G2PSTATUS_IIBFE	0x00000080
#define TX4925_PCIC_G2PSTATUS_MDFE	0x00000040
#define TX4925_PCIC_G2PSTATUS_MDPE	0x00000020
#define TX4925_PCIC_G2PSTATUS_IDICC	0x00000010
#define TX4925_PCIC_G2PSTATUS_MIDPE	0x00000008
#define TX4925_PCIC_G2PSTATUS_MIDFE	0x00000004
#define TX4925_PCIC_G2PSTATUS_IDTTOE	0x00000002
#define TX4925_PCIC_G2PSTATUS_IDRTOE	0x00000001

/* bits for PCIMASK (see also PCI_STATUS_XXX in linux/pci.h */
#define TX4925_PCIC_PCISTATUS_ALL	0x0000f900

/* bits for PBACFG */
#define TX4925_PCIC_PBACFG_FIXPA	0x00000008
#define TX4925_PCIC_PBACFG_RPBA	0x00000004
#define TX4925_PCIC_PBACFG_PBAEN	0x00000002
#define TX4925_PCIC_PBACFG_BMCEN	0x00000001

/* bits for PCICSTATUS/PCICMASK */
#define TX4925_PCIC_PCICSTATUS_ALL	0x00000001
#define TX4925_PCIC_PCICSTATUS_SERR	0x00000001

/* bits for PCICCFG */
#define TX4925_PCIC_PCICCFG_GBWC_MASK	0x000fff00
#define TX4925_PCIC_PCICCFG_TOE	0x00000010
#define TX4925_PCIC_PCICCFG_HRST	0x00000008
#define TX4925_PCIC_PCICCFG_SRST	0x00000004
#define TX4925_PCIC_PCICCFG_TCAR	0x00000002
#define TX4925_PCIC_PCICCFG_LCFG	0x00000001

/* bits for P2GMnCTR */
#define TX4925_PCIC_P2GMnCTR_AM	0x1ff00000
#define TX4925_PCIC_P2GMnCTR_TPRBL_MASK	0x00000700
#define TX4925_PCIC_P2GMnCTR_TPRBL_1DW	0x00000000
#define TX4925_PCIC_P2GMnCTR_TPRBL_4DW	0x00000100
#define TX4925_PCIC_P2GMnCTR_TPRBL_8DW	0x00000200
#define TX4925_PCIC_P2GMnCTR_TPRBL_16DW	0x00000300
#define TX4925_PCIC_P2GMnCTR_TPRBL_32DW	0x00000400
#define TX4925_PCIC_P2GMnCTR_TMCC	0x00000010
#define TX4925_PCIC_P2GMnCTR_TMCE	0x00000008
#define TX4925_PCIC_P2GMnCTR_PE	0x00000004
#define TX4925_PCIC_P2GMnCTR_EN	0x00000002
#define TX4925_PCIC_P2GMnCTR_BSWAP	0x00000001

/* bits for P2GIOCTR */
#define TX4925_PCIC_P2GIOCTR_AM	0x0000ff00
#define TX4925_PCIC_P2GIOCTR_EN	0x00000002
#define TX4925_PCIC_P2GIOCTR_BSWAP	0x00000001

#define TX4925_PCIC_IDSEL_AD_TO_SLOT(ad)	((ad) - 11)
#define TX4925_PCIC_MAX_DEVNU	TX4925_PCIC_IDSEL_AD_TO_SLOT(32)

/*
 * CCFG
 */
/* CCFG : Chip Configuration */
#define TX4925_CCFG_RF_MASK	0x03000000
#define TX4925_CCFG_RF_FULL	0x00000000
#define TX4925_CCFG_RF_DIV2	0x01000000
#define TX4925_CCFG_RF_DIV4	0x02000000
#define TX4925_CCFG_RF_DIV8	0x03000000
#define TX4925_CCFG_PCIMODE	0x00100000
#define TX4925_CCFG_TINTDIS	0x00020000
#define TX4925_CCFG_BEOW	0x00010000
#define TX4925_CCFG_WR	0x00008000
#define TX4925_CCFG_TOE	0x00004000
#define TX4925_CCFG_PCIARB	0x00002000
#define TX4925_CCFG_BSM	0x00001000
#define TX4925_CCFG_SYSSP_MASK	0x000000c0
#define TX4925_CCFG_BCLKSP_MASK	0x00000030
#define TX4925_CCFG_PCTRCE	0x00000008
#define TX4925_CCFG_ENDIAN	0x00000004
#define TX4925_CCFG_WDRST	0x00000002
#define TX4925_CCFG_UAEHOLD	0x00000001

/* PCFG : Pin Configuration */
#define TX4925_PCFG_SYSCLKEN	0x80000000
#define TX4925_PCFG_SDCLKEN_ALL	0x60000000
#define TX4925_PCFG_SDCLKEN(ch)	(0x20000000<<(ch))
#define TX4925_PCFG_PCICLKEN_ALL	0x1c000000
#define TX4925_PCFG_PCICLKEN(ch)	(0x04000000<<(ch))
#define TX4925_PCFG_SELBCLK	0x00400000
#define TX4925_PCFG_SELSPI	0x00200000
#define TX4925_PCFG_SELCHIK	0x00100000
#define TX4925_PCFG_SELCARD_ALL	0x000c0000
#define TX4925_PCFG_SELCARD(ch)	(0x00040000<<(ch))
#define TX4925_PCFG_SELCE_ALL	0x00030000
#define TX4925_PCFG_SELCE(ch)	(0x00010000<<(ch))
#define TX4925_PCFG_SELSIOC_ALL	0x0000c000
#define TX4925_PCFG_SELSIOC(ch)	(0x00004000<<(ch))
#define TX4925_PCFG_SELSIO_ALL	0x00003000
#define TX4925_PCFG_SELSIO(ch)	(0x00001000<<(ch))
#define TX4925_PCFG_ACKIN	0x00000800
#define TX4925_PCFG_SELTMR_ALL	0x00000600
#define TX4925_PCFG_SELTMR(ch)	(0x00000200<<(ch))
#define TX4925_PCFG_SELDONE	0x00000100
#define TX4925_PCFG_SELACLC	0x00000008
#define TX4925_PCFG_SELNAND	0x00000004
#define TX4925_PCFG_SELDMA_ALL	0x00000003
#define TX4925_PCFG_SELDMA(ch)	(0x00000001<<(ch))

/* DRQCTR : DMA Request Control */
#define TX4925_DRQCTR_SIO0RX	0
#define TX4925_DRQCTR_SIO1RX	1
#define TX4925_DRQCTR_SIO0TX	2
#define TX4925_DRQCTR_SIO1TX	3
#define TX4925_DRQCTR_ACLC0	4
#define TX4925_DRQCTR_ACLC1	5
#define TX4925_DRQCTR_ACLC2	6
#define TX4925_DRQCTR_ACLC3	7
#define TX4925_DRQCTR_DREQ	8

/* CLKCTR : Clock Control */
#define TX4925_CLKCTR_PCICKE	0x08000000
#define TX4925_CLKCTR_DMACKE	0x04000000
#define TX4925_CLKCTR_DESCKE	0x02000000
#define TX4925_CLKCTR_SIO0CKE	0x01000000
#define TX4925_CLKCTR_SIO1CKE	0x00800000
#define TX4925_CLKCTR_TMR0CKE	0x00400000
#define TX4925_CLKCTR_TMR1CKE	0x00200000
#define TX4925_CLKCTR_TMR2CKE	0x00100000
#define TX4925_CLKCTR_CHICKE	0x00080000
#define TX4925_CLKCTR_SPICKE	0x00040000
#define TX4925_CLKCTR_ACLCKE	0x00020000
#define TX4925_CLKCTR_PIOCKE	0x00010000
#define TX4925_CLKCTR_PCIRSTI	0x00000800
#define TX4925_CLKCTR_DMARSTI	0x00000400
#define TX4925_CLKCTR_DESRSTI	0x00000200
#define TX4925_CLKCTR_SIO0RSTI	0x00000100
#define TX4925_CLKCTR_SIO1RSTI	0x00000080
#define TX4925_CLKCTR_TMR0RSTI	0x00000040
#define TX4925_CLKCTR_TMR1RSTI	0x00000020
#define TX4925_CLKCTR_TMR2RSTI	0x00000010
#define TX4925_CLKCTR_CHIRSTI	0x00000008
#define TX4925_CLKCTR_SPIRSTI	0x00000004
#define TX4925_CLKCTR_ACLRSTI	0x00000002
#define TX4925_CLKCTR_PIORSTI	0x00000001

#ifndef _LANGUAGE_ASSEMBLY

#define tx4925_sdramcptr	((struct tx4925_sdramc_reg *)TX4925_SDRAMC_REG)
#define tx4925_ebuscptr		((struct tx4925_ebusc_reg *)TX4925_EBUSC_REG)
#define tx4925_dmaptr		((struct tx4925_dma_reg *)TX4925_DMA_REG)
#define tx4925_ndfmcptr		((struct tx4925_ndfmc_reg *)TX4925_NDFMC_REG)
#define tx4925_ircptr		((struct tx4925_irc_reg *)TX4925_IRC_REG)
#define tx4925_pcicptr		((struct tx4925_pcic_reg *)TX4925_PCIC_REG)
#define tx4925_ccfgptr		((struct tx4925_ccfg_reg *)TX4925_CCFG_REG)
#define tx4925_tmrptr(ch)	((struct txx927_tmr_reg *)TX4925_TMR_REG(ch))
#define tx4925_sioptr(ch)	((struct txx927_sio_reg *)TX4925_SIO_REG(ch))
#define tx4925_pioptr		((struct txx927_pio_reg *)TX4925_PIO_REG)
#define tx4925_aclcptr		((struct tx4925_aclc_reg *)TX4925_ACLC_REG)
#define tx4925_rtcptr		((struct tx4925_rtc_reg *)TX4925_RTC_REG)

#define TX4925_REV_MAJ_MIN()	(tx4925_ccfgptr->revid & 0x00ff)
#define TX4925_REV_PCODE()	(tx4925_ccfgptr->revid >> 16)

#endif /* _LANGUAGE_ASSEMBLY */

#endif /* __ASM_MIPS_TX4925_H */
