/*
 * Defines for the V3 Semiconductor V320 USC PCI Controller Chip.
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 1999 Toshiba Corporation
 */
#ifndef __ASM_V320USC_H 
#define __ASM_V320USC_H 

#ifndef _LANGUAGE_ASSEMBLY

#include <asm/byteorder.h>

#ifdef __BIG_ENDIAN
#define usc_endian_def_s2(e1,e2)	\
	volatile unsigned short e1,e2
#define usc_endian_def_sb2(e1,e2,e3)	\
	volatile unsigned short e1;volatile unsigned char e2,e3
#define usc_endian_def_b2s(e1,e2,e3)	\
	volatile unsigned char e1,e2;volatile unsigned short e3
#define usc_endian_def_b4(e1,e2,e3,e4)	\
	volatile unsigned char e1,e2,e3,e4
#else
#define usc_endian_def_s2(e1,e2)	\
	volatile unsigned short e2,e1
#define usc_endian_def_sb2(e1,e2,e3)	\
	volatile unsigned char e3,e2;volatile unsigned short e1
#define usc_endian_def_b2s(e1,e2,e3)	\
	volatile unsigned short e3;volatile unsigned char e2,e1
#define usc_endian_def_b4(e1,e2,e3,e4)	\
	volatile unsigned char e4,e3,e2,e1
#endif

struct v320usc_reg {
	usc_endian_def_s2(pci_device, pci_vendor);
	usc_endian_def_s2(pci_stat, pci_cmd);
	struct {
		usc_endian_def_b4(base_class, sub_class, prog_if, rev);
	} pci_cc_rev;
	struct {
		usc_endian_def_b4(bist, hdr_type, lt, line_size);
	} pci_hdr_cfg;
	volatile unsigned long pci_i2o_base;
	volatile unsigned long pci_mem_base;
	volatile unsigned long pci_reg_base;
	volatile unsigned long pci_pcu_base;
	volatile unsigned long reserved[2];
	volatile unsigned long pci_cis;
	usc_endian_def_s2(pci_sub_id, pci_sub_vendor);
	volatile unsigned long pci_rom_base;
	usc_endian_def_sb2(reserved2, reserved3, pci_capability);
	volatile unsigned long reserved4;
	struct {
		usc_endian_def_b4(max_lat, min_gnt, int_pin, int_line);
	} pci_bparam;
	usc_endian_def_sb2(pm_cap, pm_next_id, pm_cap_id);
	usc_endian_def_b2s(pm_data, reserved5, pm_csr);
	volatile unsigned long pm_pwr_on;
	volatile unsigned long pm_pwr_dis;
	volatile unsigned long pci_i2o_map;
	volatile unsigned long pci_mem_map;
	volatile unsigned long reserved6;
	volatile unsigned long pci_bus_cfg;
	volatile unsigned long lb_pci_base[2];
	volatile unsigned long reserved7;
	volatile unsigned long lb_pcu_base;
	usc_endian_def_b2s(system, reserved8, lb_reg_base);
	volatile unsigned long lb_rom_base;
	volatile unsigned long lb_dram_base;
	volatile unsigned long lb_bus_cfg;
	usc_endian_def_b4(reserved9, hs_csr, hs_next_id, hs_cap_id);
	usc_endian_def_b2s(t_cy, reserved10, lb_pci_ctl);
	usc_endian_def_s2(sdram_cmd, sdram_ma);
	volatile unsigned long dram_cfg;
	volatile unsigned long dram_blk[4];
	volatile unsigned long pcu_sub[3];
	volatile unsigned long reserved11;
	volatile unsigned long pcu_tc_wr[5];
	volatile unsigned long reserved12;
	volatile unsigned long pcu_tc_rd[5];
	volatile unsigned long reserved13;
	volatile unsigned long int_cfg[3];
	volatile unsigned long int_stat;
	volatile unsigned long ios;
	volatile unsigned long wd_hbi;
	usc_endian_def_sb2(reserved14, mail_rd_stat, mail_wr_stat);
	usc_endian_def_b4(lb_mail_ierd, lb_mail_iewr, pci_mail_ierd, pci_mail_iewr);
	volatile unsigned long mail_data[8];
	volatile unsigned long reserved15[8];
	volatile unsigned long timer_dat[2];
	volatile unsigned long reserved16[2];
	usc_endian_def_s2(timer_ctl1, timer_ctl0);
	volatile unsigned long reserved17;
	volatile unsigned long int_cfg3;
	volatile unsigned long reserved18;
	volatile unsigned long pci_i2o_istat;
	volatile unsigned long pci_i2o_imask;
	volatile unsigned long reserved19;
	usc_endian_def_sb2(reserved20, reserved21, dma_delay);
	volatile unsigned long dma_csr[2];
	volatile unsigned long reserved22[2];
	struct {
		volatile unsigned long xfer_ctl;
		volatile unsigned long src_adr;
		volatile unsigned long dst_adr;
		volatile unsigned long ctlb_adr;
	} dma[2];
};

#endif /* _LANGUAGE_ASSEMBLY */

/* bits for PCI_CMD */
/* see PCI_COMMAND_XXX in linux/pci.h */

/* bits for PCI_STAT */
/* see PCI_STATUS_XXX in linux/pci.h */
#define PCI_STATUS_NEW_CAP	0x0010

/* bits for PCI_I2O_BASE,PCI_MEM_BASE,PCI_REG_BASE,PCI_PCU_BASE */
/* see PCI_BASE_ADDRESS_XXX in linux/pci.h */

/* bits for PCI_REG_BASE */
#define PCI_REG_ADDRESS_ENABLE 0x40
#define PCI_REG_ADDRESS_REG_EN 0x80
#define PCI_REG_ADDRESS_MASK	(~0x1ffUL)

/* bits for PCI_PCU_BASE */
#define PCI_PCU_ADDRESS_MEM_SIZE_1M	0x00
#define PCI_PCU_ADDRESS_MEM_SIZE_2M	0x10
/* ... */
#define PCI_PCU_ADDRESS_MEM_SIZE_256M	0x80
#define PCI_PCU_ADDRESS_IO_SIZE_256B	0x30
#define PCI_PCU_ADDRESS_IO_SIZE_512B	0x40
/* ... */
#define PCI_PCU_ADDRESS_IO_SIZE_8K	0x80
#define PCI_PCU_ADDRESS_SIZE_DISABLED	0xf0
#define PCI_PCU_ADDRESS_SIZE_MASK	0xf0
#define PCI_PCU_ADDRESS_MASK		(~0xffUL)

/* bits for PCI_ROM_BASE */
#define PCI_ROM_ADDRESS_SIZE_DISABLED	0x00
#define PCI_ROM_ADDRESS_SIZE_64K	0x10
#define PCI_ROM_ADDRESS_SIZE_128K	0x20
#define PCI_ROM_ADDRESS_SIZE_256K	0x30
#define PCI_ROM_ADDRESS_SIZE_MASK	0x30
#define PCI_ROM_ADDRESS_MAP_MASK	0x0000ff00
#define PCI_ROM_ADDRESS_BASE_MASK	0xffff0000

/* swaptype */
#define USC_NOSWAP	0x00
#define USC_SWAP16	0x01
#define USC_SWAP8	0x02
#define USC_AUTOSWAP	0x03

/* bits for PCI_MEM_MAP */
#define USC_PCI_MEM_MAP_ENABLE		0x01
#define USC_PCI_MEM_MAP_REG_EN		0x02
#define USC_PCI_MEM_MAP_RD_POST_INH	0x08
#define USC_PCI_MEM_MAP_RD_POST_INH	0x08
#define USC_PCI_MEM_MAP_SIZE_MASK	0xf0
#define USC_PCI_MEM_MAP_SIZE_1M		0x00
#define USC_PCI_MEM_MAP_SIZE_2M		0x10
/* ... */
#define USC_PCI_MEM_MAP_SIZE_1G		0xa0
#define USC_PCI_MEM_MAP_SIZE(adbits)	\
	(USC_PCI_MEM_MAP_SIZE_1M + ((12 - (adbits)) * 0x10))
#define USC_PCI_MEM_MAP_SWAP_MASK	0x0300
#define USC_PCI_MEM_MAP_SWAP(swaptype)	((swaptype) << 8)
#define USC_PCI_MEM_MAP_PCI_RD_MB_MASK	0x00003000
#define USC_PCI_MEM_MAP_PCI_WR_MB_MASK	0x0000c000
#define USC_PCI_MEM_MAP_W_FLUSH		0x00010000
#define USC_PCI_MEM_MAP_MAP_ADR_MASK	0x3ff00000
#define USC_PCI_MEM_MAP_MAP_ADR(addr)	\
	((addr) & USC_PCI_MEM_MAP_MAP_ADR_MASK)

/* bits for PCI_BUS_CFG */
#define USC_PCI_BUS_CFG_CFG_RETRY	0x00000100
#define USC_PCI_BUS_CFG_PCI_INH		0x00000200
#define USC_PCI_BUS_CFG_I2O_ONLINE_MASK	0x00003000
#define USC_PCI_BUS_CFG_I2O_ONLINE_ENABLE	0x00003000
#define USC_PCI_BUS_CFG_I2O_ONLINE_DISABLE	0x00002000
#define USC_PCI_BUS_CFG_I2O_ONLINE_ENABLED	0x00000000
#define USC_PCI_BUS_CFG_I2O_ONLINE_DISABLED	0x00001000
#define USC_PCI_BUS_CFG_I2O_EN		0x00004000
#define USC_PCI_BUS_CFG_I2O_EN_EN	0x00008000
#define USC_PCI_BUS_CFG_RBRST_MAX_MASK	0x00030000
#define USC_PCI_BUS_CFG_RBRST_MAX_4	0x00000000
#define USC_PCI_BUS_CFG_RBRST_MAX_8	0x00010000
#define USC_PCI_BUS_CFG_RBRST_MAX_16	0x00020000
#define USC_PCI_BUS_CFG_RBRST_MAX_256	0x00030000
#define USC_PCI_BUS_CFG_TRDY_STOP	0x00200000
#define USC_PCI_BUS_CFG_PCU_SWAP_MASK	0x03000000
#define USC_PCI_BUS_CFG_PCU_SWAP(swaptype)	((swaptype) << 24)
#define USC_PCI_BUS_CFG_FAST_SCL	0x80000000

/* bits for LB_PCI_BASE */
#define USC_LB_PCI_BASE_ALOW_MASK	0x03
#define USC_LB_PCI_BASE_ERR_EN		0x04
#define USC_LB_PCI_BASE_PREFETCH	0x08
#define USC_LB_PCI_BASE_SIZE_MASK	0x70
#define USC_LB_PCI_BASE_SIZE_16M	0x10
#define USC_LB_PCI_BASE_SIZE_32M	0x20
/* ... */
#define USC_LB_PCI_BASE_SIZE_1G		0x70
#define USC_LB_PCI_BASE_SIZE(adbits)	\
	(USC_LB_PCI_BASE_SIZE_16M + ((8 - (adbits)) * 0x10))
#define USC_LB_PCI_BASE_SWAP_MASK	0x0300
#define USC_LB_PCI_BASE_SWAP(swaptype)	((swaptype) << 8)
#define USC_LB_PCI_BASE_COMBINE		0x0800
#define USC_LB_PCI_BASE_PCI_CMD_MASK	0xe000
#define USC_LB_PCI_BASE_PCI_CMD_SPECIAL	0x0000
#define USC_LB_PCI_BASE_PCI_CMD_IACK	0x0000
#define USC_LB_PCI_BASE_PCI_CMD_IO	0x2000
#define USC_LB_PCI_BASE_PCI_CMD_MEM	0x6000
#define USC_LB_PCI_BASE_PCI_CMD_CONFIG	0xa000
#define USC_LB_PCI_BASE_PCI_CMD_MEMMUL	0xc000
#define USC_LB_PCI_BASE_PCI_CMD_MEMINV	0xe000
#define USC_LB_PCI_BASE_MAP_ADR_MASK	0x00ff0000
#define USC_LB_PCI_BASE_MAP_ADR(addr)	\
	(((addr) >> 8) & USC_LB_PCI_BASE_MAP_ADR_MASK)
#define USC_LB_PCI_BASE_BASE_MASK	0xff000000
#define USC_LB_PCI_BASE_BASE(addr)	\
	((addr) & USC_LB_PCI_BASE_BASE_MASK)

/* bits for LB_PCU_BASE */
#define USC_LB_PCU_BASE_ENABLE	0x01
#define USC_LB_PCU_BASE_SIZE_MASK	0x70
#define USC_LB_PCU_BASE_SIZE_16M	0x00
#define USC_LB_PCU_BASE_SIZE_32M	0x10
/* ... */
#define USC_LB_PCU_BASE_SIZE_256M	0x40
#define USC_LB_PCU_BASE_SIZE(adbits)	\
	(USC_LB_PCU_BASE_SIZE_16M + ((8 - (adbits)) * 0x10))
#define USC_LB_PCU_BASE_BASE_MASK	0xff000000
#define USC_LB_PCU_BASE_BASE(addr)	\
	((addr) & USC_LB_PCU_BASE_BASE_MASK)

/* bits for LB_REG_BASE */
#define USC_LB_REG_BASE_MASK	0x0000ffff
#define USC_LB_REG_BASE_BASE(addr)	\
	(((addr) >> 16) & USC_LB_REG_BASE_MASK)

/* bits for LB_ROM_BASE */
#define USC_LB_ROM_BASE_SIZE_MASK	0x70
#define USC_LB_ROM_BASE_SIZE_16M	0x00
#define USC_LB_ROM_BASE_SIZE_32M	0x10
/* ... */
#define USC_LB_ROM_BASE_SIZE_512M	0x50
#define USC_LB_ROM_BASE_SIZE(adbits)	\
	(USC_LB_ROM_BASE_SIZE_16M + ((8 - (adbits)) * 0x10))
#define USC_LB_ROM_BASE_WE		0x00000100
#define USC_LB_ROM_BASE_BASE_MASK	0xff000000
#define USC_LB_ROM_BASE_BASE(addr)	\
	((addr) & USC_LB_ROM_BASE_BASE_MASK)

/* bits for LB_DRAM_BASE */
#define USC_LB_DRAM_BASE_ENABLE		0x01
#define USC_LB_DRAM_BASE_SIZE_MASK	0xf0
#define USC_LB_DRAM_BASE_SIZE_64M	0x00
#define USC_LB_DRAM_BASE_SIZE_128M	0x10
#define USC_LB_DRAM_BASE_SIZE_1G	0x40
#define USC_LB_DRAM_BASE_SIZE(adbits)	\
	(USC_LB_DRAM_BASE_SIZE_64M + ((6 - (adbits)) * 0x10))
#define USC_LB_DRAM_BASE_BASE_MASK	0xfc000000
#define USC_LB_DRAM_BASE_BASE(addr)	\
	((addr) & USC_LB_DRAM_BASE_BASE_MASK)

/* bits for LB_BUS_CFG */
#define USC_LB_BUS_CFG_ERR_EN		0x00000001
#define USC_LB_BUS_CFG_MERR_EN		0x00000002
#define USC_LB_BUS_CFG_POE		0x00000004
#define USC_LB_BUS_CFG_CHK_DIS		0x00000008
#define USC_LB_BUS_CFG_CHK_DIS		0x00000008
#define USC_LB_BUS_CFG_BW_TC_MASK	0x00000ff0
#define USC_LB_BUS_CFG_ENDIAN		0x00010000
#define USC_LB_BUS_CFG_FAST_WRRDY	0x00080000
#define USC_LB_BUS_CFG_SYNC_RDY		0x00200000
#define USC_LB_BUS_CFG_RAM_DIS		0x00800000
#define USC_LB_BUS_CFG_BUS_REQ_MASK	0x03000000
#define USC_LB_BUS_CFG_GRANT		0x04000000
#define USC_LB_BUS_CFG_MB_LT_MASK	0xf0000000

/* bits for SYSTEM */
#define USC_SYSTEM_SPROM_EN	0x01
#define USC_SYSTEM_SDA_IN	0x02
#define USC_SYSTEM_SDA_OUT	0x04
#define USC_SYSTEM_SCL		0x08
#define USC_SYSTEM_LOO_EN	0x10
#define USC_SYSTEM_CFG_LOCK	0x20
#define USC_SYSTEM_LOCK		0x40
#define USC_SYSTEM_RST_OUT	0x80
#define USC_SYSTEM_UNLOCK_VALUE	0xa5	/* special value to unlock */

/* bits for INT_CFG,INT_STAT */
#define USC_INTB_INT0	8
#define USC_INTB_INT1	9
#define USC_INTB_INT2	10
#define USC_INTB_INT3	11
#define USC_INTB_TIMER0	12
#define USC_INTB_TIMER1	13
#define USC_INTB_ENUM	15
#define USC_INTB_DMA0	16
#define USC_INTB_DMA1	17
#define USC_INTB_HBI	21
#define USC_INTB_WDI	22
#define USC_INTB_BWI	23
#define USC_INTB_PSLAVE_PI	24
#define USC_INTB_PMASTER_PI	25
#define USC_INTB_PCI_T_ABORT	26
#define USC_INTB_PCI_M_ABORT	27
#define USC_INTB_DRAM_PI	28
#define USC_INTB_DI_EN	29
#define USC_INTB_DI0	30
#define USC_INTB_DI1	31
#define USC_INTF_INT0	(1 << USC_INTB_INT0)
#define USC_INTF_INT1	(1 << USC_INTB_INT1)
#define USC_INTF_INT2	(1 << USC_INTB_INT2)
#define USC_INTF_INT3	(1 << USC_INTB_INT3)
#define USC_INTF_TIMER0	(1 << USC_INTB_TIMER0)
#define USC_INTF_TIMER1	(1 << USC_INTB_TIMER1)
#define USC_INTF_ENUM	(1 << USC_INTB_ENUM)
#define USC_INTF_DMA0	(1 << USC_INTB_DMA0)
#define USC_INTF_DMA1	(1 << USC_INTB_DMA1)
#define USC_INTF_HBI	(1 << USC_INTB_HBI)
#define USC_INTF_WDI	(1 << USC_INTB_WDI)
#define USC_INTF_BWI	(1 << USC_INTB_BWI)
#define USC_INTF_PSLAVE_PI	(1 << USC_INTB_PSLAVE_PI)
#define USC_INTF_PMASTER_PI	(1 << USC_INTB_PMASTER_PI)
#define USC_INTF_PCI_T_ABORT	(1 << USC_INTB_PCI_T_ABORT)
#define USC_INTF_PCI_M_ABORT	(1 << USC_INTB_PCI_M_ABORT)
#define USC_INTF_DRAM_PI	(1 << USC_INTB_DRAM_PI)
#define USC_INTF_DI_EN	(1 << USC_INTB_DI_EN)
#define USC_INTF_DI0	(1 << USC_INTB_DI0)
#define USC_INTF_DI1	(1 << USC_INTB_DI1)

/* bits for WD_HBI */
#define USC_WD_TC_MASK		0x0000ff
#define USC_WD_TC_SHIFT		0
#define USC_HB_TC_MASK		0x03ff00
#define USC_HB_TC_SHIFT		8
#define USC_WD_HBI_TEST		0x080000
#define USC_WD_HBI_WD_INIT	0x100000
#define USC_WD_HBI_PRESCALE	0x200000
#define USC_WD_HBI_WD_EN	0x800000

#endif /* __ASM_V320USC_H */
