/*
 *  linux/include/linux/ext2_fs_i.h
 *
 * Copyright (C) 1992, 1993, 1994, 1995
 * Remy Card (card@masi.ibp.fr)
 * Laboratoire MASI - Institut Blaise Pascal
 * Universite Pierre et Marie Curie (Paris VI)
 *
 *  from
 *
 *  linux/include/linux/minix_fs_i.h
 *
 *  Copyright (C) 1991, 1992  Linus Torvalds
 */

/*
 *  Copyright (C) 2001 Alcatel Business Systems - R&D Illkirch
 *  Added by Pierre Peiffer (pierre.peiffer@sxb.bsf.alcatel.fr) (2001-08-09)
 *  (Copied from pjm e2compr-0.4.39-patch-2.2.18 patch)
 *      e2compress stuff.
 */

#ifndef _LINUX_EXT2_FS_I
#define _LINUX_EXT2_FS_I

#include <linux/config.h>  /* CONFIG_EXT2_COMPRESS */

/*
 * second extended file system inode data in memory
 */
struct ext2_inode_info {
	__u32	i_data[15];
	__u32	i_flags;
	__u32	i_faddr;
	__u8	i_frag_no;
	__u8	i_frag_size;
	__u16	i_osync;
	__u32	i_file_acl;
	__u32	i_dir_acl;
	__u32	i_dtime;
	__u32	i_block_group;
	__u32	i_next_alloc_block;
	__u32	i_next_alloc_goal;
	__u32	i_prealloc_block;
	__u32	i_prealloc_count;
	__u32	i_dir_start_lookup;
	int	i_new_inode:1;	/* Is a freshly allocated inode */
#ifdef CONFIG_EXT2_COMPRESS
	__u8    i_log2_clu_nblocks;
	__u8    i_clu_nblocks;
	__u8    i_compr_method;
	__u8    i_compr_flags;
#endif
};

#endif	/* _LINUX_EXT2_FS_I */
