#include <time.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

/*Added by louistsai 2002/10/22, for adding log function*/
#include "libconf.h"
/*end*/

#include "debug.h"
#include "dhcpd.h"
#include "options.h"
#include "leases.h"
#include "arpping.h"

#ifndef HOST_TEST
#include "setting.h"
#endif

#ifndef HOST_TEST


void get_lease_time(u_int32_t *lease_time, u_int32_t *min_lease_time)
{
	REG_DHCP_CONF	dhcpconf;
	
	read_config(MC_DHCP_CONFIG, &dhcpconf);
	*lease_time = dhcpconf.lease_time * 60;
#if 0
	*min_lease_time = dhcpconf.min_lease_time * 60;
#else
	*min_lease_time = *lease_time;
#endif
}

int get_router(u_int32_t req_ip, u_int32_t *router_ip, u_int32_t *netmask)
{
	REG_NET_CONF		netconf;
	REG_IPALIAS_CONF	aliasconf;
	
	*router_ip = *netmask = 0;

	read_config(MC_NET_CONFIG, &netconf);
	if ( (netconf.private_ip & netconf.private_netmask) == (req_ip & netconf.private_netmask) ) {
		*router_ip = netconf.private_ip;
		*netmask = netconf.private_netmask;
		return 1;
	}

	read_config(MC_IPALIAS_CONFIG, &aliasconf);
	if ( aliasconf.alias_ip0 != 0 ) {
		if ( (aliasconf.alias_ip0 & aliasconf.alias_netmask0) == (req_ip & aliasconf.alias_netmask0) ) {
			*router_ip = aliasconf.alias_ip0;
			*netmask = aliasconf.alias_netmask0;
			return 1;
		}
	}

	if ( aliasconf.alias_ip1 != 0 ) {
		if ( (aliasconf.alias_ip1 & aliasconf.alias_netmask1) == (req_ip & aliasconf.alias_netmask1) ) {
			*router_ip = aliasconf.alias_ip1;
			*netmask = aliasconf.alias_netmask1;
			return 1;
		}
	}

	if ( aliasconf.alias_ip2 != 0 ) {
		if ( (aliasconf.alias_ip2 & aliasconf.alias_netmask2) == (req_ip & aliasconf.alias_netmask2) ) {
			*router_ip = aliasconf.alias_ip2;
			*netmask = aliasconf.alias_netmask2;
			return 1;
		}
	}

	return 0;
}

static int valid_req_ip(u_int32_t req_ip)
{
	u_int32_t	dummy1, dummy2;

	return get_router(req_ip, &dummy1, &dummy2);
}

int ip_in_lease_range(u_int32_t req_ip)
{
	REG_DHCP_CONF	dhcpconf;

	/* check if the request ip is valid */
	if ( !valid_req_ip(req_ip) )
		return 0;

	read_config(MC_DHCP_CONFIG, &dhcpconf);

	if ( dhcpconf.range_start0 != 0 && dhcpconf.range_end0 != 0 &&
		dhcpconf.range_start0 <= req_ip && dhcpconf.range_end0 >= req_ip )
		return 1;
	
	if ( dhcpconf.range_start1 != 0 && dhcpconf.range_end1 != 0 &&
		dhcpconf.range_start1 <= req_ip && dhcpconf.range_end1 >= req_ip )
		return 1;
	
	if ( dhcpconf.range_start2 != 0 && dhcpconf.range_end2 != 0 &&
		dhcpconf.range_start2 <= req_ip && dhcpconf.range_end2 >= req_ip )
		return 1;
	
	if ( dhcpconf.range_start3 != 0 && dhcpconf.range_end3 != 0 &&
		dhcpconf.range_start3 <= req_ip && dhcpconf.range_end3 >= req_ip )
		return 1;
	
	return 0;
}
#endif

#ifdef HOST_TEST
/* clear every lease out that chaddr OR yiaddr matches and is nonzero */
void clear_lease(u_int8_t *chaddr, u_int32_t yiaddr)
{
	unsigned int i, j;
	
	for (j = 0; j < 16 && !chaddr[j]; j++);
	
	for (i = 0; i < server_config.max_leases; i++)
		if ((j != 16 && !memcmp(leases[i].chaddr, chaddr, 16)) ||
		    (!yiaddr && leases[i].yiaddr == yiaddr)) {
			memset(&(leases[i]), 0, sizeof(DHCP_OFFERED_ADDR));
		}
}
#endif


/* add a lease into the table, clearing out any old ones */
int add_lease(char *client_host, u_int8_t *chaddr, u_int32_t yiaddr, unsigned long lease)
{
#ifdef HOST_TEST
	DHCP_OFFERED_ADDR *oldest;
	
	/* clean out any old ones */
	clear_lease(chaddr, yiaddr);
		
	oldest = oldest_expired_lease();
	
	if (oldest) {
		memcpy(oldest->chaddr, chaddr, 16);
		oldest->yiaddr = yiaddr;
		oldest->expires = time(0) + lease;
		return 1;
	}
	
	return 0;
#else
	DHCP_OFFERED_ADDR slot;

	strcpy(slot.hostname, (client_host == NULL) ? "" : client_host);
	memcpy(slot.chaddr, chaddr, 6);
	slot.yiaddr = yiaddr;
	slot.expires = time(0) + lease;
	return !write_config(MC_DHCP_ADD_LEASE, &slot);	/* 1 success; 0 failure */
#endif
}


/* true if a lease has expired */
int lease_expired(DHCP_OFFERED_ADDR *lease)
{
	return (lease->expires < (unsigned long) time(0));
}	


#ifdef HOST_TEST
/* Find the oldest expired lease, NULL if there are no expired leases */
DHCP_OFFERED_ADDR *oldest_expired_lease(void)
{
	DHCP_OFFERED_ADDR *oldest = NULL;
	unsigned long oldest_lease = time(0);
	unsigned int i;

	
	for (i = 0; i < server_config.max_leases; i++)
		if (oldest_lease > leases[i].expires) {
			oldest_lease = leases[i].expires;
			oldest = &(leases[i]);
		}
	return oldest;
		
}
#endif


/* Find the first lease that matches chaddr, NULL if no match */
#ifdef HOST_TEST
DHCP_OFFERED_ADDR *find_lease_by_chaddr(u_int8_t *chaddr)
{
	unsigned int i;

	for (i = 0; i < server_config.max_leases; i++)
		if (!memcmp(leases[i].chaddr, chaddr, 16)) return &(leases[i]);
	
	return NULL;
}

/* Find the first lease that matches yiaddr, NULL is no match */
DHCP_OFFERED_ADDR *find_lease_by_yiaddr(u_int32_t yiaddr)
{
	unsigned int i;

	for (i = 0; i < server_config.max_leases; i++)
		if (leases[i].yiaddr == yiaddr) return &(leases[i]);
	
	return NULL;
}

#else
int find_lease_by_chaddr(u_int8_t *chaddr, DHCP_OFFERED_ADDR *lease)
{
	int	retval;

	memcpy(lease->chaddr, chaddr, 6);
	retval = read_config(MC_DHCP_FIND_LEASE_BY_CHADDR, lease);
	if ( !retval && valid_req_ip(lease->yiaddr) )
		return 1;

	return 0;
}

int find_lease_by_yiaddr(u_int32_t yiaddr, DHCP_OFFERED_ADDR *lease)
{
	int	retval;

	lease->yiaddr = yiaddr;
	retval = read_config(MC_DHCP_FIND_LEASE_BY_YIADDR, lease);
	if ( !retval && valid_req_ip(lease->yiaddr) )
		return 1;

	return 0;
}
#endif


/* 4 IP address range can be used */
static u_int32_t find_address_by_range(u_int32_t start, u_int32_t end, int check_expired)
{
	u_int32_t addr, ret;
#ifdef HOST_TEST
	DHCP_OFFERED_ADDR *lease = NULL;		
#else
	DHCP_OFFERED_ADDR lease;
#endif

	printf("start addr = %u.%u.%u.%u\n", start & 0xff, (start>>8) & 0xff, (start>>16) & 0xff, (start>>24) & 0xff);
	addr = ntohl(start); /* addr is in host order here */
	for (;addr < ntohl(end); addr++) {

		/* ie, 192.168.55.0 */
		if (!(addr & 0xFF)) continue;

		/* ie, 192.168.55.255 */
		if ((addr & 0xFF) == 0xFF) continue;

		/* lease is not taken */
		ret = htonl(addr);
#ifdef HOST_TEST
		if ((!(lease = find_lease_by_yiaddr(ret)) ||

		     /* or it expired and we are checking for expired leases */
		     (check_expired  && lease_expired(lease))) &&

		     /* and it isn't on the network */
	    	     !check_ip(ret)) {
			return ret;
			break;
		}
#else
		if ( (!find_lease_by_yiaddr(ret, &lease) || (check_expired && lease_expired(&lease))) &&
			!check_ip(ret) ) {
			return ret;
			break;
		}
#endif
	}
	return 0;
}


/* find an assignable address, it check_expired is true, we check all the expired leases as well.
 * Maybe this should try expired leases by age... */
u_int32_t find_address(int check_expired) 
{
#ifdef HOST_TEST
	return find_address_by_range(server_config.start, server_config.end, check_expired);
#else
	u_int32_t	addr;
	REG_DHCP_CONF	dhcpconf;
	
	read_config(MC_DHCP_CONFIG, &dhcpconf);
	if ( dhcpconf.range_start0 != 0 ) {
		addr = find_address_by_range(dhcpconf.range_start0, dhcpconf.range_end0, check_expired);
		if ( addr ) return addr;
	}

	if ( dhcpconf.range_start1 != 0 ) {
		addr = find_address_by_range(dhcpconf.range_start1, dhcpconf.range_end1, check_expired);
		if ( addr ) return addr;
	}

	if ( dhcpconf.range_start2 != 0 ) {
		addr = find_address_by_range(dhcpconf.range_start2, dhcpconf.range_end2, check_expired);
		if ( addr ) return addr;
	}

	if ( dhcpconf.range_start3 != 0 ) {
		addr = find_address_by_range(dhcpconf.range_start3, dhcpconf.range_end3, check_expired);
		if ( addr ) return addr;
	}

	return 0;
#endif
}

/* check is an IP is taken, if it is, add it to the lease table */
int check_ip(u_int32_t addr)
{
	unsigned char blank_chaddr[] = {[0 ... 15] = 0};
	struct in_addr temp;
	EVENTLOG_ENTRY	log;
	
	if(!check_pptp_ip_range(addr)) return 1;
	if (arpping(addr, server_config.server, server_config.arp, server_config.interface) == 0) {
		temp.s_addr = addr;
		/*
		log.msgid = IDS_DHCP_COLLISION;
		log.level = LEVEL_WARNING;
		log.collision_ip = addr;
		write_config(MC_EVENTLOG_ADD, &log);
		
		*/
		Add_Logs(LEVEL_WARNING, IDS_DHCP_COLLISION, (void *)&addr);
		
	 	LOG(LOG_INFO, "%s belongs to someone, reserving it for %ld seconds", 
	 		inet_ntoa(temp), server_config.conflict_time);
		add_lease("", blank_chaddr, addr, server_config.conflict_time);
		return 1;
	} else return 0;
}

