/* leases.h */
#ifndef _LEASES_H
#define _LEASES_H

#ifdef HOST_TEST
typedef struct {
	u_int8_t chaddr[16];
	u_int32_t yiaddr;	/* network order */
	u_int32_t expires;	/* host order */
} DHCP_OFFERED_ADDR;

void clear_lease(u_int8_t *chaddr, u_int32_t yiaddr);
DHCP_OFFERED_ADDR *oldest_expired_lease(void);
DHCP_OFFERED_ADDR *find_lease_by_chaddr(u_int8_t *chaddr);
DHCP_OFFERED_ADDR *find_lease_by_yiaddr(u_int32_t yiaddr);
#else
#include <asm/mconfig.h>
void get_lease_time(u_int32_t *lease_time, u_int32_t *min_lease_time);
int get_router(u_int32_t req_ip, u_int32_t *router, u_int32_t *netmask);
int ip_in_lease_range(u_int32_t req_ip);
int find_lease_by_chaddr(u_int8_t *chaddr, DHCP_OFFERED_ADDR *lease);
int find_lease_by_yiaddr(u_int32_t yiaddr, DHCP_OFFERED_ADDR *lease);
#endif

int lease_expired(DHCP_OFFERED_ADDR *lease);
int add_lease(char *client_host, u_int8_t *chaddr, u_int32_t yiaddr, unsigned long lease);
u_int32_t find_address(int check_expired);
int check_ip(u_int32_t addr);
int check_pptp_ip_range(u_int32_t req_ip);
#endif
