#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <asm/mconfig.h>


int mct_e2fsck_update_status(int status)
{
	int shmid;
	MCT_HD_PROGRESS *share_stuff;
	void *shared_memory = (void*) 0;
			
	shmid 		= shmget((key_t)MCT_E2FSCK_SHMID, sizeof(MCT_HD_PROGRESS) , 0666 | IPC_CREAT);	
	shared_memory 	= shmat(shmid, (void *)0, 0);
    	if (shared_memory == (void *)-1) {
        	fprintf(stderr, "shmat failed\n");
        	return -1;
        }
	share_stuff		= (MCT_HD_PROGRESS *) shared_memory;
	
	share_stuff->status	= status;
	
	if(status == MCT_E2FSCK_COMPLETE)
		share_stuff->percent 	= 100 ;
	else
		share_stuff->percent 	= -1 ;
	
	shmdt(shared_memory);
	
	
}
int mct_e2fsck_update_percentage(int percent)
{
	int shmid;
	MCT_HD_PROGRESS *share_stuff;
	void *shared_memory = (void*) 0;
			
	shmid 		= shmget((key_t)MCT_E2FSCK_SHMID, sizeof(MCT_HD_PROGRESS) , 0666 | IPC_CREAT);	
	shared_memory 	= shmat(shmid, (void *)0, 0);
    	if (shared_memory == (void *)-1) {
        	fprintf(stderr, "shmat failed\n");
        	return -1;
        }
	share_stuff		= (MCT_HD_PROGRESS *) shared_memory;
	share_stuff->status	= MCT_E2FSCK_SCANNING;
	share_stuff->percent 	= percent ;
	shmdt(shared_memory);
}