# FreeS/WAN pathnames and other master configuration
# Copyright (C) 2001  Henry Spencer.
# 
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2 of the License, or (at your
# option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
# 
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
# RCSID $Id: Makefile.inc,v 1.1.1.1 2004/04/07 09:05:58 louistsai Exp $



# Variables in this file with names starting with INC_ are not for use
# by Makefiles which include it; they are subject to change without warning.
#
# "Final" and "finally" refer to where the files will end up on the
# running IPsec system, as opposed to where they get installed by our
# Makefiles.  (The two are different for cross-compiles and the like,
# where our Makefiles are not the end of the installation process.)
# Paths with FINAL in their names are the only ones that the installed
# software itself depends on.
# See also the discussion of DESTDIR below.



### boilerplate, do not change
SHELL=/bin/sh


ARCH = mips

### install pathnames

# DESTDIR can be used to supply a prefix to all pathnames used in install.
# Note that "final" pathnames, signifying where files will eventually
# reside rather than where install puts them, are exempt from this.
#DESTDIR=/home/toshiba/initrd/stage
DESTDIR=$(MOUNTPT)

# PUBDIR is where the "ipsec" command goes; beware, many things define PATH
# settings which are assumed to include it (or at least, to include *some*
# copy of the "ipsec" command).
PUBDIR=$(DESTDIR)/usr/local/sbin

# BINDIR is where commands get put, FINALBINDIR is where the "ipsec"
# command will look for them when it is run.
FINALBINDIR=/usr/local/lib/ipsec
BINDIR=$(DESTDIR)$(FINALBINDIR)

# where the appropriate manpage tree is located
MANTREE=$(DESTDIR)/usr/local/man
# all relevant subdirectories of MANTREE
MANPLACES=man3 man5 man8

# where configuration files go
CONFDIR=$(DESTDIR)/etc

# An attempt is made to automatically figure out where boot/shutdown scripts 
# will finally go:  the first directory in INC_RCDIRS which exists gets them.
# If none of those exists (or INC_RCDIRS is empty), INC_RCDEFAULT gets them.
# With a non-null DESTDIR, INC_RCDEFAULT will be used unless one of the
# INC_RCDIRS directories has been pre-created under DESTDIR.
INC_RCDIRS=/etc/rc.d/init.d /etc/rc.d /etc/init.d /sbin/init.d
INC_RCDEFAULT=/etc/rc.d/init.d

# RCDIR is where boot/shutdown scripts go; FINALRCDIR is where they think
# will finally be (so utils/Makefile can create a symlink in BINDIR to the
# place where the boot/shutdown script will finally be, rather than the
# place where it is installed).
FINALRCDIR=$(shell for d in $(INC_RCDIRS) ; \
		do if test -d $(DESTDIR)/$$d ; \
		then echo $$d ; exit 0 ; \
		fi ; done ; echo $(INC_RCDEFAULT) )
RCDIR=$(DESTDIR)$(FINALRCDIR)



### kernel pathnames

# Kernel location:  where patches are inserted, where kernel builds are done.
KERNELSRC=../../patch/linux-tx2vpn

# things whose existence indicates what kernel version we have
DIRIN22=$(KERNELSRC)/net/netlink
FILIN24=$(KERNELSRC)/net/khttpd/main.c

# where kernel configuration outputs are located
KCFILE=$(KERNELSRC)/.config
VERFILE=$(KERNELSRC)/include/linux/version.h



### misc installation stuff

# what program to use when installing things
INSTALL=install

# flags to the install program, for programs, manpages, and config files
# -b has install make backups (n.b., unlinks original), --suffix controls
# how backup names are composed.
# Note that the install procedures will never overwrite an existing config
# file, which is why -b is not specified for them.
#INSTBINFLAGS=-b --suffix=.old
INSTBINFLAGS=
INSTMANFLAGS=
INSTCONFFLAGS=



### misc configuration, included here in hopes that other files will not
### have to be changed for common customizations.

# extra options for use in kernel build
KERNMAKEOPTS=

# kernel Makefile targets to be done before build
# Can be overridden if you are *sure* your kernel doesn't need them.  (2.2.xx
# and later reportedly do not.)
KERNDEP=dep
KERNCLEAN=clean

# kernel make name:  zImage for 2.0.xx, bzImage for 2.2.xx and later, and
# boot on non-x86s (what ever happened to standards?)
INC_B=$(shell test -d $(DIRIN22) && echo b)
KERNEL=$(shell if expr " `uname -m`" : ' i.86' >/dev/null ; \
	then echo $(INC_B)zImage ; \
	else echo boot ; \
	fi)

# temporary directory to be used when building RPMs
RPMTMPDIR=/var/tmp/freeswan-tmp
