//
// MCT Corp.
// History:
// 	2004/01/16	Matthew		First Create
#include "libconf.h"
#include <assert.h>

void generateCheckSum(unsigned char *pData, int size, unsigned char *pCheckSum)
{
	int i = 0;
	for(i=0; i<size; i++)	{
		*pCheckSum ^= pData[i];
	}
}

void exportSystemData(FILE *pFile)
{
	assert(pFile != NULL);
	unsigned char checkSum = 0x00;

        GENCONF_BLOCK gb;
        memset(&gb, 0x00, sizeof(GENCONF_BLOCK)/sizeof(char));
        Config_Read(MC_NET_CONFIG, &gb);
        fwrite(&gb, sizeof(char), sizeof(GENCONF_BLOCK)/sizeof(char), pFile);
        generateCheckSum((unsigned char*)&gb, sizeof(GENCONF_BLOCK)/sizeof(char), &checkSum);

        // useraccount_block
	USERACCOUNT_BLOCK uab;
	memset(&uab, 0x00, sizeof(USERACCOUNT_BLOCK)/sizeof(char));
	Config_Read(MC_USER_CONFIG, &uab);
	fwrite(&uab, sizeof(char), sizeof(USERACCOUNT_BLOCK)/sizeof(char), pFile);
	generateCheckSum((unsigned char*)&uab, sizeof(USERACCOUNT_BLOCK)/sizeof(char), &checkSum);

        // write check sum to the tail of block
        fwrite(&checkSum, sizeof(unsigned char), 1, pFile);
}

void importSystemData(FILE *pFile)
{
	assert(pFile != NULL);
        unsigned char checkSum = 0x00;

	// GENCONF block
        GENCONF_BLOCK gb;
        memset(&gb, 0x00, sizeof(GENCONF_BLOCK)/sizeof(char));
        fread(&gb, sizeof(char), sizeof(GENCONF_BLOCK)/sizeof(char), pFile);
        generateCheckSum((unsigned char*)&gb, sizeof(GENCONF_BLOCK)/sizeof(char), &checkSum);

        // user config
        USERACCOUNT_BLOCK uab;
        memset(&uab, 0x00, sizeof(USERACCOUNT_BLOCK)/sizeof(char));
        fread(&uab, sizeof(char), sizeof(USERACCOUNT_BLOCK)/sizeof(char), pFile);
        generateCheckSum((unsigned char*)&uab, sizeof(USERACCOUNT_BLOCK)/sizeof(char), &checkSum);

        // read check sum from file
        unsigned char readCheckSum = 0x00;
        fread(&readCheckSum, sizeof(unsigned char), 1, pFile);
        if(readCheckSum == checkSum)    {
		Config_Write(MC_NET_CONFIG, &gb);
	        Config_Write(MC_USER_CONFIG, &uab);
	}
}

void exportUserData(FILE *pFile)
{
	assert(pFile != NULL);
	unsigned char checkSum = 0x00;
	
	// USERSHARE_BLOCK
        USERS users;
        memset(&users, 0x00, sizeof(USERS)/sizeof(char));
        Config_Read(MC_USER, &users);
        fwrite(&users, sizeof(char), sizeof(USERS)/sizeof(char), pFile);
        generateCheckSum((unsigned char*)&users, sizeof(USERS)/sizeof(char), &checkSum);

        GROUPS groups;
        memset(&groups, 0x00, sizeof(GROUPS)/sizeof(char));
	Config_Read(MC_GROUP, &groups);
        fwrite(&groups, sizeof(char), sizeof(GROUPS)/sizeof(char), pFile);
	generateCheckSum((unsigned char*)&groups, sizeof(GROUPS)/sizeof(char), &checkSum);

        SHARES shares;
        memset(&shares, 0x00, sizeof(SHARES)/sizeof(char));
	Config_Read(MC_SHARE, &shares);
        fwrite(&shares, sizeof(char), sizeof(SHARES)/sizeof(char), pFile);
	generateCheckSum((unsigned char*)&shares, sizeof(SHARES)/sizeof(char), &checkSum);

	// write check sum to the tail of block
	fwrite(&checkSum, sizeof(unsigned char), 1, pFile);
}

void importUserData(FILE *pFile)
{
	assert(pFile != NULL);
	unsigned char checkSum = 0x00;

	USERS users;
	memset(&users, 0x00, sizeof(USERS)/sizeof(char));
	fread(&users, sizeof(char), sizeof(USERS)/sizeof(char), pFile);
	generateCheckSum((unsigned char*)&users, sizeof(USERS)/sizeof(char), &checkSum);

	GROUPS groups;
	memset(&groups, 0x00, sizeof(GROUPS)/sizeof(char));
	fread(&groups, sizeof(char), sizeof(GROUPS)/sizeof(char), pFile);
	generateCheckSum((unsigned char*)&groups, sizeof(GROUPS)/sizeof(char), &checkSum);

	SHARES shares;
        memset(&shares, 0x00, sizeof(SHARES)/sizeof(SHARES));
        fread(&shares, sizeof(char), sizeof(SHARES)/sizeof(char), pFile);
	generateCheckSum((unsigned char*)&shares, sizeof(SHARES)/sizeof(char), &checkSum);

        // read check sum from file
	unsigned char readCheckSum = 0x00;
	fread(&readCheckSum, sizeof(unsigned char), 1, pFile);
	if(readCheckSum == checkSum)    {
		Config_Write(MC_USER, &users);
	        Config_Write(MC_GROUP, &groups);
	        Config_Write(MC_SHARE, &shares);
	}
}

void exportExtSystemData(FILE *pFile)
{
	assert(pFile != NULL);
	unsigned char checkSum = 0x00;

	// ext_conf_block
        REG_NFS_CONF nfsConfig;
	memset(&nfsConfig, 0x00, sizeof(REG_NFS_CONF));
	Config_Read(MC_NFS_CONFIG, &nfsConfig);
	fwrite(&nfsConfig, sizeof(char), sizeof(REG_NFS_CONF)/sizeof(char), pFile);
	generateCheckSum((unsigned char*)&nfsConfig, sizeof(REG_NFS_CONF)/sizeof(char), &checkSum);

        REG_MAIL_CONF mailConfig;
        memset(&mailConfig, 0x00, sizeof(REG_MAIL_CONF)/sizeof(char));
        Config_Read(MC_MAIL_CONFIG, &mailConfig);
        fwrite(&mailConfig, sizeof(char), sizeof(REG_MAIL_CONF)/sizeof(char), pFile);
        generateCheckSum((unsigned char*)&mailConfig, sizeof(REG_MAIL_CONF)/sizeof(char), &checkSum);

        REG_W3S_CONF w3sConfig;
        memset(&w3sConfig, 0x00, sizeof(REG_W3S_CONF)/sizeof(char));
        Config_Read(MC_W3S_CONFIG, &w3sConfig);
        fwrite(&w3sConfig, sizeof(char), sizeof(REG_W3S_CONF)/sizeof(char), pFile);
        generateCheckSum((unsigned char*)&w3sConfig, sizeof(REG_W3S_CONF)/sizeof(char), &checkSum);

        // write check sum to the tail of block
        fwrite(&checkSum, sizeof(unsigned char), 1, pFile);
}

void importExtSystemData(FILE *pFile)
{
	assert(pFile != NULL);
	unsigned char checkSum = 0x00;

        // ext_conf_block
	REG_NFS_CONF nfsConfig;
	memset(&nfsConfig, 0x00, sizeof(REG_NFS_CONF)/sizeof(char));
	fread(&nfsConfig, sizeof(char), sizeof(REG_NFS_CONF)/sizeof(char), pFile);
	generateCheckSum((unsigned char*)&nfsConfig, sizeof(REG_NFS_CONF)/sizeof(char), &checkSum);

        REG_MAIL_CONF mailConfig;
	memset(&mailConfig, 0x00, sizeof(REG_MAIL_CONF)/sizeof(char));
	fread(&mailConfig, sizeof(char), sizeof(REG_MAIL_CONF)/sizeof(char), pFile);
	generateCheckSum((unsigned char*)&mailConfig, sizeof(REG_MAIL_CONF)/sizeof(char), &checkSum);

	REG_W3S_CONF w3sConfig;
        memset(&w3sConfig, 0x00, sizeof(REG_W3S_CONF)/sizeof(char));
        fread(&w3sConfig, sizeof(char), sizeof(REG_W3S_CONF)/sizeof(char), pFile);
        generateCheckSum((unsigned char*)&w3sConfig, sizeof(REG_W3S_CONF)/sizeof(char), &checkSum);

        // read check sum from file
	unsigned char readCheckSum = 0x00;
	fread(&readCheckSum, sizeof(unsigned char), 1, pFile);
        if(readCheckSum == checkSum)    {
		Config_Write(MC_NFS_CONFIG, &nfsConfig);
	        Config_Write(MC_MAIL_CONFIG, &mailConfig);
	        Config_Write(MC_W3S_CONFIG, &w3sConfig);
	}
}

int exportAllConfig(char *pFileName)
{
	assert(pFileName != NULL);

	int ret = SUCCESS;

	FILE *pFile = NULL;
	if((pFile = fopen(pFileName, "w+b")) == NULL)	{
		ret = ERR_FILE_NOT_FOUND;
		goto labelFinish;
	}
	
	// write magic number
	unsigned char magicNumber = CONFIG_IO_MAGIC_NUMBER;
	fwrite(&magicNumber, 1, 1, pFile);
	exportSystemData(pFile);
	exportExtSystemData(pFile);
	exportUserData(pFile);
labelFinish:
	if(pFile != NULL)
		fclose(pFile);

	return(ret);
}

int importAllConfig(char *pFileName)
{
	assert(pFileName != NULL);

	int ret = SUCCESS;
	FILE *pFile = NULL;
	if((pFile = fopen(pFileName, "r+b")) == NULL)	{
		ret = ERR_FILE_NOT_FOUND;
		goto labelFinish;
	}

	// read magic number
	unsigned char magicNumber = 0x00;
	fread(&magicNumber, 1, 1, pFile);
	if(magicNumber != CONFIG_IO_MAGIC_NUMBER)	{
		ret = ERR_INVALID_MAGIC_NUMBER;
		goto labelFinish;
	}

	importSystemData(pFile);
	importExtSystemData(pFile);
	importUserData(pFile);
labelFinish:
	if(pFile != NULL)
		fclose(pFile);

	return(ret);
}
