/********************************************************************************
*
*	Copyright (c) 2002  Magic Control Technology Co.  All Rights Reserved.
*
*	FILE:
*		hd_ctl.h
*
*	Abstract:
*		header file for hd management function
*		
*	History:
*		2002/9/12	Louis Created
*********************************************************************************/
#ifndef __LIB_HDCTL_H__
#define __LIB_HDCTL_H__

#include <sys/ioctl.h>
#include <linux/hdreg.h>       /* for HDIO_GETGEO */

#define DEFAULT_SECTOR_SIZE	512
#define MAX_SECTOR_SIZE	2048
#define SECTOR_SIZE	512	/* still used in BSD code */
#define MAX_HD_NO	1

/*partition type flag*/
#define EXTENDED        0x05
#define WIN98_EXTENDED  0x0f
#define LINUX_PARTITION 0x81
#define LINUX_SWAP      0x82
#define LINUX_NATIVE    0x83
#define LINUX_EXTENDED  0x85


/* define hd status code */
#define HD_ACTION_COMPLETE	205
#define HD_UNMOUNTING		204
#define HD_MOUNTING		203
#define HD_SCANNING		202	
#define HD_FORMATTING		201
#define HD_READY		200
#define HD_IOERR		199
#define HD_MOUNTERR		198
#define HD_UNINITIAL		0

/* hard drive power state */
#define HDPS_UNKNOWN		0
#define HDPS_SLEEPING		1
#define HDPS_ACTIVE		2

/*Application Path Name */
#define MKEXT3		"/sbin/mke2fs"
#define TUNE2FS		"/sbin/tune2fs"
#define E2FSCK		"/sbin/e2fsck"
#define MOUNT		"/bin/mount"
#define UMOUNT		"/bin/umount"
#define MKDIR		"/bin/mkdir"
#define CHMOD		"/bin/chmod"


/* including <linux/fs.h> fails */

#define BLKRRPART  _IO(0x12,95)    /* re-read partition table */
#define BLKGETSIZE _IO(0x12,96)    /* return device size */
#define BLKFLSBUF  _IO(0x12,97)    /* flush buffer cache */
#define BLKSSZGET  _IO(0x12,104)   /* get block device sector size */

struct partition {
	unsigned char boot_ind;         /* 0x80 - active */
	unsigned char head;             /* starting head */
	unsigned char sector;           /* starting sector */
	unsigned char cyl;              /* starting cylinder */
	unsigned char sys_ind;          /* What partition type */
	unsigned char end_head;         /* end head */
	unsigned char end_sector;       /* end sector */
	unsigned char end_cyl;          /* end cylinder */
	unsigned char start4[4];        /* starting sector counting from 0 */
	unsigned char size4[4];         /* nr of sectors in partition */
};

struct geom {
	unsigned int heads;
	unsigned int sectors;
	unsigned int cylinders;
};

typedef struct {
	char model_name[128];
	char serial_num[64];
	long capacity;		//KILOBYTE
	long available;
	long used_percent;
	char mount_point[30];
	unsigned char stat;
}HD_INFO;

/*  To declare the exported function */
int HD_Get_Information(int hd_no,HD_INFO *info);
int HD_Add_Label(int hd_no);
int HD_Initialization(int hd_no);
int HD_Is_Initial(int hd_no);
int HD_Clear_MBR(int hd_no);
int HD_Create_One_Max_Partition(int hd_no);
int HD_Get_Geometry(int hd_no, struct geom*) ;
int HD_Get_Identification(int hd_no,struct hd_driveid *);
int HD_Is_Active(int hd_no);
int HD_Format_Ext3(int hd_no);
int HD_Examine(int hd_no);
int HD_Mounting(int hd_no);
int HD_Unmounting(int hd_no);
int HD_Crate_Default_Dir(int hd_no);
int HD_SMART_Status (int hd_no);
int HD_Enable_SMART(int hd_no,int enable);
int HD_SMART_Check(int fd_no);
char* HD_Get_Sharing_Path(int hd_no);
char* HD_Get_Mounting_Path(int hd_no);
char* HD_Get_Partition_Path(int hd_no);
int HD_Set_Standby_Timeout(int hd_no, int timeout);
int HD_Get_Power_State(int hd_no);
int FW_Backup_To_HD(int hd_no);
int HD_Check_Mount(char *mount_point);
#endif
