// 2004/01/27	matthew		add User_Change_Name
// 2004/01/28	matthew		add Group_Change_Name, Shares_Change_Name

#ifndef __LIBCONF_H__
#define __LIBCONF_H__

#include "mct_errno.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netinet/if_ether.h>
#include <netdb.h>
#include <unistd.h>
#include <fcntl.h>
#include <asm/mconfig.h>
#include <dirent.h>

#define DHCP_CONF_PATH		"/etc/dhcpd.conf"
#define DHCP_LEASE_PATH		"/etc/dhcpd.leases"
#define	PPPOE_CONF_PATH		"/etc/ppp/pppoe.conf"
#define PPPOE_PAP_PATH		"/etc/ppp/pap-secrets"
#define PPPOE_CHAP_PATH		"/etc/ppp/chap-secrets"
#define PPP_OPTIONS_PATH	"/etc/ppp/options"
#define SAMBA_CONF_PATH		"/etc/samba/smb.conf"
#define PRINTCAP_PATH		"/etc/printcap"
#define DNS_CONF_PATH		"/etc/resolv.conf"
#define PDNS_CONF_PATH		"/etc/pdnsd.conf"
#define IPSEC_CONF_PATH 	"/etc/ipsec.conf"
#define IPSEC_SECRET_PATH	"/etc/ipsec.secrets"
#define HOSTS_PATH		"/etc/hosts"
#define PPTPD_CONF_PATH		"/etc/pptpd.conf"
#define PASSWD_PATH		"/etc/passwd"
#define GROUP_PATH		"/etc/group"
#define SMBPASSWD_PATH		"/etc/samba/smbpasswd"
#define SMBPASSWD_APP_PATH	"/sbin/smbpasswd"
#define PPTPC_OPTIONS_PATH	"/etc/ppp/options.pptpc"
#define DDNS_CONF_PATH		"/etc/ddns.conf"
#define BPA_CONF_PATH		"/etc/bpalogin.conf"

#define IPTABLES_PATH		"/sbin/iptables"
#define CHMOD_PATH		"/sbin/chmod"

#define VSERVER_SH_PATH		"/sbin/vserver.sh"
#define URL_ACCESS_SH_PATH	"/sbin/url.sh"
#define IP_ACCESS_SH_PATH	"/sbin/ip.sh"
#define ANTIHACK_SH_PATH	"/sbin/antihack.sh"

#define NIC_SH_PATH		"/etc/rc.d/init.d/S19network"
#define DHCPD_SH_PATH		"/etc/rc.d/init.d/S25dhcpd"
#define MASQ_SH_PATH		"/etc/rc.d/init.d/S30masq"
#define FIRLWALL_SH_PATH	"/etc/rc.d/init.d/S40ipfilter"
#define PPTP_SH_PATH		"/etc/rc.d/init.d/S45pptpd"
#define SAMBA_SH_PATH		"/etc/rc.d/init.d/S50smbd"
#define ATALK_SH_PATH		"/etc/rc.d/init.d/S51atalk"
#define IPSEC_SH_PATH		"/etc/rc.d/init.d/S80ipsec"
#define HTTPD_SH_PATH		"/etc/rc.d/init.d/S21httpd"
#define IPSEC_APP_PATH		"/usr/sbin/ipsec"
#define IPALIAS_SH_PATH		"/sbin/ipalias.sh"
#define MNAT_SH_PATH		"/sbin/multinat.sh"
#define NFS_SH_PATH		"/etc/rc.d/init.d/S52nfsd"
#define PORTMAP_SH_PATH		"/etc/rc.d/init.d/S23portmap"
#define FTP_SH_PATH		"/etc/rc.d/init.d/S53ftpd"
#define W3S_SH_PATH		"/etc/rc.d/init.d/S91w3s"
#define UPNP_NAS_SH_PATH	"/etc/rc.d/init.d/S92upnp_nas_device"
#define UPNP_MMS_SH_PATH	"/etc/rc.d/init.d/S94upnp_mms"
#define RENDEZVOUS_SH_PATH	"/etc/rc.d/init.d/S93Rendezvous"



char * webip2str(unsigned long ip);
int mct_killall(char *appname, int sig);
// ======================================================================= //
//			      	access.c				   //
// ========================================================================//
int Config_Read(int type, void *config);
int Config_Write(int type, void *config);

// DNS Proxy
int PDNS_Create_Setup_File(void);

// ======================================================================= //
//			      	nic.c					   //
// ========================================================================//
#define NIC_HWADDR_LEN		20
#define NIC_IPADDR_LEN		20
#define NIC_DEV_LEN		10

typedef struct {
	char dev[NIC_DEV_LEN]; 		/* eth0 or eth1... */
        char hwaddr[NIC_HWADDR_LEN];    /* convert to string with : char */
        char ipaddr[NIC_IPADDR_LEN];
        char netmask[NIC_IPADDR_LEN];
        char gateway[NIC_IPADDR_LEN];
        char broadcast[NIC_IPADDR_LEN];
} NIC_INFO;

typedef struct tag {
	char ifdev[NIC_DEV_LEN]; 		/* eth0 or eth1... */
        char netmask[NIC_IPADDR_LEN];
        char gateway[NIC_IPADDR_LEN];
        char desti[NIC_IPADDR_LEN];
        struct tag *next;
} NIC_ROUTE_INFO;

//-------- Get network information from linux system ---------------//
int NIC_Get_WAN_Info(NIC_INFO *info);
int NIC_Get_LAN_Info(NIC_INFO *info);
NIC_ROUTE_INFO *NIC_Get_Route_Info(int *list_cnt);
void NIC_Free_Route_Info(NIC_ROUTE_INFO *info);
int MCT_Set_Hosts_File(void);
int MCT_Clean_Resolv_File(void);
int MCT_Update_Resolv_File(void);

//------- PPPOE  setup function ------------------------------------//
#define PPPOE_LINKUP	 	1
#define PPPOE_LINKDOWN	 	0

int  PPPOE_Set_Enable(BOOL enable);
BOOL PPPOE_Is_Enable();
int  PPPOE_Create_Setup_File(void);
int  PPPOE_Get_Status(void);
unsigned long PPPOE_Get_Connection_Time(void);
void PPPOE_Start_Connection(void);
void PPPOE_Stop_Connection(void);
void PPTPC_Create_Setup_File(void);

//------------IPALIAS Configuration--------------------------------//
int IPALIAS_Create_Setup_File();
//------------Mutiple NAT Configuration--------------------------------//
int Multi_NAT_Create_Setup_File();
//------------DDNS Configuration---------------------------------------//
void DDNS_Create_Setup_File();



// ======================================================================== //
//			      	dhcp.c		     		       	    //
// =========================================================================//
typedef struct {
	char	ip[NIC_IPADDR_LEN];
	time_t	start,end;
	unsigned char mac[6];
	char	hostname[20];
} IP_LEASES;

typedef struct {
	int lease_count;
	IP_LEASES item[MAX_DHCP_LEASES_RECORDS];
} DHCP_LEASE;

BOOL DHCP_Is_Enable();
int  DHCP_Create_Setup_File(void);
int  DHCP_Get_Leases_From_File(DHCP_LEASE *lease);
int  DHCP_Get_Leases_From_Flash(DHCP_LEASE *lease);
int  DHCP_Save_Leases_To_Flash(); // just be uesd while system shutdown

// ======================================================================== //
//			      	firewall.c		            	    //
// =========================================================================//

//------------------- Virsul server function -----------------------//
int VSERVER_Create_Setup_File(void);
BOOL VSERVER_Is_Enable(void);

//------------------- URL access function ------------------------//
int URL_ACCESS_Create_Setup_File(void);
BOOL URL_ACCESS_Is_Enable(void);

//------------------- IP access function -------------------------//
int IP_ACCESS_Create_Setup_File(void);
BOOL IP_ACCESS_Is_Enable(void);

//--------------------- anti-hacker ------------------------------//
int ANTIHACK_Create_Setup_File(void);
BOOL ANTIHACK_Is_Enable(void);

// ======================================================================== //
//			      	vpn.c	(IPSEC & PPTP)		            //
// =========================================================================//
int IPSEC_Start_Connection(char *conn_name);
int IPSEC_Stop_Connection(char *conn_name);
int IPSEC_Add_Connection(char *conn_name);
int IPSEC_Del_Connection(char *conn_name);
int IPSEC_Modified_Connection(char *conn_name);
int IPSEC_Update_Secrets();
BOOL IPSEC_Is_Enable(void);
int IPSEC_Create_Setup_File(void);
BOOL IPSEC_Is_Connection_Alive(char *conn_name);

BOOL PPTP_Is_Enable(void);
int PPTP_Create_Setup_File(void);

#if defined(SG600) || defined(CONFIG_ONLY_NAS)
//#ifdef SG600
int PPTP_Get_User_List(LA_USER_DATA *userlist,int list_cnt);
int PPTP_Add_User(char *username);
int PPTP_Remove_User(char username);
int PPTP_Add_Group(char *grpname);
int PPTP_Remove_Group(char *grpname);
#endif

// ======================================================================== //
//			      	smbprn.c			            //
// =========================================================================//
int SMBPRN_Conf_Set(REG_SAMBA_CONF *conf);
int SMBPRN_Conf_Get(REG_SAMBA_CONF *conf);
int SMBPRN_Set_Enable(BOOL enable);
int SMBPRN_Create_Setup_File(void);

// ======================================================================== //
//			      	sysinfo.c			            //
// =========================================================================//
int MCT_Get_CPU_Loadavg(double *av1, double *av5, double *av15) ;
unsigned long MCT_Get_Process_Life_Time(int pid);
int MCT_Getpid(char* cmdline);

// ======================================================================== //
//			      	log.c				            //
// =========================================================================//
int ALARM_SendMail(char *Subject,char *msg,char *level);
int ALARM_Get_Level(void);
BOOL ALARM_Is_Enable(void);

int Add_Logs(int level, int msgid, void *arg);


#if defined(SG600) || defined(CONFIG_ONLY_NAS)
//#ifdef SG600
// ======================================================================== //
//			      	usergrp.c				    //
// =========================================================================//
#define USR_BEGIN_NO 2
#define GRP_BEGIN_NO 1
#define ADMINISTATOR		"admin"
#define GUEST			"guest"	
#define DEFGROUP		"everyone"

int User_Add_To_System(char *username,char *passwd,char *group);
int User_Remove_From_System(char *username);
int User_Change_Passwd(char *username,char *passwd);
int User_Change_Name(char *pOldUserName, char *pNewUserName);
int User_Get_UID(char *username);
int User_Get_Name(char *username , int uid);
int User_Get_All_Info(LA_USER_DATA *userlist,int list_cnt);
char* User_Belong_Group_Name(char *username);
int Group_Get_GID(char *groupname);
int Group_Get_Name(char *grpname , int gid);
int Group_Get_All_Info(LA_GROUP_DATA *grplist,int list_cnt);
int Group_Add_To_System(char *grpname);
int Group_Remove_From_System(char *grpname);
int Group_Get_Amount_Of_Members(char *grpname);
int Group_Change_Name(char *pOldGroupName, char *pNewGroupName);

int Users_Remove_From_System(int *uid_list,int cnt);
int Groups_Remove_From_System(int *gid_list,int cnt);
int Group_Members_Update(char *grpname,int *mem_id_list, int cnt,int new_flag);

int User_Add_To_Group(char *username,char *grpname);
int User_Remove_From_Group(char *username,char *grpname);
BOOL User_Check_Passwd(char *username,char *passwd);
int Update_Passwd_File(void);
int Update_Group_File(void);
int Update_Smbpasswd_File(void);
#ifdef QMAIL
void Change_OwnGrp_On_Maildir(char *username);
void Build_User_Maildir(char *username);
void Check_User_Maildir_On_Boot(void);
void Check_Qmail_Sysdir_On_Boot(void);
// ======================================================================== //
//			      	misc.c		   		  	    //
// =========================================================================//
void Update_Mailser_Config_Files(void);
#endif

int bitstr_get(__u32 *bits, int pos);
void bitstr_mask(__u32 *bits, int pos);
void bitstr_unmask(__u32 *bits, int pos);
void bitstr_clean( __u32 *bits);

#else
// ======================================================================== //
//			      	user.c		   		  	    //
// =========================================================================//
int User_Add_To_System(char *username,char *passwd,char *group, unsigned char ip_offset);
int User_Remove_From_System(char *username);
int User_Get_All_Info(REG_USER_CONF *user_conf);
int User_Change_Passwd(char *username,char *passwd, unsigned char ip_offset);
#endif

#if defined(SG600) || defined(CONFIG_ONLY_NAS)
//#ifdef SG600
// ======================================================================== //
//			      	share.c		   		  	    //
// =========================================================================//
#define ATT_GUEST_OK		0x01
#define ATT_GUEST_READ_ONLY	0x02
#define ATT_GUEST_WRITE_OK	0x04
#define DEF_SHARE_FOLDER	"NAS"

enum {
	SHARE_NOACCESS,
	SHARE_READONLY,
	SHARE_READWRITE,
};

int Shares_Info_Updated(LA_SHARE_DATA *sha_data,int new_flag);
int Shares_Remove_From_System(char *share_name_list[MAX_SHARENAME_LEN],int cnt);
int Shares_Get_All_Info(LA_SHARES *sha_info);
int Shares_Updated_Conf_File();	// need to kill some non-exist user's process;
int Shares_Check_User_Privilege(char *share_name,char *username,int read_only);
int Shares_Get_User_Privilege(char *share_name,char *username);
int Shares_Remove_All(void);
int Shares_Add_Default_Setting(void);
int Shares_Change_Name(char *pOldShareName, char *pNewShareName);
BOOL Shares_Check_Guest_Have_Access_Right(void);
int Shares_Add_From_Formated_HD(void);
int NFS_Create_Exports(void);
#ifdef W3S
void W3S_Add_Shared_Folder(void);
void W3S_Remove_Shared_Folder(void);
#endif
#ifdef UPNP_MMS
void Upnp_MMS_Add_Shared_Folder(void);
void Upnp_MMS_Remove_Shared_Folder(void);
#endif
// ======================================================================== //
// 				nfs.c					    //				
// ======================================================================== //

#include <netinet/in.h>

#define NFSCONF_FILE	"/etc/nfs.conf"

enum {
	NFSIP_SINGLE,
	NFSIP_RANGE,
	NFSIP_WILDCARD,
	NFSIP_END,
};

typedef struct {
	unsigned short	uid;
	int		type;
	struct in_addr	ipaddr, netmask;
} NFS_USER;

typedef struct {
	unsigned short	uid;
	int		type;
	struct in_addr	ipaddr, netmask;
	char		username[MAX_USERNAME_LEN];
} NFS_USER_EX;


//	Function Prototype
int Load_All_NFS_Users(NFS_USER_EX *pusers, int *size);
int Add_NFS_Config(char *username,unsigned char remote_uid,unsigned char type,unsigned long ip,unsigned char mask_no);
int Clean_NFS_Users(void);
int Remove_NFS_Config(char *username,unsigned char remote_uid,unsigned char type,unsigned long ip,unsigned char mask_no);
int Get_NFS_Users(char *username, NFS_USER *nfs_user, int *size);
int Remove_NFS_Config_Item(int item_no);
int Remove_NFS_User(int uid);

#endif //SG600

// add by matthew 2004/01/16
// ======================================================================== //
//			      	config_tool.c			            //
// =========================================================================//
#ifdef CONFIG_IO_SETUP_FILE
#define CONFIG_IO_MAGIC_NUMBER				(unsigned char)0x96
void exportSystemData(FILE *pFile);
void importSystemConfigData(FILE *pFile);
void exportUserData(FILE *pFile);
void importUserData(FILE *pFile);
void exportExtSystemData(FILE *pFile);
void importExtSystemData(FILE *pFile);
int exportAllConfig(char *pFileName);
int importAllConfig(char *pFileName);
#endif

#endif	// __LIBCONF_H__
