/********************************************************************************
*
*	Copyright (c) 2003  Magic Control Technology Co.  All Rights Reserved.
*
*	FILE:
*		misc.c
*
*
*	HISTORY:
*		2003/9/12	Louis Tsai Created
*********************************************************************************/
#include "libconf.h"

#define MAILCONF_FILE_LOCALS		"/etc/qmail/locals"
#define MAILCONF_FILE_ME		"/etc/qmail/me"
#define MAILCONF_FILE_DEFAULTDOMAIN	"/etc/qmail/defaultdomain"
#define MAILCONF_FILE_PLUSDOMAIN	"/etc/qmail/plusdomain"
#define MAILCONF_FILE_DATABYTES		"/etc/qmail/databytes"


static char* get_sub_string(char *s,char del,int pos)
{
	int i;
	char *retstr;
	
	retstr = s;
	for(i=0;i<pos;i++) { 
		retstr = strchr(retstr,del);
		if(!retstr) return s;
		retstr = retstr+1;
	}
	
	return retstr;
}

#ifdef QMAIL
void Update_Mailser_Config_Files()
{
	REG_MAIL_CONF mailconf;
	FILE *fp;
	
	system("ln -s /mnt/HDA/qmail /var/qmail");
	Config_Read(MC_MAIL_CONFIG, &mailconf);
	fp=fopen(MAILCONF_FILE_LOCALS,"w");
	fprintf(fp,"%s",mailconf.domain_name);
	fclose(fp);
	
	Config_Read(MC_MAIL_CONFIG, &mailconf);
	fp=fopen(MAILCONF_FILE_ME,"w");
	fprintf(fp,"%s",mailconf.domain_name);
	fclose(fp);
	
	Config_Read(MC_MAIL_CONFIG, &mailconf);
	fp=fopen(MAILCONF_FILE_DEFAULTDOMAIN,"w");
	fprintf(fp,"%s",get_sub_string(mailconf.domain_name,'.',1));
	fclose(fp);
	
	Config_Read(MC_MAIL_CONFIG, &mailconf);
	fp=fopen(MAILCONF_FILE_PLUSDOMAIN,"w");
	fprintf(fp,"%s",get_sub_string(mailconf.domain_name,'.',2));
	fclose(fp);
	
	Config_Read(MC_MAIL_CONFIG, &mailconf);
	fp=fopen(MAILCONF_FILE_DATABYTES,"w");
	fprintf(fp,"%ld",mailconf.max_mail_size*1024*1024);
	fclose(fp);
		
	
}
#endif
