#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "libconf.h"


static unsigned long bit2long(int bitcnt)
{
	int i,mask=0,ret=0xffffffff;
	for(i=0;i<32-bitcnt;i++) mask|= (0x1<<i);
	ret&= ~mask;
	return ret;
}

static int long2bitno(unsigned long val)
{
	int bitcnt=0;
	
	while(val!=0) {
		if((val&0x1)) break;
		val >>=1;	
		bitcnt++;
	}
	return 32-bitcnt;
}

int Load_All_NFS_Users(NFS_USER_EX *pusers, int *size)
{
	int  i;
	REG_NFS_CONF nfsconf;
	
	Config_Read(MC_NFS_CONFIG,&nfsconf);
	
	*size = nfsconf.count;
	
	if(pusers == NULL) return nfsconf.count;
	
	for(i=0;i<nfsconf.count;i++) {
		pusers[i].uid 		= nfsconf.nfs_item[i].remote_uid;
		pusers[i].type 		= nfsconf.nfs_item[i].type;
		pusers[i].ipaddr.s_addr = ntohl(nfsconf.nfs_item[i].remote_ip);
		pusers[i].netmask.s_addr= bit2long(nfsconf.nfs_item[i].mask_no);
		User_Get_Name(pusers[i].username, nfsconf.nfs_item[i].local_uid);
	}
	
	return nfsconf.count;
}

int Add_NFS_Config(char *username,unsigned char remote_uid,unsigned char type,unsigned long ip,unsigned char mask_no)
{
	REG_NFS_CONF nfsconf;
	
	Config_Read(MC_NFS_CONFIG,&nfsconf);
	if(nfsconf.count == MAX_NFS_MOUNTS ) return -1;
	nfsconf.nfs_item[nfsconf.count].remote_uid 	= remote_uid;
	nfsconf.nfs_item[nfsconf.count].type		= type;
	nfsconf.nfs_item[nfsconf.count].remote_ip	= ip;
	nfsconf.nfs_item[nfsconf.count].mask_no		= mask_no;
	if(User_Get_UID(username)>=0)
		nfsconf.nfs_item[nfsconf.count].local_uid = User_Get_UID(username);
	else
		return -1;

	nfsconf.count++;
	
	Config_Write(MC_NFS_CONFIG,&nfsconf);
	return 0;
}

int Clean_NFS_Users()
{
	REG_NFS_CONF nfsconf;
	Config_Read(MC_NFS_CONFIG,&nfsconf);
	nfsconf.count = 0;
	Config_Write(MC_NFS_CONFIG,&nfsconf);

}

int Remove_NFS_Config_Item(int item_no)
{
	REG_NFS_CONF nfsconf;
	
	Config_Read(MC_NFS_CONFIG,&nfsconf);
	nfsconf.nfs_item[nfsconf.count-1] = nfsconf.nfs_item[item_no];
	nfsconf.count--;
	
	Config_Write(MC_NFS_CONFIG,&nfsconf);
	
}

int Remove_NFS_Config(char *username,unsigned char remote_uid,unsigned char type,unsigned long ip,unsigned char mask_no)
{
	int  i,uid,found;
	REG_NFS_CONF nfsconf;
	
	Config_Read(MC_NFS_CONFIG,&nfsconf);
	if((uid=User_Get_UID(username))<0) return -1;
	
	for(i=0;i<nfsconf.count;i++) {
		if(nfsconf.nfs_item[i].local_uid  == uid &&
		   nfsconf.nfs_item[i].remote_uid == remote_uid &&
		   nfsconf.nfs_item[i].type == type &&
		   nfsconf.nfs_item[i].remote_ip == ip &&
		   nfsconf.nfs_item[i].mask_no == mask_no) {
			nfsconf.nfs_item[i] = nfsconf.nfs_item[nfsconf.count -1];
			nfsconf.count--;
			found = 1;
			break;
		}
	}
	if(found) {
		Config_Write(MC_NFS_CONFIG,&nfsconf);
		return 0;
	}
	else
		return -1;
		
}

int Remove_NFS_User(int uid)
{
	int  i,found;
	REG_NFS_CONF nfsconf;
	
	Config_Read(MC_NFS_CONFIG,&nfsconf);
	
	for(i=0;i<nfsconf.count;i++) {
		if(nfsconf.nfs_item[i].local_uid  == uid ) {
			nfsconf.nfs_item[i] = nfsconf.nfs_item[nfsconf.count -1];
			nfsconf.count--;
			found = 1;
			i--;
		}			
	}
	
	if(found) {
		Config_Write(MC_NFS_CONFIG,&nfsconf);
		return 0;
	}
	else
		return -1;
	
	
	
}


int Get_NFS_Users(char *username, NFS_USER *nfs_user, int *size)
{
	int i, ret, count;
	NFS_USER_EX *pusers;
	int buf_enough;
	int entry;	// specify the index of the next entry we will fill in "nfs_user".
#ifdef DEBUG
	NFS_USER_EX *puser;
	struct in_addr fromaddr, toaddr;
#endif

	// get all users
	count = 0;
	ret = Load_All_NFS_Users(NULL, &count);
	if ( ret < 0 && ret != ERR_BUFFER_SIZE_SMALL )
	{
		return 0;
	}

	if ( (pusers = (NFS_USER_EX*) malloc(count * sizeof(NFS_USER_EX))) == NULL )
	{
		return 0;
	}
	Load_All_NFS_Users(pusers, &count);

#ifdef DEBUG
	for (i = 0 ; i < count ; i++)
	{
		puser = &pusers[i];
		fromaddr = puser->ipaddr;
		toaddr = puser->netmask;
		printf("Get_NFS_Config(%d)... %s:%d:%d:", i,
			puser->username,
			puser->uid,
			puser->type);
		if ( puser->type == NFSIP_SINGLE || puser->type == NFSIP_RANGE )
		{
			printf("%d.%d.%d.%d",
				(unsigned char) (fromaddr.s_addr>>24),
				(unsigned char) (fromaddr.s_addr>>16),
				(unsigned char) (fromaddr.s_addr>>8),
				(unsigned char) fromaddr.s_addr);
		}
		printf(":");
		if ( puser->type == NFSIP_RANGE )
		{
			printf("%d.%d.%d.%d",
				(unsigned char) (toaddr.s_addr>>24),
				(unsigned char) (toaddr.s_addr>>16),
				(unsigned char) (toaddr.s_addr>>8),
				(unsigned char) toaddr.s_addr);
		}
		printf("\n");
	}
#endif

	buf_enough = 1;
	if ( nfs_user == NULL || *size < 0 )
	{
		buf_enough = 0;
	}

	// Retrieve all entries
	entry = 0;
	for (i = 0 ; i < count ; i++)
	{
		if ( strcmp(username, pusers[i].username) == 0 )
		{
			if ( entry > *size - 1 )
			{
				buf_enough = 0;
			}

			if ( buf_enough )
			{
				nfs_user[entry].uid = pusers[i].uid;
				nfs_user[entry].type = pusers[i].type;
				nfs_user[entry].ipaddr = pusers[i].ipaddr;
				nfs_user[entry].netmask = pusers[i].netmask;
			}
			entry++;
		}
	}

	free(pusers);

	*size = entry;
	return ( buf_enough ) ? 0 : -1;
}

