/********************************************************************************
*
*	Copyright (c) 2002  Magic Control Technology Co.  All Rights Reserved.
*
*	FILE:
*		dhcp.c
*
*	Abstract:
*		 dhcp configuration function
*		
*	History:
*		2002/1/28	Louis Tsai Added
*********************************************************************************/

#include "libconf.h"

char * time2asc(time_t louis)
{
	
	static char *buffer= NULL;
	struct tm *t;
	
	
	if(buffer != NULL ) free( buffer);
	
	buffer = (char *) malloc(64);
	t = gmtime (&louis);
	sprintf (buffer,"%d %d/%02d/%02d %02d:%02d:%02d",
		 t -> tm_wday, t -> tm_year + 1900,
		 t -> tm_mon + 1, t -> tm_mday,
		 t -> tm_hour, t -> tm_min, t -> tm_sec);
	
	return buffer;
}

char * m_strmac(unsigned char *kk)
{
	static char *buffer2= NULL;
	
	if(buffer2 != NULL ) free( buffer2);
	
	buffer2 = (char *) malloc(25);
	sprintf(buffer2,"%.2x:%.2x:%.2x:%.2x:%.2x:%.2x",kk[0],kk[1],kk[2],kk[3],kk[4],kk[5]);
	return buffer2;
}

time_t m_str2time(char *str)
{
	time_t 	louis;
	char 	seps[]=" //:;";
	struct 	tm tm;
	char	*token;
	static int months [11] = { 31, 59, 90, 120, 151, 181,
					  212, 243, 273, 304, 334 };
	
	//days of week
	token = strtok(str, seps);
	if(token == NULL) return 0;
	
	//year
	token	   = strtok(NULL, seps);
	tm.tm_year = atoi(token);
	//month
	token      = strtok(NULL, seps);
	tm.tm_mon  = atoi(token) - 1;
	//day of month
	token      = strtok(NULL, seps);
	tm.tm_mday = atoi(token);
	//hour
	token      = strtok(NULL, seps);
	tm.tm_hour = atoi(token);
	//minute
	token      = strtok(NULL, seps);
	tm.tm_min  = atoi(token);
	//sec
	token 	   = strtok(NULL, seps);
	tm.tm_sec  = atoi(token);
	
	louis = ((((((365 * (tm.tm_year - 1970) +	/* Days in years since '70 */
		      (tm.tm_year - 1969) / 4 +	/* Leap days since '70 */
		      (tm.tm_mon		/* Days in months this year */
		       ? months [tm.tm_mon - 1]
		       : 0) +
		      (tm.tm_mon > 1 &&		/* Leap day this year */
		       !((tm.tm_year - 1972) & 3)) +
		      tm.tm_mday - 1) * 24) +	/* Day of month */
		    tm.tm_hour) * 60) +
		  tm.tm_min) * 60) + tm.tm_sec;
	
	return louis;
}

BOOL DHCP_Is_Enable()
{
	REG_DHCP_CONF dhcpconf;
	
	Config_Read(MC_DHCP_CONFIG, &dhcpconf);
	return dhcpconf.enable;
}


//to generate dhcpd.conf & dhcpd.leases

int  DHCP_Create_Setup_File(void)
{
	REG_NET_CONF netconf;
	REG_DHCP_CONF dhcpconf;
	DHCP_LEASE lease;
	__u32 tmp;
	struct in_addr in;
	char route_str[256];
	int i;
	
	FILE *fp;
	
	Config_Read(MC_NET_CONFIG, &netconf);
	Config_Read(MC_DHCP_CONFIG, &dhcpconf);	
		
	if(DHCP_Get_Leases_From_Flash(&lease) != SUCCESS )
		return FAILED;
	
	fp = fopen(DHCP_CONF_PATH,"w");
	if(fp == NULL ) return FAILED;
	
	fprintf(fp,"default-lease-time %d;\n",dhcpconf.default_lease_time*60);
	fprintf(fp,"max-lease-time %d;\n",dhcpconf.max_lease_time*60);
	fprintf(fp,"option netbios-name-servers %s;\n",webip2str(dhcpconf.wins));
	fprintf(fp,"option subnet-mask %s;\n",webip2str(netconf.private_netmask));
	fprintf(fp,"option domain-name \"%s\";\n",dhcpconf.domain_name);
	
	tmp 	  = ~(inet_addr(webip2str(netconf.private_netmask))) | inet_addr(webip2str(netconf.private_ip)) ;
	in.s_addr = (unsigned long int)tmp;
//printf("%s\n",inet_ntoa(in));
	fprintf(fp,"option broadcast-address %s;\n",inet_ntoa(in));
	
	strcpy(route_str,"");
	
	if( netconf.dns0 != 0 ) {
		strcat(route_str,webip2str(netconf.dns0));
		strcat(route_str,",");
	}
	if( netconf.dns1 != 0 ) {
		strcat(route_str,webip2str(netconf.dns1));
		strcat(route_str,",");
	}
	if( netconf.dns2 != 0 ) {
		strcat(route_str,webip2str(netconf.dns2));
		strcat(route_str,",");
	}

	if ( *route_str != 0 ) {
		route_str[strlen(route_str)-1] = ';' ;
//printf("route_str = %s\n",route_str);
		
		fprintf(fp,"option domain-name-servers %s\n\n",route_str);
	}
	fprintf(fp,"option routers %s;\n\n",webip2str(netconf.private_ip));
	
	// ethan: FIXME
	tmp 	  = (inet_addr(webip2str(netconf.private_netmask))) & inet_addr(webip2str(netconf.private_ip)) ;
	in.s_addr = (unsigned long int)tmp;
	
	fprintf(fp,"subnet %s netmask %s { \n",inet_ntoa(in), webip2str(netconf.private_netmask));
	
	if ( dhcpconf.rang1_s != 0 ) 
		fprintf(fp,"range %s %d.%d.%d.%d ;\n",
			webip2str(dhcpconf.rang1_s), 
			((unsigned char*) &dhcpconf.rang1_s)[0],
			((unsigned char*) &dhcpconf.rang1_s)[1],
			((unsigned char*) &dhcpconf.rang1_s)[2],
			dhcpconf.rang1_e);
	
	if( dhcpconf.rang2_s != 0 ) 
		fprintf(fp,"range %s %d.%d.%d.%d ;\n",
			webip2str(dhcpconf.rang2_s),
			((unsigned char*) &dhcpconf.rang2_s)[0],
			((unsigned char*) &dhcpconf.rang2_s)[1],
			((unsigned char*) &dhcpconf.rang2_s)[2],
			dhcpconf.rang2_e);
		
	if( dhcpconf.rang3_s != 0 ) 
		fprintf(fp,"range %s %d.%d.%d.%d ;\n",
			webip2str(dhcpconf.rang3_s),
			((unsigned char*) &dhcpconf.rang3_s)[0],
			((unsigned char*) &dhcpconf.rang3_s)[1],
			((unsigned char*) &dhcpconf.rang3_s)[2],
			dhcpconf.rang3_e);
		
	if( dhcpconf.rang4_s != 0 ) 
		fprintf(fp,"range %s %d.%d.%d.%d ;\n",
			webip2str(dhcpconf.rang4_s),
			((unsigned char*) &dhcpconf.rang4_s)[0],
			((unsigned char*) &dhcpconf.rang4_s)[1],
			((unsigned char*) &dhcpconf.rang4_s)[2],
			dhcpconf.rang4_e);
	
	fprintf(fp,"}\n");
	fclose(fp);
	
	fp = fopen(DHCP_LEASE_PATH,"w");
	if(fp == NULL ) return FAILED;
	for(i=0;i<lease.lease_count;i++) {
		fprintf(fp,"lease %s {\n", lease.item[i].ip);
		fprintf(fp,"\tstarts %s;\n", time2asc(lease.item[i].start));
		fprintf(fp,"\tends %s;\n", time2asc(lease.item[i].end));
		fprintf(fp,"\thardware ethernet %s;\n",m_strmac(lease.item[i].mac));
		fprintf(fp,"\tuid 01:%s;\n",m_strmac(lease.item[i].mac));
		fprintf(fp,"\tclient-hostname \"%s\";\n",lease.item[i].hostname);
		fprintf(fp,"}\n");
	}
	
	fclose(fp);
	return SUCCESS;
}


// note: before save leases record on flash , system must restart the dhcpd daemon to 
// 	 refresh the leases record
int  DHCP_Get_Leases_From_Flash(DHCP_LEASE *lease)
{
	REG_DHCP_LEASE reg;
	struct in_addr in;
	int i,j;
	
	
	if( Config_Read(MC_DHCP_LEASE,(void *)&reg) != 0 )
		return ERR_READ_CONFIG;
	
	lease->lease_count = reg.lease_count;
//printf("reg_cnt=%d\n",reg.lease_count);
	
	for(i=0;i<lease->lease_count;i++) {
		// lease ip
		in.s_addr = (unsigned long int) reg.item[i].ip;
		strncpy(lease->item[i].ip ,(char *)inet_ntoa(in),NIC_IPADDR_LEN);
		// start & end time stamp
		lease->item[i].start = reg.item[i].start;
		lease->item[i].end = reg.item[i].end;
		//mac address
		for(j=0;j<6;j++) 
			lease->item[i].mac[j] = reg.item[i].mac[j] ;
		//hostname
		strncpy(lease->item[i].hostname,reg.item[i].hostname,20);
	}
	
	return SUCCESS;
}

int  DHCP_Save_Leases_To_Flash() 
{
	DHCP_LEASE lease;
	REG_DHCP_LEASE reg;
	int i,j;
	
	//initialize reg variable
	for(i=0;i<MAX_DHCP_LEASES_RECORDS;i++) {
		reg.item[i].ip	  = 0;
		reg.item[i].start = 0; 
		reg.item[i].end   = 0;
		for(j=0;j<6;j++) reg.item[i].mac[j] = 0;
		strcpy(reg.item[i].hostname,"");	
	}
	//2002/4/16 Louistsai Added
	// Only when the /etc/dhcpd.leases file is dirty, the system need to 
	// update flash data immediately. If the dhcpd program update the leases
	// file , we can find the /etc/dhcpd.leases.dirty on the system!
	{
		FILE *fp;
		if((fp = fopen("/etc/dhcpd.leases.dirty","r")) != NULL) {
			system("/bin/rm -f /etc/dhcpd.leases.dirty");
			fclose(fp);
		}
		else
			return SUCCESS;
	}
	
	printf("Nnter DHCP_Save_Leases_To_Flash()\n");
	
	
	
	if(DHCP_Get_Leases_From_File(&lease) != SUCCESS)
		return FAILED;
		
	reg.lease_count = lease.lease_count;
	for(i=0;i<lease.lease_count;i++) {
		reg.item[i].ip 	  = (__u32) inet_addr(lease.item[i].ip);
		reg.item[i].start = lease.item[i].start;
		reg.item[i].end   = lease.item[i].end;
		
		for(j=0;j<6;j++) 
			reg.item[i].mac[j] = lease.item[i].mac[j] ;
		
		strcpy(reg.item[i].hostname,lease.item[i].hostname );
	}
	
	if( Config_Write(MC_DHCP_LEASE,(void *)&reg) == 0 )
		return SUCCESS;
	else
		return ERR_WRITE_CONFIG;
	
	
	return SUCCESS;
}


int  DHCP_Get_Leases_From_File(DHCP_LEASE *lease)
{
	//char	cmdline[128];
	char	str[256];
        FILE	*fptr;
        char	seps[] = " \t\n;:{}\"";
	char	*token;
	int	cnt=0,i=0,index=0,rep_flag=0;
	
	//restart dhcpd to refresh leases db
//	sprintf(cmdline,"%s restart",DHCPD_SH_PATH);
//	system(cmdline);
	
	//get leases db from /etc/dhcpd.leases
	fptr=fopen(DHCP_LEASE_PATH, "r");
	
	if(fptr ==  NULL) 
		return FAILED;
	
        while (fgets(str, 256, fptr) != NULL) {
        	if( *str == '#' ) continue;
        	token = strtok(str, seps);
        	index = cnt;
                if(token == NULL)
			continue;
        	if(strcmp(token,"lease") == 0 ) {	// lease ip
        		token = strtok(NULL, seps);
        	 	for(i=0;i<cnt;i++) {
        			if(strcasecmp(token,lease->item[i].ip) == 0 ) {
        				rep_flag = 1;
        				index = i ;
        				break;	
        				
        			}
        		}
			if(strcasecmp(token,"255.255.255.255") == 0 ) 
				rep_flag = 1;
			
        		strcpy(lease->item[index].ip,token);
        	 	continue;
        	}
        	else
        	if(strcmp(token,"starts") == 0 ) {	// start time stamp
        		char *tmp;
        	 	tmp = strstr(str,"starts");
        	 	tmp = tmp+strlen("starts")+1;
        	 	tmp[strlen(tmp)-2] = '\0';
        	 	lease->item[index].start = m_str2time(tmp);
        	 	continue;
        	}
        	else
        	if(strcmp(token,"ends") == 0 ) {	// end time stamp
        		char *tmp;
        	 	tmp = strstr(str,"ends");
        	 	tmp = tmp+strlen("ends")+1;
        	 	tmp[strlen(tmp)-1] = '\0';
        	 	lease->item[index].end = m_str2time(tmp);
        	 	continue;
        	}
        	else
        	if(strcasecmp(token,"abandoned") == 0 ) {
        		rep_flag = 1;
        		continue;
        	}
        	else	
        	if(strcmp(token,"hardware") == 0 ) {	// lease hw address
        		token = strtok(NULL, seps);
        		for(i=0;i<6;i++) {
        			token = strtok(NULL, seps);
        			sscanf(token, "%x", &(lease->item[index].mac[i]));
        		}
        		continue;
        	}
        	else
        	if(strcmp(token,"client-hostname") == 0 ) {	// lease hostname
        		token = strtok(NULL, seps);
        		strcpy(lease->item[index].hostname,token);
        		if(rep_flag == 1) 
        			rep_flag = 0;
        		else
        			cnt++;
        		
        		continue;
        	}
        	else 
        		continue;
        }
	
	
	lease->lease_count = cnt;
	fclose(fptr);

	return SUCCESS;
	
}

