#include "libconf.h"

void pdns_add_dns_server(FILE *fp, unsigned long dns)
{
	if ( dns == 0 )
		return;
	
	fprintf(fp,
		"server {\n"
		"\tip=\"%s\";\n"
		"\ttimeout=30;\n"
		"\tinterval=30;\n"
		"\tuptest=ping;\n"
		"\tping_timeout=50;\n"
		"\tpurge_cache=off;\n"
		"}\n\n", webip2str(dns));
}

int PDNS_Create_Setup_File(void)
{
	FILE	*fp;
	REG_NET_CONF	netconf;

	Config_Read(MC_NET_CONFIG, &netconf);

	if ( (fp=fopen(PDNS_CONF_PATH, "w")) == NULL )
		return FAILED;

	fprintf(fp,
		"global {\n"
		"\tperm_cache=510;\n"
		"\tcache_dir=\"/var/cache/pdnsd\";\n"
		"\tmax_ttl=604800;\n"
		"\tparanoid=on;\n"
		"}\n\n");

	pdns_add_dns_server(fp, netconf.dns0);
	pdns_add_dns_server(fp, netconf.dns1);
	pdns_add_dns_server(fp, netconf.dns2);

	fclose(fp);
	
	return SUCCESS;
}

