
#include <stdio.h>
#include "libconf.h"

int main(int argc, char **argv)
{
	int	i;
	int	write_flag;
	int	model_name_flag;
	char	model_name[20];
	REG_SYS_CONF	sys_conf;

	model_name_flag = 0;
	for (i = 1; i < argc; i++) {
		if ( argv[i][0] == '-' ) {
			switch ( argv[i][1] ) {
			case 'm':
				model_name_flag = 1;
				if ( ++i > argc ) {
					printf("invalid argment\n");
					return 1;
				}
				strcpy(model_name, argv[i]);
				break;
			}
		}
	}

	if ( model_name_flag ) {
		printf("reading system configuration data\n");
		read_config(MC_SYS_CONFIG, &sys_conf);
		printf("original data: version = %04x, model name = \"%s\"\n", sys_conf.version, sys_conf.model_name);
		printf("writing system configuration data\n");
		strcpy(sys_conf.model_name, model_name);
		write_config(MC_SYS_CONFIG, &sys_conf);
		printf("re-reading data again\n");
		read_config(MC_SYS_CONFIG, &sys_conf);
		printf("version = %04x, model name = \"%s\"\n", sys_conf.version, sys_conf.model_name);
	} else {
		printf("reading system configuration data\n");
		read_config(MC_SYS_CONFIG, &sys_conf);
		printf("version = %04x, model name = \"%s\"\n", sys_conf.version, sys_conf.model_name);
	}

	return 0;
}

