/********************************************************************************
*
*	Copyright (c) 2002  Magic Control Technology Co.  All Rights Reserved.
*
*	FILE:
*		user.c
*
*	Abstract:
*		 user & group management function
*		
*	History:
*		2002/4/7	Louis Tsai Created
*********************************************************************************/
#include "libconf.h"

int m_namecmp(const void *a,const void *b)
{
	USER_INFO *aa,*bb;
	
	aa = (USER_INFO *) a;
	bb = (USER_INFO *) b;
	if(strcmp(aa,"")!=0 && strcmp(bb,"")!=0) 	
		return (strcmp(aa->name,bb->name));
	else
	if(strcmp(aa,"")==0 && strcmp(bb,"")!=0) 	
		return -1;
	else
	if(strcmp(aa,"")!=0 && strcmp(bb,"")==0)
		return 1;
	else
		return 0;
}


int User_Add_To_System(char *username,char *passwd,char *group, unsigned char ip_offset)
{
	REG_USER_CONF user_conf;
	int i;
	
	Config_Read(MC_USER_CONFIG,&user_conf);
//printf("count = %d\n",user_conf.count);
	for(i=0;i<user_conf.count;i++) {
		if(strcasecmp(user_conf.user[i].name,username) == 0 )
			return ERR_DUPLICATED_USER;		
	}
	
	if(user_conf.count+1 <= MAX_USER_NUM ) {
		strncpy(user_conf.user[user_conf.count].name,username,USER_NAME_LEN);
		strncpy(user_conf.user[user_conf.count].passwd,passwd,USER_PASSWD_LEN);
		user_conf.user[user_conf.count].pptp_ip_offset = ip_offset;
		//strncpy(user_conf.user[user_conf.count].groupname,group,GROUP_NAME_LEN);
		user_conf.count++;
		
		qsort((void*)user_conf.user,user_conf.count,sizeof(USER_INFO),m_namecmp);
		
		Config_Write(MC_USER_CONFIG,&user_conf);
		return SUCCESS;
	}
	else	// over the maximun of user numbers
		return ERR_OVERFLOW;
}

int User_Remove_From_System(char *username)
{
	REG_USER_CONF user_conf;
	int i,found = 0;
	
	Config_Read(MC_USER_CONFIG,&user_conf);
	for(i=0;i<user_conf.count;i++) {
		if(strcasecmp(user_conf.user[i].name,username) == 0 ) {
			found = 1;
			continue;	
		}
		
		if(found == 1 ) 
			user_conf.user[i-1] = user_conf.user[i] ;
	}
	
	if(found == 1 ) {
		user_conf.count--;
		Config_Write(MC_USER_CONFIG,&user_conf);
		return SUCCESS;
	}
	else
		return ERR_NOT_FOUND;
}

int User_Get_All_Info(REG_USER_CONF *user_conf)
{
	Config_Read(MC_USER_CONFIG,user_conf);
	
	return user_conf->count;
}

int User_Change_Passwd(char *username,char *passwd,unsigned char ip_offset)
{
	REG_USER_CONF user_conf;
	int i,found = 0;
	
	Config_Read(MC_USER_CONFIG,&user_conf);
	for(i=0;i<user_conf.count;i++) {
		if(strcasecmp(user_conf.user[i].name,username) == 0 ) {
			strncpy(user_conf.user[i].passwd,passwd,USER_PASSWD_LEN);
			user_conf.user[i].pptp_ip_offset = ip_offset;
			found = 1;
			break;
		}
	}
	
	if(found == 1 ) {
		Config_Write(MC_USER_CONFIG,&user_conf);
		return SUCCESS;
	}
	else
		return ERR_NOT_FOUND;
}

int Group_Add_To_System(char *grpname);
int Group_Remove_From_System(char *grpname);
int User_Add_To_Group(char *username,char *grpname);
int User_Remove_From_Group(char *username,char *grpname);
