/********************************************************************************
*
*	Copyright (c) 2002  Magic Control Technology Co.  All Rights Reserved.
*
*	FILE:
*		vpn.c
*
*	Abstract:
*		 vpn configuration function
*		
*	History:
*		2002/1/29	Louis Tsai Created
*********************************************************************************/
#include "libconf.h"

BOOL IPSEC_Is_Enable(void)
{
	REG_IPSEC_CONF ipsecconf;
	
	Config_Read(MC_IPSEC_CONFIG, &ipsecconf);
	return ipsecconf.enable;
}

// create /etc/ipsec.conf & /etc/ipsec.secrets

int IPSEC_Create_Setup_File(void)
{
	REG_IPSEC_CONF ipsecconf;
	NIC_INFO wan_info;
	REG_NET_CONF netconf;
	int i;
	FILE *fp;
		
	// create /etc/ipsec.secrets	
	Config_Read(MC_IPSEC_CONFIG, &ipsecconf);
	
	
	if( NIC_Get_WAN_Info(&wan_info) != SUCCESS )
		return FAILED;
	
	Config_Read(MC_NET_CONFIG, &netconf);
	
	if((fp=fopen(IPSEC_SECRET_PATH,"w")) == NULL )
		return FAILED;
		
	for(i=0;i<ipsecconf.conn_count;i++) {
		switch(ipsecconf.conn[i].remote_type) {
		case IPSEC_REMOTE_FIXEDIP:
			if(netconf.public_if == PUBIF_FIXED)
				fprintf(fp,"%s %s : PSK \"%s\"\n",wan_info.ipaddr,webip2str(ipsecconf.conn[i].remote_gw),ipsecconf.conn[i].secret_key);
			else
				fprintf(fp,"@%s %s : PSK \"%s\"\n",ipsecconf.host_id,webip2str(ipsecconf.conn[i].remote_gw),ipsecconf.conn[i].secret_key);
			break;
		case IPSEC_REMOTE_DYNAMICIP:
		case IPSEC_REMOTE_CLIENT:
			if(netconf.public_if == PUBIF_FIXED)
				fprintf(fp,"@%s %s : PSK \"%s\"\n",ipsecconf.conn[i].remote_id,wan_info.ipaddr,ipsecconf.conn[i].secret_key);
			else
				fprintf(fp,"@%s @%s : PSK \"%s\"\n",ipsecconf.host_id,ipsecconf.conn[i].remote_id,ipsecconf.conn[i].secret_key);
			break;
		}
	}
	fclose(fp);
	
	// create /etc/ipsec.conf
	if((fp=fopen(IPSEC_CONF_PATH,"w")) == NULL )
		return FAILED;
		
	fprintf(fp,"# basic configuration\nconfig setup\n");
	fprintf(fp,"\tinterfaces=%%defaultroute\n");
	fprintf(fp,"\tklipsdebug=none\n\tplutodebug=none\n");
	fprintf(fp,"\tplutoload=%%search\n\tplutostart=%%search\n");
	fprintf(fp,"\tuniqueids=yes\n\n\n");
	
	fprintf(fp,"conn %%default\n");
	fprintf(fp,"\tkeyingtries=1\n\tdisablearrivalcheck=no\n\tauthby=secret\n\n\n");
	
	for(i=0;i<ipsecconf.conn_count;i++) {
		/* the conflicting setting, remote subnet = local subnet */
		if( (netconf.private_ip&netconf.private_netmask) == (ipsecconf.conn[i].remote_subnet & ipsecconf.conn[i].remote_nm)) {
		/* 	EVENTLOG_ENTRY  	log;
			log.level 	= LEVEL_WARNING;
			log.msgid 	= IDS_IPSEC_CONFLICTING_SETTING;
			log.u.vpn_conn_id = i;
        		write_config(MC_EVENTLOG_ADD, &log);			
        	*/
        		Add_Logs(LEVEL_WARNING,IDS_IPSEC_CONFLICTING_SETTING,(void*)&i);
			continue;	
		}
		
		fprintf(fp,"conn %s\n",ipsecconf.conn[i].name);
		fprintf(fp,"\tleft=%%defaultroute\n");
		
		if(netconf.public_if != PUBIF_FIXED)
			fprintf(fp,"\tleftid=@%s\n",ipsecconf.host_id);
		
		fprintf(fp,"\tleftsubnet=%s/%s\n",webip2str(netconf.private_ip),webip2str(netconf.private_netmask));
		if(ipsecconf.conn[i].keylife > 0)
			fprintf(fp,"\tkeylife=%dh\n",ipsecconf.conn[i].keylife);
		switch(ipsecconf.conn[i].remote_type) {
		case IPSEC_REMOTE_FIXEDIP:
			fprintf(fp,"\tright=%s\n",webip2str(ipsecconf.conn[i].remote_gw));
			fprintf(fp,"\trightsubnet=%s/%s\n",webip2str(ipsecconf.conn[i].remote_subnet),webip2str(ipsecconf.conn[i].remote_nm));
			if(ipsecconf.conn[i].bootup) 
				fprintf(fp,"\tauto=start\n");
			else
				fprintf(fp,"\tauto=add\n");
			break;
		case IPSEC_REMOTE_DYNAMICIP:
			fprintf(fp,"\tright=%%any\n");
			fprintf(fp,"\trightid=@%s\n",ipsecconf.conn[i].remote_id);
			fprintf(fp,"\trightsubnet=%s/%s\n",webip2str(ipsecconf.conn[i].remote_subnet),webip2str(ipsecconf.conn[i].remote_nm));
			fprintf(fp,"\tauto=add\n");
			break;
			
		case IPSEC_REMOTE_CLIENT:
			fprintf(fp,"\tleftid=@%s\n",ipsecconf.host_id);
			fprintf(fp,"\tright=%%any\n");
			fprintf(fp,"\trightid=@%s\n",ipsecconf.conn[i].remote_id);
			fprintf(fp,"\tauto=add\n");
			break;
		}
		
	}
	
	fclose(fp);
	
	return SUCCESS;
}

int IPSEC_Start_Connection(char *conn_name)
{
	char cmd_line[128];
	
	sprintf(cmd_line,"%s auto --down %s",IPSEC_APP_PATH,conn_name);
	system(cmd_line);
	sprintf(cmd_line,"%s auto --up %s",IPSEC_APP_PATH,conn_name);
	system(cmd_line);
	
	return SUCCESS;
}

int IPSEC_Stop_Connection(char *conn_name)
{
	char cmd_line[128];
	
	sprintf(cmd_line,"%s auto --down %s",IPSEC_APP_PATH,conn_name);
	system(cmd_line);
	
	return SUCCESS;	
}

int IPSEC_Update_Secrets()
{
	char cmd_line[128];
	
	sprintf(cmd_line,"%s auto --rereadsecrets",IPSEC_APP_PATH);
	system(cmd_line);
	
	
	return SUCCESS;
}

int IPSEC_Add_Connection(char *conn_name)
{
	char cmd_line[128];
	
	sprintf(cmd_line,"%s auto --add %s",IPSEC_APP_PATH,conn_name);
	system(cmd_line);
	
	return SUCCESS;
}

int IPSEC_Del_Connection(char *conn_name)
{
	char cmd_line[128];
	
	sprintf(cmd_line,"%s auto --delete %s",IPSEC_APP_PATH,conn_name);
	system(cmd_line);
	
	return SUCCESS;
}

int IPSEC_Modified_Connection(char *conn_name)
{
	char cmd_line[128];
	
	sprintf(cmd_line,"%s auto --replace %s",IPSEC_APP_PATH,conn_name);
	system(cmd_line);
	
	return SUCCESS;
}

//------------------------------------------------//
//Because freeswan didn't provide the tool to detect
//the connection status, and we only can know the 
//current ipsec routing table from /proc/net/ipsec_eroute
//. It just guess which connection is alive, becuase
// while the other end break the connection, we cannot
// find any change from /proc/net/ipsec_eroute
//------------------------------------------------//

BOOL IPSEC_Is_Connection_Alive(char *conn_name)
{
	char		str[256];
        FILE		*fptr;
	char		seps[] = " \t\n";
	char		*token,*token1;
	char		ipsec_route_file[]={"/proc/net/ipsec_eroute"};
	REG_IPSEC_CONF 	ipsecconf;
	char		conn_dst_subnet[20];
	int		i=0;
	BOOL		alive_flag = FALSE;
	
	Config_Read(MC_IPSEC_CONFIG, &ipsecconf);
	// find the destination subnet for input conn
	strcpy(conn_dst_subnet,"");
	for(i=0;i<ipsecconf.conn_count;i++) {
		if(strcmp(ipsecconf.conn[i].name,conn_name) == 0 ) {
			__u32 dstbinip;
			struct in_addr in;
			switch(ipsecconf.conn[i].remote_type) {
			case IPSEC_REMOTE_FIXEDIP:
			case IPSEC_REMOTE_DYNAMICIP:
				dstbinip = inet_addr(webip2str(ipsecconf.conn[i].remote_subnet));
				dstbinip = dstbinip & inet_addr(webip2str(ipsecconf.conn[i].remote_nm)) ;
				in.s_addr = dstbinip;
				strncpy(conn_dst_subnet,(char *)inet_ntoa(in),NIC_IPADDR_LEN);
				break;
			case IPSEC_REMOTE_CLIENT:
				// cannot know the vpn client ip
				break;
			}
		}
	}
	
	fptr=fopen(ipsec_route_file, "r");
	
	while (fgets(str, 256, fptr) != NULL)
	{
                if(strstr(str,"trap") != NULL)
                	continue;
                token = strtok(str, seps);
                if(token == NULL)
                        continue;
                token = strtok(NULL, seps);
                token = strtok(NULL, seps);
                token = strtok(NULL, seps);

                token1= strtok(token,"/");
                
//printf("%s %s conn=%s\n",token,token1,conn_dst_subnet);
        	if(strcasecmp(token1,conn_dst_subnet) == 0) {
        		alive_flag = TRUE;
        		break;
        	}
        	else
        		continue;      
        }
        
        fclose(fptr);
	return alive_flag;	
}

////////////////////////////////////////////////////////////////////////////////
//
//		PPTP Configuration function
//
////////////////////////////////////////////////////////////////////////////////
BOOL PPTP_Is_Enable(void)
{
	REG_PPTP_CONF conf;
	
	Config_Read(MC_PPTP_CONFIG,&conf);
	return conf.enable;
}

//-------------------------------------------------//
// updated /etc/ppp/chap-secrets & /etc/pptpd.conf //
//-------------------------------------------------//
//#ifndef SG600
#if !defined(SG600) && !defined(CONFIG_ONLY_NAS)
int PPTP_Create_Setup_File(void)
{
	FILE *fp;
	REG_NET_CONF net;
	char pptp_local_ip[NIC_IPADDR_LEN];
	struct in_addr in;
	REG_USER_CONF user_conf;
	REG_PPTP_CONF pconf;
	unsigned char ip0,ip1,ip2;
	int i;
	
	if( Config_Read(MC_NET_CONFIG,(void *)&net) != 0 )
		return ERR_READ_CONFIG;
	
	User_Get_All_Info(&user_conf);
	Config_Read(MC_PPTP_CONFIG, &pconf);
	
	ip0 = (net.private_ip & 0xff);
	ip1 = (net.private_ip >> 8 ) & 0xff;
	ip2 = (net.private_ip >>16 ) & 0xff;
	
	sprintf(pptp_local_ip,"%d.%d.%d.%d",ip0,ip1,ip2,pconf.serverip);
	
	//Create /etc/pptpd.conf
	fp = fopen(PPTPD_CONF_PATH,"w");
	fprintf(fp,"speed 115200\n");
	fprintf(fp,"localip %s\n",pptp_local_ip);
	
	fprintf(fp,"remoteip %d.%d.%d.%d-%d\n",ip0,ip1,ip2,pconf.startip,pconf.endip);
	fclose(fp);
	
	//Create /etc/ppp/options
	fp = fopen(PPP_OPTIONS_PATH,"w");
	fprintf(fp,"debug\n");
	fprintf(fp,"name %s\n",net.hostname);
	fprintf(fp,"auth\n");
	fprintf(fp,"require-chap\n");
	fprintf(fp,"proxyarp\n");
	fprintf(fp,"+chapms\n");
	fprintf(fp,"+chapms-v2\n");
	fprintf(fp,"mppe-40\n");
	fprintf(fp,"mppe-128\n");
	fprintf(fp,"mppe-stateless\n");
	
	if(net.dns0) 
		fprintf(fp,"ms-dns %s\n",webip2str(net.dns0));
	
	fclose(fp);	
	//Create /etc/ppp/chap-secrests
	
	fp = fopen(PPPOE_CHAP_PATH,"w");
	
	for(i=0;i<user_conf.count;i++) {
		if(!user_conf.user[i].pptp_ip_offset)
			fprintf(fp,"\"%s\"	*	%s	*\n",user_conf.user[i].name,user_conf.user[i].passwd);
		else
			fprintf(fp,"\"%s\"	*	%s	%d.%d.%d.%d\n",user_conf.user[i].name,
									       user_conf.user[i].passwd,
							       		       ip0,ip1,ip2,user_conf.user[i].pptp_ip_offset);
	}
	fclose(fp);
	return SUCCESS;	
}
#else
int PPTP_Create_Setup_File(void)
{
	LA_USER_DATA users[LA_MAX_USERS];
	int i,usr_cnt=0;
	FILE *fp;
	REG_NET_CONF net;
	char pptp_local_ip[NIC_IPADDR_LEN];
	struct in_addr in;
	REG_PPTP_CONF pconf;
	unsigned char ip0,ip1,ip2;
	
	if( Config_Read(MC_NET_CONFIG,(void *)&net) != 0 )
		return ERR_READ_CONFIG;
	
	Config_Read(MC_PPTP_CONFIG, &pconf);
	
	ip0 = (net.private_ip & 0xff);
	ip1 = (net.private_ip >> 8 ) & 0xff;
	ip2 = (net.private_ip >>16 ) & 0xff;
	
	sprintf(pptp_local_ip,"%d.%d.%d.%d",ip0,ip1,ip2,pconf.serverip);
	
	//Create /etc/pptpd.conf
	fp = fopen(PPTPD_CONF_PATH,"w");
	fprintf(fp,"speed 115200\n");
	fprintf(fp,"localip %s\n",pptp_local_ip);
	
	fprintf(fp,"remoteip %d.%d.%d.%d-%d\n",ip0,ip1,ip2,pconf.startip,pconf.endip);
	fclose(fp);
	
	//Create /etc/ppp/options
	fp = fopen(PPP_OPTIONS_PATH,"w");
	fprintf(fp,"debug\n");
	fprintf(fp,"name %s\n",net.hostname);
	fprintf(fp,"auth\n");
	fprintf(fp,"require-chap\n");
	fprintf(fp,"proxyarp\n");
	fprintf(fp,"+chapms\n");
	fprintf(fp,"+chapms-v2\n");
	fprintf(fp,"mppe-40\n");
	fprintf(fp,"mppe-128\n");
	fprintf(fp,"mppe-stateless\n");
	
	if(net.dns0) 
		fprintf(fp,"ms-dns %s\n",webip2str(net.dns0));
	
	fclose(fp);	
	
	//Create /etc/ppp/chap-secrests
	if((usr_cnt=PPTP_Get_User_List(users,LA_MAX_USERS)) <0 ) return FAILED;
	
	fp = fopen(PPPOE_CHAP_PATH,"w");
	
	for(i=0;i<usr_cnt;i++) 
		fprintf(fp,"\"%s\"	*	%s	*\n",users[i].name,users[i].password);
		
	fclose(fp);
	return SUCCESS;	
}
int PPTP_Get_User_List(LA_USER_DATA *userlist,int list_cnt)
{
	LA_USERS userconf;
	int i=0,j=0,user_cnt=0;
	unsigned int bit_value=0,pptp_ok=0;
	
	Config_Read(MC_USER,&userconf);
	if(userlist == NULL ) return FAILED; 
	
	for(i=0;i<LA_MAX_USERS/32;i++) {
		if(userconf.bitstr[i] == 0 ) continue;
		if(userconf.pptp_on[i] == 0 ) continue;
		for(j=0;j<32;j++) {
			bit_value = ( userconf.bitstr[i] >> j ) & 0x00000001 ; 
			pptp_ok	  = ( userconf.pptp_on[i]>> j ) & 0x00000001 ; 
			if(bit_value && pptp_ok) {
				*(userlist+user_cnt) = userconf.usrdata[i*32+j];
				user_cnt++;
				
			}
		}
	}
	return user_cnt;	
	
	
	
}
//int PPTP_Add_User(char *username);
//int PPTP_Remove_User(char username);
//int PPTP_Add_Group(char *grpname);
//int PPTP_Remove_Group(char *grpname);
#endif 
