/********************************************************************************
*
*	Copyright (c) 2003  Magic Control Technology Co.  All Rights Reserved.
*
*	FILE:
*		hotplug.c
*
*	Abstract: 
*		usb hotplug configuration
*
*	HISTORY:
*		2003/6/3	Louis Tsai Created
*********************************************************************************/

#include <stdio.h>
#include <string.h>
#include "libconf.h"
#include "hd_ctl.h"


static int check_share_exist(char *name)
{
	LA_SHARES shares_info;
	int i;
	
	Config_Read(MC_SHARE,&shares_info);		
	
	for(i=0;i<shares_info.count;i++) {
		if(!strcasecmp(shares_info.shadata[i].name,name))
			return 1;
	}
	return 0;
}

static void add_share_folder(char *name) 
{
	
	LA_SHARES shares_info;
	int i;
	
	Config_Read(MC_SHARE,&shares_info);		
	
	for(i=0;i<shares_info.count;i++) {
		if(!strcasecmp(shares_info.shadata[i].name,name))
			return;
	}
	
	strcpy(shares_info.shadata[shares_info.count].name,name);
	bitstr_mask(shares_info.shadata[shares_info.count].w_grps,0);  // add writing privilege for everyone
	shares_info.count++;
	if(!shares_info.cifs_enable) {
		shares_info.cifs_enable = 1;
		strcpy(shares_info.workgrp_name,"WORKGROUP");
		strcpy(shares_info.computer_des,"NAS");
	}
	
	Config_Write(MC_SHARE,&shares_info);
	Shares_Updated_Conf_File();
}

static int check_hd_in_partable(char *name)
{
	FILE *tmpfp;
	//check usb attached hd
	// step 1: scan current partition table
	system("/bin/cat /proc/partitions > /tmp/part.tmp");
	if((tmpfp=fopen("/tmp/part.tmp","r"))!=NULL) {
		char tmpline[80],parname[30];
		int major_num,minor_num;
		unsigned long blocks_num;
		fgets(tmpline,80,tmpfp);
		fgets(tmpline,80,tmpfp);
		while(fgets(tmpline,80,tmpfp)!=NULL) {
			sscanf(tmpline,"%d %d %ld %s",&major_num,&minor_num,&blocks_num,parname);
			if(major_num == 8) {
				if(strlen(parname)==3) {
					char mtname[80];
					sprintf(mtname,"USBHD%c",'A'+minor_num/16);
					if (!strncmp(mtname,name,6)) 
					{	
						fclose(tmpfp);	
						unlink("/tmp/part.tmp");
						return 1;
					}
				}
			}
		}
		fclose(tmpfp);	
		unlink("/tmp/part.tmp");
	}
	return 0;
}

static void add_usbhd_share_folder()
{
	FILE *tmpfp;
	//check usb attached hd
	// step 1: scan current partition table
	system("/bin/cat /proc/partitions > /tmp/part.tmp");
	if((tmpfp=fopen("/tmp/part.tmp","r"))!=NULL) {
		char tmpline[80],parname[30];
		int major_num=0,minor_num=0,thumb_usb_storage=0,first_line=1;
		unsigned long blocks_num=0,total_blocks=0;
		fgets(tmpline,80,tmpfp);
		fgets(tmpline,80,tmpfp);
		while(fgets(tmpline,80,tmpfp)!=NULL) {
			sscanf(tmpline,"%d %d %ld %s",&major_num,&minor_num,&blocks_num,parname);
			
			
			if(major_num == 8) {
				if(strlen(parname)==3) {
					if(thumb_usb_storage && !first_line) {
						char cmdline[200];
						sprintf(cmdline,"USBHD%c",'A'+minor_num/16);
						if(check_share_exist(cmdline)) continue;
sprintf(tmpline,"/bin/echo \"%d %d %ld %s\" >>/tmp/test2",major_num,minor_num,blocks_num,parname);
system(tmpline);
						sprintf(cmdline,"/bin/mkdir -p /mnt/USBHD%c",'A'+minor_num/16);
						system(cmdline);
						sprintf(cmdline,"/bin/mount -t vfat -o sync -o uid=0 -o gid=0 -o umask=000 /dev/sd%c /mnt/USBHD%c",'a'+minor_num/16,'A'+minor_num/16);	
						if(!system(cmdline)) {
							sprintf(cmdline,"USBHD%c",'A'+minor_num/16);
	   						add_share_folder(cmdline);
						}	
						thumb_usb_storage = 0;
					}
					total_blocks = blocks_num;
					first_line=0;
				}
				else if(!thumb_usb_storage){
					if(blocks_num>total_blocks) thumb_usb_storage=1;
					else {
						char cmdline[200];
						sprintf(cmdline,"USBHD%c%d",'A'+minor_num/16,'A'+minor_num%16);
						if(check_share_exist(cmdline)) continue;
sprintf(tmpline,"/bin/echo \"%d %d %ld %s\" >>/tmp/test2",major_num,minor_num,blocks_num,parname);
system(tmpline);
						sprintf(cmdline,"/bin/mkdir -p /mnt/USBHD%c%d",'A'+minor_num/16,minor_num%16);
						system(cmdline);
						sprintf(cmdline,"/bin/mount -t vfat -o sync -o uid=0 -o gid=0 -o umask=000 /dev/sd%c%d /mnt/USBHD%c%d",'a'+minor_num/16,minor_num%16,'A'+minor_num/16,minor_num%16);	
						if(!system(cmdline)) {
							sprintf(cmdline,"USBHD%c%d",'A'+minor_num/16,minor_num%16);
	   						add_share_folder(cmdline);
						}	
					}
				}
			}
		}
		fclose(tmpfp);	
		unlink("/tmp/part.tmp");
	}	
}

static void remove_usbhd_share_folder()
{
	LA_SHARES shares_info;
	char cmdline[80];
	int j=0;
	Config_Read(MC_SHARE,&shares_info);
	for(j=0;j<shares_info.count;j++) {
		if(!strncmp("USBHD",shares_info.shadata[j].name,5) && !check_hd_in_partable(shares_info.shadata[j].name)) {
			mct_killall("sguard",16);
//			sleep(2);
//			system("killall -16 sguard");
				
			shares_info.shadata[j] = shares_info.shadata[shares_info.count-1];
			shares_info.count--;
			break;
		}
	}
	Config_Write(MC_SHARE,&shares_info);
	Shares_Updated_Conf_File();
	
}

int main(int argc,char **argv)
{

	if(argc>1 && !strcmp(argv[1],"usb")) {
		if(!strcmp(getenv("CLASS"),"7")){	// 7 : printer class , 8 : mass storage . 
			Shares_Updated_Conf_File();
		}
		else if(!strcmp(getenv("CLASS"),"8") && !strcmp(getenv("ACTION"),"add")) {
			add_usbhd_share_folder();
		}
		else if(!strcmp(getenv("CLASS"),"8") && !strcmp(getenv("ACTION"),"remove"))
			remove_usbhd_share_folder();
	}
	else if(argc>1 && !strcmp(argv[1],"killall")) {
//		system("/bin/killall -9 smbd nmbd bftpd atalkd afpd nfsd");
		mct_killall("smbd",9);
		mct_killall("nmbd",9);
		mct_killall("bftpd",9);
		mct_killall("atalkd",9);
		mct_killall("afpd",9);
		mct_killall("nfsd",9);
	}
	else  if(argc>1 && !strcmp(argv[1],"4portusb")) {
		if(!strcmp(argv[2],"usb_addstor")) 
			add_usbhd_share_folder();
		else 
		if(!strcmp(argv[2],"usb_rmstor")) 
			remove_usbhd_share_folder();
	}
}       


