/********************************************************************************
*
*	Copyright (c) 2002  Magic Control Technology Co.  All Rights Reserved.
*
*	FILE:
*		getcfg.c
*
*	Abstract: 
*		get config data
*
*	HISTORY:
*		2002/3/7	Louis Tsai Created
*********************************************************************************/

#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>
#include <netinet/in.h>
#include <netinet/ether.h>
#include <net/if.h>
#include <net/ethernet.h>
#include <linux/sockios.h>
#include <netinet/in.h>
#include <netinet/ip_icmp.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <linux/ethtool.h>
#include "libconf.h"

static const int DEFDATALEN = 56;
static const int MAXIPLEN = 60;
static const int MAXICMPLEN = 76;


void got_sg(int sig)
{
	system("/etc/rc.d/init.d/S50smbd start");	
	system("/etc/rc.d/init.d/S51atalk start");	
	system("/etc/rc.d/init.d/S52nfsd start");	
	system("/etc/rc.d/init.d/S53ftpd start");
	system("/etc/rc.d/init.d/S90maild restart");
	system("/etc/rc.d/init.d/S91w3s restart");
}

#ifdef NAS
/*it's not a good way to implement hotplug behavior, but the tx49xx will crash 
when call call_usermodehelper() function, louistsai 2004/10/28 */
void tx49_hotplug(int sig)
{
	Shares_Updated_Conf_File();
}

void tx49_usb_addstor(int sig)
{
	system("/sbin/hotplug 4portusb usb_addstor");
	
}

void tx49_usb_rmstor(int sig)
{
	system("/sbin/hotplug 4portusb usb_rmstor");
}
#endif

int get_default_gw(unsigned long *hostip)
{
	char buff[256];
	int flgs, ref, use, metric;
	char flags[4];
	unsigned long int d,g,m;
	char ifs[6];
	
	FILE *fp = fopen("/proc/net/route", "r");

	while( fgets(buff, sizeof(buff), fp) != NULL ) {
		if(sscanf(buff, "%s%lx%lx%d%d%d%d%lx",ifs,&d, &g, &flgs, &ref, &use, &metric, &m)!=8) continue;
		if((strcasecmp(ifs,"eth0") == 0) && (flgs & 0x2) && !d ) {
			*hostip = g;
			fclose(fp);
			return 1;
		}
	}			
	fclose(fp);
	return 0;
}

int in_cksum(unsigned short *buf, int sz)
{
	int nleft = sz;
	int sum = 0;
	unsigned short *w = buf;
	unsigned short ans = 0;

	while (nleft > 1) {
		sum += *w++;
		nleft -= 2;
	}

	if (nleft == 1) {
		*(unsigned char *) (&ans) = *(unsigned char *) w;
		sum += ans;
	}

	sum = (sum >> 16) + (sum & 0xFFFF);
	sum += (sum >> 16);
	ans = ~sum;
	return (ans);
}

int linksts(void)
{
	int	fd;
	struct ifreq	ifr;
	struct ether_info ethinfo;
	
	
	fd = socket(AF_INET, SOCK_DGRAM, 0);
	strcpy(ifr.ifr_name, "eth0");
	ethinfo.cmd = ETHTOOL_GINFO;
	ifr.ifr_data = (char *) &ethinfo;
	ioctl(fd, SIOCETHTOOL, &ifr);
	
	return ethinfo.linkup;
	
}
int ping(void)
{
	struct hostent *h;
	struct sockaddr_in pingaddr;
	struct icmp *pkt;
	int pingsock, c, i;
	char packet[DEFDATALEN + MAXIPLEN + MAXICMPLEN];
	struct sockaddr_in from;
	size_t fromlen = sizeof(from);
	unsigned long hostip;
	
	if(!get_default_gw(&hostip)) return 0;
	if ((pingsock = socket(AF_INET, SOCK_RAW, 1)) < 0) {	/* 1 == ICMP */
		printf("creating a raw socket");
		return 0;
	}
	/* drop root privs if running setuid */
	
	fcntl(pingsock, F_SETFL, O_NONBLOCK);
	memset(&pingaddr, 0, sizeof(struct sockaddr_in));

	pingaddr.sin_family = AF_INET;
	pingaddr.sin_addr.s_addr = hostip;
	//memcpy(&pingaddr.sin_addr, h->h_addr, sizeof(pingaddr.sin_addr));
	
//printf("pingaddr.sin_addr.s_addr = %x\n",pingaddr.sin_addr.s_addr);
	for(i=0;i<3;i++) {
		pkt = (struct icmp *) packet;
		memset(pkt, 0, sizeof(packet));
		pkt->icmp_type = ICMP_ECHO;
		pkt->icmp_cksum = in_cksum((unsigned short *) pkt, sizeof(packet));
	
		c = sendto(pingsock, packet, sizeof(packet), 0,
				   (struct sockaddr *) &pingaddr, sizeof(struct sockaddr_in));

		if (c < 0 || c != sizeof(packet)) continue;
		sleep(2);
		c = recvfrom(pingsock, packet, sizeof(packet), 0, (struct sockaddr *) &from, &fromlen);
		
		if (c < 0) continue;	
		if (c >= 76) {			/* ip + icmp */
			struct iphdr *iphdr = (struct iphdr *) packet;
			pkt = (struct icmp *) (packet + (iphdr->ihl << 2));	/* skip ip hdr */
			if (pkt->icmp_type == ICMP_ECHOREPLY) {
				close(pingsock);
				return 1;
			}
		}
	}
	close(pingsock);
	return 0;
}


int main(int argc,char **argv)
{
	struct ifreq    ifr;
        REG_NET_CONF    netconf;
	unsigned long   ipaddr;
	int fd, done_flag = 0;
	
	(void) signal(SIGUSR1,got_sg);
#ifdef NAS
	(void) signal(SIGUSR2,tx49_hotplug);
	(void) signal(100, tx49_usb_addstor);
	(void) signal(101, tx49_usb_rmstor);
#endif
	Config_Read(MC_NET_CONFIG, &netconf);
	fd = socket(AF_INET, SOCK_DGRAM, 0);
	while(1) {
//printf("enter check loop\n");
		if(netconf.public_if != PUBIF_DHCPC) {
			sleep(30);
			continue;
		}
		strcpy(ifr.ifr_name, "eth0");	
		if ( ioctl(fd, SIOCGIFADDR, &ifr) < 0 ){
			sleep(30);
			continue;
		}
        	else {
	                ipaddr = ((struct sockaddr_in *) &ifr.ifr_addr)->sin_addr.s_addr;
			//check the wan interface is 169.254.x.x (zeroconf)
			if(((ipaddr & 0xff) == 0xa9) && ((ipaddr>>8 & 0xff) == 0xfe)) {
//printf("wan ip is 169.254.x.x\n");
				system("/sbin/dhcpcd");
#ifdef CONFIG_BPA
				system("killall -9 bpalogin");
				system("/sbin/bpalogin -c /etc/bpalogin.conf");
#endif
				done_flag = 1;	
			}
			else {
				if(done_flag) {
//printf("restart related app\n");
					done_flag = 0;
					system("/etc/rc.d/init.d/S20ddns restart");
               				system("/etc/rc.d/init.d/S21httpd restart");
               				system("/etc/rc.d/init.d/S50smbd restart");
               				system("/etc/rc.d/init.d/S52nfsd restart");
               				system("/etc/rc.d/init.d/S53ftpd restart");
               				system("/etc/rc.d/init.d/S90maild restart");
               				system("/etc/rc.d/init.d/S93Rendezvous restart");
               				system("/etc/rc.d/init.d/S91w3s restart");
				}
				if(!linksts()) {
//				if(!ping()) {
//printf("ping the default router failed\n");
					system("/bin/killall AVH-IPv4LL");
					system("/sbin/AVH-IPv4LL -s /etc/ipv4ll.script");
					system("/bin/killall AVH-IPv4LL");
					system("killall -16 dhcpcd");
					done_flag = 1;
				}	
			}
		}
		sleep(30);
	}
	close(fd);
	return 0;
}       


