#ifndef __SYSREPD_H__
#define __SYSREPD_H__

// The general request format is "Command [Sub-Command] End-Of-Command".
// The relpy format is "Command [Sub-Command] Message End-Of-Command".
// Each item contains only one byte except the "Message."
// 
// C: CMD_SYSTEM_TIME		EOC
// S: CMD_SYSTEM_TIME		(CHARACTER)+	EOC
// C: CMD_UPDATE_PERCENTAGE	EOC
// S: CMD_UPDATE_PERCENTAGE	PERCENTAGE	EOC

// define the state number of state machine.
#define STATE_UNKNOWN		0xff
#define STATE_INIT		0
#define STATE_SYSTEM_TIME	4
#define STATE_UPDATE_PERCENTAGE	5

// define command code
#define CMD_SYNC		0
#define CMD_SYSTEM_TIME		4
#define CMD_UPDATE_PERCENTAGE	5
#define CMD_UNKNOWN		127

#define END_OF_COMMAND		0
#define ESCAPE_CHAR		27

#define SERVER_PORT		5300

#endif	// __SYSREPD_H__

