/*
* Configuration access system call
*/

#include <linux/linkage.h>
#include <asm/errno.h>
#include <asm/mconfig.h>
#include <asm/io.h>
#include <linux/mctlog.h>
#include <linux/string.h>

asmlinkage int sys_read_config(int type, unsigned long *val)
{
	*val = inl(0x1e000000);
return 0;
}

/*asmlinkage int sys_read_config(int type, MLINUX_CONF *conf)
{
if ( !conf )
return -EFAULT;
printk("sys_nvram_read\n");
return 0;
}
*/
//asmlinkage int sys_write_config(int type, MLINUX_CONF *conf)
asmlinkage int sys_write_config(int type, unsigned long val)
{
	unsigned long adr=0x1e000004;
	unsigned long adrA,adrB,adr0,adr1,rdat,amsk,bval;
	unsigned char epd,epd2;
	int sh=1,cnt,i,wbflushtmp1;
	
//	if ( !conf )
//		return -EFAULT;
	
	sh <<= 1;
	adrA = ((adr&~(0x1ffff<<sh))|(0x5555<<sh))&0xfffffffc;
	adrB = ((adr&~(0x1ffff<<sh))|(0x2aaa<<sh))&0xfffffffc;
	amsk = 0xff;
	(unsigned char)bval = val;
	
#ifdef MIPSEB
	amsk <<= ((adr&0x3)^3)*8;
	bval = bval << ((adr&0x3)^3)*8;
#else
	amsk <<= ((adr&0x3))*8;
	bval = bval << ((adr&0x3))*8;
#endif
	rdat = (inl(adr&0xfffffffc)&~amsk);
	bval = bval | rdat;
#if 1
 	printk("flash29w: adr=%08x bval=%08x adrA=%08x adrB=%08x\n amsk=%08x rdat=%08x",adr,bval,adrA,adrB,amsk,rdat);
#endif
	outl(adrA,0xaaaaaaaa); 
	outl(adrB,0x55555555); 
	outl(adrA,0xa0a0a0a0); 
	outl(adr&0xfffffffc,bval);
	for (i=0;i<3000;i++) wbflushtmp1 = 0; /* min 100us delay */
	
	for (cnt=0;;cnt++) {
		epd = inb(adr);
		if (!((epd ^ val) & 0x80)) break; 
		if (epd&(1<<5)) {
			/* recheck DQ7: DQ7 may change simultaneously with DQ7 */
			epd = inb(adr);
			break;
		}
		if (epd != val) 
			printk("\nflash29w: ## TIMEOUT adr:%08x epd:%2x val:%02x\n",adr,epd,val);
	}

	printk("sys_nvram_write\n");
	return 0;
}

asmlinkage int sys_get_mctlog(MCT_MSGQ *msgq)
{
	int i;
	msgq->index  = mct_message_buf.index;
	for(i=0;i<MAX_MCTLOG;i++) {
		strcpy(msgq->msg[i],mct_message_buf.msg[i]);
		msgq->current_time[i] = mct_message_buf.current_time[i];	
	}
	return 0 ;
}

asmlinkage int sys_get_urllog(MCT_URLQ *urlq)
{
	int i;
	urlq->index  = mct_url_buf.index;
	for(i=0;i<MAX_URLLOG;i++) {
		strcpy(urlq->srcip[i],mct_url_buf.srcip[i]);
		strcpy(urlq->dstip[i],mct_url_buf.dstip[i]);
		urlq->current_time[i] = mct_url_buf.current_time[i];	
	}
	return 0 ;
}
