#include <linux/config.h>
#include <linux/init.h>
#include <linux/sched.h>
#include <linux/wait.h>

#if defined(CONFIG_MCT_SG100) || defined(CONFIG_MCT_SG600) || defined(CONFIG_MCT_SA100) || defined(CONFIG_MCT_SA200)
static int	speaker_on;
static struct timer_list speaker_timer;
#endif

#if defined(CONFIG_MCT_SG100)
#define CPLD_GPIO_ADDR	0xb4000400
#define	CPLD_GPIO_HBLED_BIT	0x10
#define CPLD_PASSWD_RESET_BIT	0x01

extern inline void SPK_ON()
{
	((*(volatile unsigned char*) CPLD_GPIO_ADDR) |= 0x20);
	speaker_on = 0;
}

extern inline void SPK_OFF()
{
	((*(volatile unsigned char*) CPLD_GPIO_ADDR) &= 0xdf);
	speaker_on = 1;
}

#elif defined(CONFIG_MCT_SG600) || defined(CONFIG_MCT_SA100)

#define CPU_PIODO_ADDR	0xfffef500
#define CPU_PIODI_ADDR	0xfffef504
#define CPU_GPIO_HBLED_BIT		0x00000100
#define CPU_GPIO_PASSWD_RESET_BIT	0x00000020
#define LOCALBUS_DATAIN_ADDR	0xb2000000
#define LOCALBUS_DATAIN_PASSWD_RESET_BIT 0x04

extern inline void SPK_ON(void)
{
	((*(volatile unsigned short *) CPU_PIODO_ADDR) |= 0x0400);
//marked by louistsai speaker_on = 0;  
	speaker_on = 1;
}

extern inline void SPK_OFF(void)
{	
	((*(volatile unsigned short *) CPU_PIODO_ADDR) &= 0xfbff);
//marked by louistsai	speaker_on = 1;
	speaker_on = 0;
}
	
#elif defined(CONFIG_MCT_SG4100)

#define CPU_PIODO_ADDR	0xff1ff500
#define CPU_PIODI_ADDR	0xff1ff504
#define CPU_GPIO_HBLED_BIT	0x00040000
#define CPU_GPIO_PASSWD_RESET_BIT	0x00000008

#elif defined(CONFIG_MCT_SA200)

#include<asm/tx4925.h>
#define CPU_PIODO_ADDR	0xff1ff500
#define CPU_PIODI_ADDR	0xff1ff504
#define CPU_GPIO_HBLED_BIT		0x00004000
#define CPU_GPIO_PASSWD_RESET_BIT	0x00000008
#define CPU_GPIO_SPK_BIT        	0x00100000

extern inline void SPK_ON(void)
{	
	tx4925_pioptr->dout = tx4925_pioptr->din | CPU_GPIO_SPK_BIT ;
	speaker_on = 1;
}

extern inline void SPK_OFF(void)
{	
	tx4925_pioptr->dout = tx4925_pioptr->din & ~CPU_GPIO_SPK_BIT;
	speaker_on = 0;
}

#endif

static struct timer_list hbled_timer;

static void hbled_blink(unsigned long dummy)
{
#if defined(CONFIG_MCT_SG100)
	unsigned char	val;

	val = (*(volatile unsigned short*) CPLD_GPIO_ADDR);
	val = (val & CPLD_GPIO_HBLED_BIT) ?
		(val & ~CPLD_GPIO_HBLED_BIT) : (val | CPLD_GPIO_HBLED_BIT);
	(*(volatile unsigned char*) CPLD_GPIO_ADDR) = val;
#elif defined(CONFIG_MCT_SG4100) || defined(CONFIG_MCT_SG600) || defined(CONFIG_MCT_SA100) || defined(CONFIG_MCT_SA200)
	unsigned long	val;
	
	val = *(volatile unsigned long *) CPU_PIODI_ADDR;
	val = (val & CPU_GPIO_HBLED_BIT) ?
		(val & ~CPU_GPIO_HBLED_BIT) : (val | CPU_GPIO_HBLED_BIT);
	(*(volatile unsigned long *) CPU_PIODO_ADDR) = val;

#endif
		
	init_timer(&hbled_timer);
	hbled_timer.function = hbled_blink;
	hbled_timer.expires = jiffies + HZ / 2;
	add_timer(&hbled_timer);
}

void __init hbled_init(void)
{
	init_timer(&hbled_timer);
	hbled_timer.function = hbled_blink;
	hbled_timer.expires = jiffies + HZ;
	add_timer(&hbled_timer);
}
#if defined(CONFIG_ATEN_LED)
static struct timer_list aled_timer;

#if defined(CONFIG_MCT_SG600) || defined(CONFIG_MCT_SA100) 
#define ATEN_LED		0xb4000000
static void aled_blink(unsigned long dummy)
{
	static int off_flag = 0 ,direction = 0,step = 0;
	init_timer(&aled_timer);
	aled_timer.function = aled_blink;
	
//	if(!off_flag) {
		if(!direction) {
			if(step==0) 
				*((volatile unsigned char *) ATEN_LED) = ~(0x01) ;	
			else 
				*((volatile unsigned char *) ATEN_LED) = ~(0x03 << step-1) ;
			
			if(step!=3) 
				step++;
			else 		
				direction = 1;
		}
		else {
			if(step==3) 
				*((volatile unsigned char *) ATEN_LED) = ~(0x08) ;	
			else 
				*((volatile unsigned char *) ATEN_LED) = ~(0x0c >> -(step-2)) ;
			
			if(step!=0) 
				step--;
			else 		
				direction = 0;
		}
		
		
		aled_timer.expires = jiffies + HZ / 2;
/*		off_flag = 1;
	}
	else
	{
		if(!direction) {
			if(step==0) 
				*((volatile unsigned char *) ATEN_LED) = ~(0x01) ;	
			else 
				*((volatile unsigned char *) ATEN_LED) = ~(0x02 << step-1) ;
			
		}
		else {
			if(step==3) 
				*((volatile unsigned char *) ATEN_LED) = ~(0x08) ;	
			else 
				*((volatile unsigned char *) ATEN_LED) = ~(0x04 >> -(step-2)) ;
		}
		
		aled_timer.expires = jiffies + HZ / 2;
		off_flag = 0;
	}
*/		
	
	add_timer(&aled_timer);
}

#elif defined(CONFIG_MCT_SA200)

static void aled_blink(unsigned long dummy)
{
	static int off_flag = 0 ,direction = 0,step = 0;
	init_timer(&aled_timer);
	aled_timer.function = aled_blink;
	if(!direction) {
		if(step==0) 
			tx4925_pioptr->dout = (tx4925_pioptr->din & 0x0fffffff) | (~(0x01))<<28 ;	
		else 
			tx4925_pioptr->dout = (tx4925_pioptr->din & 0x0fffffff) | (~(0x03 << step-1))<<28 ;
			
		if(step!=3) 
			step++;
		else 		
			direction = 1;
	}
	else {
		if(step==3) 
			tx4925_pioptr->dout = (tx4925_pioptr->din & 0x0fffffff) | (~(0x08))<<28 ;	
		else 
			tx4925_pioptr->dout = (tx4925_pioptr->din & 0x0fffffff) | (~(0x0c >> -(step-2))) <<28 ;
			
		if(step!=0) 
			step--;
		else 		
			direction = 0;
	}

	aled_timer.expires = jiffies + HZ/2 ;
	add_timer(&aled_timer);
}

#endif

void __init aled_init(void)
{
	printk("init aled\n");
	init_timer(&aled_timer);
	aled_timer.function = aled_blink;
	aled_timer.expires = jiffies + HZ ;
	add_timer(&aled_timer);
}

#endif



static struct timer_list	conf_reset_timer;
static int	conf_reset_detecting;
static int	conf_reset_tick_count;
extern int	conf_reset_in_progress;
extern wait_queue_head_t	flash_wq;

#if defined(CONFIG_MCT_SG100) || defined(CONFIG_MCT_SG600) || defined(CONFIG_MCT_SA100)  || defined(CONFIG_MCT_SA200)
static void speaker_callback(unsigned long dummy)
{
	if ( speaker_on ) {
		SPK_OFF();
	} else {
		SPK_ON();
	}
	init_timer(&speaker_timer);
	speaker_timer.function = speaker_callback;
	speaker_timer.expires = jiffies + HZ / 2;
	add_timer(&speaker_timer);
}
#endif

static void conf_reset_callback(unsigned long dummy)
{
	int	normal_interval;
#if defined(CONFIG_MCT_SG100) || defined(CONFIG_MCT_SG600) || defined(CONFIG_MCT_SA100)
	unsigned short	val;
#elif defined(CONFIG_MCT_SG4100) || defined(CONFIG_MCT_SA200)
	unsigned long	val;
#endif

	normal_interval = 1;
#if defined(CONFIG_MCT_SG100)
	val = (*(volatile unsigned short*) CPLD_GPIO_ADDR);
	if ( (val & CPLD_PASSWD_RESET_BIT) == 0 && 
#elif defined(CONFIG_MCT_SG600)
	val = (*(volatile unsigned short*) LOCALBUS_DATAIN_ADDR);
	if ( (val & LOCALBUS_DATAIN_PASSWD_RESET_BIT) == 0 &&
#elif defined(CONFIG_MCT_SA100)
	val = *(volatile unsigned long *) CPU_PIODI_ADDR;
	if ( (val & CPU_GPIO_PASSWD_RESET_BIT) == 0 &&
#elif defined(CONFIG_MCT_SG4100) || defined(CONFIG_MCT_SA200)
	val = *(volatile unsigned long *) CPU_PIODI_ADDR;
	if ( (val & CPU_GPIO_PASSWD_RESET_BIT) == 0 &&
#endif
			!conf_reset_in_progress ) {	// low active
		if ( conf_reset_tick_count >= 50 ) {	// trigger "config reset" if the "config reset" button is held at least 5 seconds.
#if defined(CONFIG_MCT_SG100) || defined(CONFIG_MCT_SG600) || defined(CONFIG_MCT_SA100) || defined(CONFIG_MCT_SA200)
			del_timer(&speaker_timer);
			SPK_OFF();
#endif

			conf_reset_in_progress = 1;
			wake_up_interruptible(&flash_wq);
		} else if ( conf_reset_detecting ) {
			conf_reset_tick_count++;
			normal_interval = 0;
		} else {
#if defined(CONFIG_MCT_SG100) || defined(CONFIG_MCT_SG600) || defined(CONFIG_MCT_SA100) || defined(CONFIG_MCT_SA200)
			init_timer(&speaker_timer);
			speaker_timer.function = speaker_callback;
			speaker_timer.expires = jiffies + HZ;
			add_timer(&speaker_timer);
			SPK_OFF();
#endif

			conf_reset_tick_count = 0;
			conf_reset_detecting = 1;
		}
	} else {
#if defined(CONFIG_MCT_SG100) || defined(CONFIG_MCT_SG600) || defined(CONFIG_MCT_SA100) || defined(CONFIG_MCT_SA200)
		del_timer(&speaker_timer);
		SPK_OFF();
#endif

		conf_reset_detecting = 0;
	}
			
	init_timer(&conf_reset_timer);
	conf_reset_timer.function = conf_reset_callback;
	conf_reset_timer.expires = jiffies + ((normal_interval) ? (HZ / 2) : (HZ / 10));
	add_timer(&conf_reset_timer);
}

void __init conf_reset_init(void)
{
	init_timer(&conf_reset_timer);
	conf_reset_timer.function = conf_reset_callback;
	conf_reset_timer.expires = jiffies + HZ / 2;
	add_timer(&conf_reset_timer);
}

