/*
 *  linux/arch/mips/toshiba-boards/generic/pmon.c
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 2000-2001 Toshiba Corporation
 *
 * $Id: pmon.c,v 1.1.1.1 2004/04/07 08:36:50 louistsai Exp $
 */

#include <linux/config.h>
#include <linux/init.h>
#include <linux/version.h>
#include <asm/system.h>
#include <asm/mipsregs.h>
#include <asm/mct-boards/pmon.h>

struct pmon_vector *pmon_vector = (struct pmon_vector *)PMON_VECTOR;

void pmon_halt(void)
{
	if (pmon_vector && pmon_vector->exit)
		pmon_vector->exit(0);
	cli();
	while (1)
		;
}

static char ppbuf[1024];

void pmon_printf(char *fmt, ...)
{
	va_list args;
	if (!pmon_vector)
		return;
	va_start(args, fmt);
	pmon_vector->vsprintf(ppbuf, fmt, args);
	va_end(args);
	pmon_vector->write(1/*STDOUT*/, ppbuf, strlen(ppbuf));
}

extern asmlinkage void pmon_trap_low(void);
unsigned long pmon_user_exception_handler[32];
extern unsigned long exception_handlers[32];
void set_pmon_debug_traps(void)
{
	unsigned long flags;
	int tt = 9;	/* beakpoint only */

	if (!pmon_vector)
		return;
	save_and_cli(flags);
	/* save original handlers (for user-mode exceptions) */
	pmon_user_exception_handler[tt] = exception_handlers[tt];
	set_except_vector(tt, pmon_trap_low);
	restore_flags(flags);
}
