/*
 *  linux/arch/mips/toshiba-boards/jmr3927/rtc.c
 * $Id: rtc.c,v 1.1.1.1 2004/04/07 08:36:50 louistsai Exp $
 *
 * RTC routines for Dallas chip.
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 200-2001 Toshiba Corporation
 */
#include <asm/mc146818rtc.h>	/* bad name... */
#include <asm/mct-boards/jmr3927.h>

static unsigned char jmr3927_rtc_read_data(unsigned long addr)
{
	return jmr3927_nvram_in(addr);
}

static void jmr3927_rtc_write_data(unsigned char data, unsigned long addr)
{
	jmr3927_nvram_out(data, addr);
}

static int jmr3927_rtc_bcd_mode(void)
{
	return 1;
}

struct rtc_ops jmr3927_rtc_ops = {
	&jmr3927_rtc_read_data,
	&jmr3927_rtc_write_data,
	&jmr3927_rtc_bcd_mode
};
