/*
 * linux/arch/mips/toshiba-boards/jmr3927/setup.c
 * $Id: setup.c,v 1.1.1.1 2004/04/07 08:36:50 louistsai Exp $
 *
 * Setup pointers to hardware-dependent routines.
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 2000-2001 Toshiba Corporation
 */

#include <linux/config.h>
#include <linux/hdreg.h>
#include <linux/init.h>
#include <linux/types.h>
#include <linux/ioport.h>
#include <linux/kdev_t.h>
#include <linux/pci.h>
#include <linux/delay.h>
#include <asm/system.h>
#include <asm/reboot.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/mct-boards/pmon.h>
#include <asm/mct-boards/pci.h>
#include <asm/mct-boards/jmr3927.h>
#include <asm/mct-boards/jmi39io2.h>
#include <asm/mc146818rtc.h>	/* bad name... */
#include <asm/bootinfo.h>
#include <asm/cpu.h>
#include <asm/pci.h>
#include <asm/time.h>
#include <asm/mipsregs.h>
#include <asm/ptrace.h>
#include <asm/keyboard.h>
#include <linux/ide.h>
#if defined(CONFIG_SERIAL_TXX927)
#include <asm/serial_txx927.h>
#endif

/*static*/ int jmr3927_ccfg_toeon = 0;

#if 0	/* Removed by Ethan on 05/16/2002 */
extern struct rtc_ops jmr3927_rtc_ops;
#endif
extern struct pci_ops jmr3927_pci_ops;
extern int jmr3927_pci_map_irq(struct pci_dev *dev, u8 slot, u8 pin);
extern void jmr3927_irq_setup(void) __init;
extern void jmr3927_time_init(void) __init;
extern void jmr3927_timer_setup(struct irqaction *irq) __init;

#ifdef CONFIG_REMOTE_DEBUG
extern int __init early_serial_txx927_kgdb_setup(int line, unsigned long base, int irq, int baud_base);
extern void breakpoint(void);
#define TOMON(s) printk(s); breakpoint()
#else
#define TOMON(s) pmon_printf(s); pmon_halt()
#endif
extern void wait_for_keypress(void);

#if 1	/* Modified by Ethan on 04/04/2002 */
static void sgboard_restart(void)
{
	unsigned long addr = 0xbfc00000;

	/* added by Ethan on 07/17/2002 */
	/* reset PCI local bus controller */
	tx3927_pcicptr->lbc = tx3927_pcicptr->lbc | 0x00000800;

	__asm__ __volatile__(
		"j %0\n"
		:
		: "r" (addr)
		);
}

static void sgboard_halt(void)
{
#if defined(CONFIG_MCT_SG600) || defined(CONFIG_MCT_SA100)
	tx3927_pioptr->dout = tx3927_pioptr->din | 0x0c00;
#endif
	while ( 1 );
}
#else
static inline void do_reset(void)
{
#if 1	/* Resetting PCI bus */
	jmr3927_ioc_reg_out(0, JMR3927_IOC_RESET_ADDR);
	jmr3927_ioc_reg_out(JMR3927_IOC_RESET_PCI, JMR3927_IOC_RESET_ADDR);
	(void)jmr3927_ioc_reg_in(JMR3927_IOC_RESET_ADDR);	/* flush WB */
	mdelay(1);
	jmr3927_ioc_reg_out(0, JMR3927_IOC_RESET_ADDR);
#endif
	jmr3927_ioc_reg_out(JMR3927_IOC_RESET_CPU, JMR3927_IOC_RESET_ADDR);
}

static void jmr3927_machine_restart(char *command)
{
	cli();
	printk("Rebooting...");
	do_reset();
}

static void jmr3927_machine_halt(void)
{
	cli();
	printk("Press any key to reboot.\n");
	wait_for_keypress();
	do_reset();
}

static void jmr3927_machine_power_off(void)
{
	cli();
	printk("Press any key to reboot.\n");
	wait_for_keypress();
	do_reset();
}
#endif	/* Modified by Ethan */

static void __init tx3927_setup(void)
{
	int i;
	unsigned long sdram_size;

	/* SDRAMC are configured by PROM */
	sdram_size = 1;
	while (sdram_size + KSEG0 < toshibaboards_memory_upper)
		sdram_size <<= 1;

	/* ROMC */
#if 0	/* Removed by Ethan on 04/06/2002 */
	if (!(tx3927_romcptr->cr[1] & 8)) {
		/* Flash1 or Flash-3 */
		tx3927_romcptr->cr[1] =
			(tx3927_romcptr->cr[0] & 0x000fffff) | JMR3927_ROMCE1;
		/* CE1 is 32bit mode (Flash-1) if CE0 is 16bit mode(Flash-3) */
		tx3927_romcptr->cr[1] ^= 0x08;
	}
#endif

	// Ethan: the following setting may not work for some boards.
	// Hence, the ROMCE2 configuration will follow the setting of boot loader.
#if 0	/* Removed by Ethan on 05/16/2002 */
	//tx3927_romcptr->cr[2] = JMR3927_ROMCE2 | 0x000064c8;
	tx3927_romcptr->cr[2] = JMR3927_ROMCE2 | 0x0000f41f;
#endif

#if 0	/* Removed by Ethan on 04/06/2002 */
	tx3927_romcptr->cr[3] = JMR3927_ROMCE3 | 0x0003f698;
	tx3927_romcptr->cr[5] = JMR3927_ROMCE5 | 0x0000f218;
#endif	/* Removed by Ethan */

	/* CCFG */
	/* enable Timeout BusError */
	if (jmr3927_ccfg_toeon)
		tx3927_ccfgptr->ccfg |= TX3927_CCFG_TOE;

	/* Added by Ethan on 04/29/2002 */
	/* Watchdog timer interrupt is connected to TX3927 internal reset. */
	tx3927_ccfgptr->ccfg |= TX3927_CCFG_WR;

	/* clear BusErrorOnWrite flag */
	tx3927_ccfgptr->ccfg &= ~TX3927_CCFG_BEOW;
	/* Disable PCI snoop */
	tx3927_ccfgptr->ccfg &= ~TX3927_CCFG_PSNP;

	/* Pin selection */
#if 1	/* Modified by Ethan on 04/06/2002 */
	tx3927_ccfgptr->pcfg = TX3927_PCFG_SDRCLKEN(0) | TX3927_PCFG_SELSIO(0) |
#if defined(CONFIG_MCT_SG600) || defined(CONFIG_MCT_SA100)
		TX3927_PCFG_PCICLKEN(0) | TX3927_PCFG_PCICLKEN(1) | TX3927_PCFG_PCICLKEN(2) | TX3927_PCFG_PCICLKEN(3);
#else

 		TX3927_PCFG_PCICLKEN(0) | TX3927_PCFG_PCICLKEN(1);
#endif

#else
	tx3927_ccfgptr->pcfg &= ~TX3927_PCFG_SELALL;
	tx3927_ccfgptr->pcfg |=
		TX3927_PCFG_SELSIOC(0) | TX3927_PCFG_SELSIO_ALL |
		(TX3927_PCFG_SELDMA_ALL & ~TX3927_PCFG_SELDMA(1));
#endif

	printk("TX3927 -- CRIR:%08lx CCFG:%08lx PCFG:%08lx\n",
	       tx3927_ccfgptr->crir,
	       tx3927_ccfgptr->ccfg, tx3927_ccfgptr->pcfg);

	/* IRC */
	/* disable interrupt control */
	tx3927_ircptr->cer = 0;
	/* mask all IRC interrupts */
	tx3927_ircptr->imr = 0;
	for (i = 0; i < TX3927_NUM_IR / 2; i++) {
		tx3927_ircptr->ilr[i] = 0;
	}
	/* setup IRC interrupt mode (Low Active) */
	for (i = 0; i < TX3927_NUM_IR / 8; i++) {
		tx3927_ircptr->cr[i] = 0;
	}

	/* TMR */
	/* disable all timers */
	for (i = 0; i < TX3927_NR_TMR; i++) {
		tx3927_tmrptr(i)->tcr = TXx927_TMTCR_CRE;
		tx3927_tmrptr(i)->tisr = 0;
		tx3927_tmrptr(i)->cpra = 0xffffffff;
		tx3927_tmrptr(i)->itmr = 0;
		tx3927_tmrptr(i)->ccdr = 0;
		tx3927_tmrptr(i)->pgmr = 0;
	}

	/* DMA */
	tx3927_dmaptr->mcr = 0;
	for (i = 0; i < sizeof(tx3927_dmaptr->ch) / sizeof(tx3927_dmaptr->ch[0]); i++) {
		/* reset channel */
		tx3927_dmaptr->ch[i].ccr = TX3927_DMA_CCR_CHRST;
		tx3927_dmaptr->ch[i].ccr = 0;
	}
	/* enable DMA */
#ifdef __BIG_ENDIAN
	tx3927_dmaptr->mcr = TX3927_DMA_MCR_MSTEN;
#else
	tx3927_dmaptr->mcr = TX3927_DMA_MCR_MSTEN | TX3927_DMA_MCR_LE;
#endif

	/* PCIC */
	printk("TX3927 PCIC -- DID:%04x VID:%04x RID:%02x Arbiter:",
	       tx3927_pcicptr->did, tx3927_pcicptr->vid,
	       tx3927_pcicptr->rid);
	if (!(tx3927_ccfgptr->ccfg & TX3927_CCFG_PCIXARB)) {
		printk("External\n");
		/* XXX */
	} else {
		printk("Internal\n");

#if 0	/* Removed by Ethan on 04/04/2002 */
		/* Reset PCI Bus */
		jmr3927_ioc_reg_out(0, JMR3927_IOC_RESET_ADDR);
		udelay(100);
		jmr3927_ioc_reg_out(JMR3927_IOC_RESET_PCI,
				    JMR3927_IOC_RESET_ADDR);
		udelay(100);
		jmr3927_ioc_reg_out(0, JMR3927_IOC_RESET_ADDR);
#endif	/* Removed by Ethan */

		/* Disable PCI SNOOP */
		tx3927_ccfgptr->ccfg &= ~TX3927_CCFG_PSNP;

		/* Disable External PCI Config. Access */
		tx3927_pcicptr->lbc = TX3927_PCIC_LBC_EPCAD;
#ifdef __BIG_ENDIAN
		tx3927_pcicptr->lbc |= TX3927_PCIC_LBC_IBSE |
			TX3927_PCIC_LBC_TIBSE |
			TX3927_PCIC_LBC_TMFBSE | TX3927_PCIC_LBC_MSDSE;
#endif
		/* LB->PCI mappings */
		tx3927_pcicptr->iomas = ~(JMR3927_PCIIO_SIZE - 1);
		tx3927_pcicptr->ilbioma = JMR3927_PCIIO;
		tx3927_pcicptr->ipbioma = 0;
		tx3927_pcicptr->mmas = ~(JMR3927_PCIMEM_SIZE - 1);
		tx3927_pcicptr->ilbmma = JMR3927_PCIMEM;
		tx3927_pcicptr->ipbmma = JMR3927_PCIMEM;
		/* PCI->LB mappings */
		tx3927_pcicptr->iobas = 0xffffffff;
		tx3927_pcicptr->ioba = 0;
		tx3927_pcicptr->tlbioma = 0;
		tx3927_pcicptr->mbas = ~(sdram_size - 1);
		tx3927_pcicptr->mba = (0 & PCI_BASE_ADDRESS_MEM_MASK);
		tx3927_pcicptr->tlbmma = 0;
		/* Enable Direct mapping Address Space Decoder */
		tx3927_pcicptr->lbc |= TX3927_PCIC_LBC_ILMDE | TX3927_PCIC_LBC_ILIDE;


		/* Clear All Local Bus Status */
		tx3927_pcicptr->lbstat = TX3927_PCIC_LBIM_ALL;
		/* Enable All Local Bus Interrupts */
		tx3927_pcicptr->lbim = TX3927_PCIC_LBIM_ALL;
		/* Clear All PCI Status Error */
		tx3927_pcicptr->pcistat = TX3927_PCIC_PCISTATIM_ALL;
		/* Enable All PCI Status Error Interrupts */
		tx3927_pcicptr->pcistatim = TX3927_PCIC_PCISTATIM_ALL;

		/* PCIC Int => IRC IRQ10 */
		tx3927_pcicptr->il = TX3927_IR_PCI;
#if 0
		/* Target Control (???) */
		tx3927_pcicptr->tc = TX3927_PCIC_TC_OF16E | TX3927_PCIC_TC_IF8E;
#endif

		/* Enable Bus Arbiter */
#if 0
		tx3927_pcicptr->req_trace = 0x73737373;
#endif
		tx3927_pcicptr->pbapmc = TX3927_PCIC_PBAPMC_PBAEN;
		tx3927_pcicptr->tbl = 0x00000995;

		tx3927_pcicptr->pcicmd = PCI_COMMAND_MASTER |
			PCI_COMMAND_MEMORY |
			PCI_COMMAND_IO
#if !defined(CONFIG_MCT_SA100)
			| PCI_COMMAND_PARITY | 
			PCI_COMMAND_SERR
#endif
			;
	}

#if 0	/* Removed by Ethan on 05/16/2002 */
	/* PIO */
	/* PIO[15:12] connected to LEDs */
	tx3927_pioptr->dir = 0x0000f000;
	tx3927_pioptr->maskcpu = 0;
	tx3927_pioptr->maskext = 0;
#endif
}

#if 0	/* Removed by Ethan on 04/04/2002 */
extern int early_premier3_setup(unsigned long base, int irq);
extern int toshibaboards_probe_ieee1394_board(unsigned long base);
static void __init jmr3927_check_ieee1394_board(void)
{
	unsigned long rccr5;

	rccr5 = tx3927_romcptr->cr[5];
	tx3927_romcptr->cr[5] =
		(rccr5 & 0xfff00000) | 0x0000f218;	/* normal submode */
	printk(KERN_DEBUG "RCCR5 %08lx\n", tx3927_romcptr->cr[5]);
	if (toshibaboards_probe_ieee1394_board(JMR3927_PREMIER3_BASE) == 0) {
		tx3927_romcptr->cr[5] =
			(rccr5 & 0xfffc0000) | 0x0003f218;	/* ext.Ack */
#ifdef CONFIG_IEEE1394_PREMIER3
		early_premier3_setup(JMR3927_PREMIER3_BASE, JMR3927_IRQ_PREMIER3);
#endif
	} else {
		tx3927_romcptr->cr[5] = rccr5;
	}
	printk(KERN_DEBUG "RCCR5 %08lx\n", tx3927_romcptr->cr[5]);
}

static int jmr3927_check_iob(void)
{
	unsigned char idt;
	unsigned long flags;
	unsigned long romcr3;
	save_and_cli(flags);
	romcr3 = tx3927_romcptr->cr[3];
	tx3927_romcptr->cr[3] &= 0xffffefff;	/* do not wait infinitely */
	idt = jmi39io2_isac_reg_in(JMI39IO2_ISAC_REV_ADDR(JMR3927_IOB_BASE)) & JMI39IO2_IDT_MASK;
	tx3927_romcptr->cr[3] = romcr3;
	restore_flags(flags);
	return idt == JMI39IO2_ISAC_IDT;
}
#endif 	/* Removed by Ethan */

static struct resource tx3927_reg_resource = {
	"TX3927", TX3927_REG_BASE, TX3927_REG_BASE+TX3927_REG_SIZE, IORESOURCE_MEM
};

void __init sgx00_setup(void)
{
#if defined(CONFIG_SERIAL_TXX927)
	int i;
#endif
	toshibaboards_pci_io_resource.start = 0;
	toshibaboards_pci_io_resource.end = JMR3927_PCIIO_SIZE - 1;
	toshibaboards_pci_mem_resource.start = JMR3927_PCIMEM;
	toshibaboards_pci_mem_resource.end =
		JMR3927_PCIMEM + JMR3927_PCIMEM_SIZE - 1;

	tx3927_setup();

	/* TX3927 internal registers */
	iomem_resource.end = 0xffffffff;	/* 4GB */
	request_resource(&iomem_resource, &tx3927_reg_resource);

	board_time_init = jmr3927_time_init;
	board_timer_setup = jmr3927_timer_setup;
	irq_setup = jmr3927_irq_setup;
	/* map ioport 0 to PCI I/O space address 0 */
	set_io_port_base(KSEG1ADDR(JMR3927_PCIIO));

#if 1	/* Modified by Ethan on 04/04/2002 */
	_machine_restart = sgboard_restart;
	_machine_halt = sgboard_halt;
	_machine_power_off = sgboard_halt;
#else
	_machine_restart = jmr3927_machine_restart;
	_machine_halt = jmr3927_machine_halt;
	_machine_power_off = jmr3927_machine_power_off;
#endif

#if 0	/* Removed by Ethan on 05/16/2002 */
	if (jmr3927_have_nvram()) {
		rtc_ops = &jmr3927_rtc_ops;
	}
#endif
	toshibaboards_pci_ops = &jmr3927_pci_ops;
	toshibaboards_pci_map_irq = jmr3927_pci_map_irq;

#if 0	/* Removed by Ethan on 04/04/2002 */
	/* SIO0 DTR on */
	jmr3927_ioc_reg_out(0, JMR3927_IOC_DTR_ADDR);

	jmr3927_led_set(0);
	printk("TJSYS JMR-TX3927 (Rev %d) --- IOC(Rev %d) DIPSW:%d,%d,%d,%d\n",
	       jmr3927_ioc_reg_in(JMR3927_IOC_BREV_ADDR) & JMR3927_REV_MASK,
	       jmr3927_ioc_reg_in(JMR3927_IOC_REV_ADDR) & JMR3927_REV_MASK,
	       jmr3927_dipsw1(), jmr3927_dipsw2(),
	       jmr3927_dipsw3(), jmr3927_dipsw4());

	if (jmr3927_check_iob())
		jmi39io2_init(JMR3927_IOB_BASE, JMR3927_IRQ_ISAC);
	if (have_jmi39io2()) {
		jmi39io2_kbd_init();
#ifdef CONFIG_BLK_DEV_IDE
		/* overrides PCI-IDE */
		jmi39io2_ide_init();
#endif
	}

	jmr3927_check_ieee1394_board();
#endif	/* Removed by Ethan */

#if defined(CONFIG_SERIAL_TXX927)
	/* loop until early_txx927_serial_setup() returns error. */
	for(i = 0; i < 2; i++) {
		/* use Pre-scaler T0 (1/2) */
		early_serial_txx927_setup(i,
					  TX3927_SIO_REG(i),
					  JMR3927_IRQ_IRC_SIO(i),
					  JMR3927_IMCLK / 2 / 16,
					  (i == 0) ? TXx927_SERIAL_HAVE_CTS_LINE : 0);
#ifdef CONFIG_REMOTE_DEBUG
		early_serial_txx927_kgdb_setup(i,
					       TX3927_SIO_REG(i),
					       JMR3927_IRQ_IRC_SIO(i),
					       JMR3927_IMCLK / 2 / 16);
#endif
	}
#endif
#ifdef CONFIG_FB_E1355
	if (have_jmi39io2()) {
		early_e1355_setup(JMI39IO2_LCDVGA_REG_BASE(JMR3927_IOB_BASE),
				  JMI39IO2_LCDVGA_MEM_BASE(JMR3927_IOB_BASE));
	}
#endif
}
