/*
 *  linux/arch/mips/toshiba-boards/tsdb/rtc.c
 * $Id: rtc.c,v 1.1.1.1 2004/04/07 08:36:50 louistsai Exp $
 *
 * RTC routines for Dallas chip.
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 1999-2001 Toshiba Corporation
 */
#include <linux/kernel.h>
#include <asm/mc146818rtc.h>	/* bad name... */
#include <asm/byteorder.h>
#include <asm/toshiba-boards/tsdb.h>

static unsigned char tsdb_rtc_read_data(unsigned long addr)
{
#ifdef	__BIG_ENDIAN
	return *(tsdb_bramrtc_ptr + (addr^3));
#else
	return *(tsdb_bramrtc_ptr + (addr));
#endif
}

static void tsdb_rtc_write_data(unsigned char data, unsigned long addr)
{
#ifdef	__BIG_ENDIAN
	*(tsdb_bramrtc_ptr + (addr^3)) = data;
#else
	*(tsdb_bramrtc_ptr + (addr)) = data;
#endif
}

static int tsdb_rtc_bcd_mode(void)
{
	return 1;
}

struct rtc_ops tsdb_rtc_ops = {
	&tsdb_rtc_read_data,
	&tsdb_rtc_write_data,
	&tsdb_rtc_bcd_mode
};
