/*
 *  linux/arch/mips/toshiba-boards/generic/dump_tx3927.c
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 2001 Toshiba Corporation
 *
 * $Id: dump_tx3927.c,v 1.1.1.1 2004/04/07 08:36:50 louistsai Exp $
 */
#include <linux/config.h>
#include <linux/kernel.h>
#include <asm/tx3927.h>

void tx3927_dump_pcic_settings(void)
{
	printk("tx3927 pcic settings:");
	{
		int i;
		unsigned long *preg = (unsigned long *)tx3927_pcicptr;
		for (i = 0; i < sizeof(struct tx3927_pcic_reg); i += 4) {
			if (i % 32 == 0)
				printk("\n%04x:", i);
			/* skip registers with side-effects */
			if (preg == &tx3927_pcicptr->iiadp
			    || preg == &tx3927_pcicptr->ica
			    || preg == &tx3927_pcicptr->icd
				) {
				printk(" XXXXXXXX");
				preg++;
				continue;
			}
			printk(" %08lx", *preg++);
		}
		printk("\n");
	}
}
