#include <linux/init.h>
#include <linux/sched.h>
#include <linux/wait.h>

#define CPLD_GPIO_ADDR	0xb4000400
#define	CPLD_GPIO_HBLED	0x10
#define CPLD_PASSWD_RESET_BIT	0x01

static struct timer_list hbled_timer;

static void hbled_blink(unsigned long dummy)
{
	unsigned char	oldval, val;

	oldval = val = (*(volatile unsigned short*) CPLD_GPIO_ADDR);
	val = (val & CPLD_GPIO_HBLED) ?
		(val & ~CPLD_GPIO_HBLED) : (val | CPLD_GPIO_HBLED);
	(*(volatile unsigned char*) CPLD_GPIO_ADDR) = val;
		
	init_timer(&hbled_timer);
	hbled_timer.function = hbled_blink;
	hbled_timer.expires = jiffies + HZ / 2;
	add_timer(&hbled_timer);
}

void __init hbled_init(void)
{
	init_timer(&hbled_timer);
	hbled_timer.function = hbled_blink;
	hbled_timer.expires = jiffies + HZ;
	add_timer(&hbled_timer);
}

static struct timer_list	conf_reset_timer;
static int	conf_reset_detecting;
static int	conf_reset_tick_count;
static int	speaker_on;
static struct timer_list speaker_timer;
extern int	conf_reset_in_progress;
extern wait_queue_head_t	flash_wq;

#define SPK_ON()	((*(volatile unsigned char*) CPLD_GPIO_ADDR) |= 0x20)
#define SPK_OFF()	((*(volatile unsigned char*) CPLD_GPIO_ADDR) &= 0xdf)

static void speaker_callback(unsigned long dummy)
{
	if ( speaker_on ) {
		SPK_OFF();
		speaker_on = 0;
	} else {
		SPK_ON();
		speaker_on = 1;
	}
		
	init_timer(&speaker_timer);
	speaker_timer.function = speaker_callback;
	speaker_timer.expires = jiffies + HZ / 2;
	add_timer(&speaker_timer);
}

static void conf_reset_callback(unsigned long dummy)
{
	int	normal_interval;
	unsigned short	val;

	normal_interval = 1;
	val = (*(volatile unsigned short*) CPLD_GPIO_ADDR);
	if ( (val & CPLD_PASSWD_RESET_BIT) == 0 && !conf_reset_in_progress ) {	// low active
		if ( conf_reset_tick_count >= 50 ) {	// trigger "config reset" if the "config reset" button is held at least 5 seconds.
			del_timer(&speaker_timer);
			SPK_OFF();
			speaker_on = 0;

			conf_reset_in_progress = 1;
			wake_up_interruptible(&flash_wq);
		} else if ( conf_reset_detecting ) {
			conf_reset_tick_count++;
			normal_interval = 0;
		} else {
			init_timer(&speaker_timer);
			speaker_timer.function = speaker_callback;
			speaker_timer.expires = jiffies + HZ;
			add_timer(&speaker_timer);
			SPK_OFF();
			speaker_on = 0;

			conf_reset_tick_count = 0;
			conf_reset_detecting = 1;
		}
	} else {
		del_timer(&speaker_timer);
		SPK_OFF();
		speaker_on = 0;

		conf_reset_detecting = 0;
	}
			
	init_timer(&conf_reset_timer);
	conf_reset_timer.function = conf_reset_callback;
	conf_reset_timer.expires = jiffies + ((normal_interval) ? (HZ / 2) : (HZ / 10));
	add_timer(&conf_reset_timer);
}

void __init conf_reset_init(void)
{
	init_timer(&conf_reset_timer);
	conf_reset_timer.function = conf_reset_callback;
	conf_reset_timer.expires = jiffies + HZ / 2;
	add_timer(&conf_reset_timer);
}
