/*
 *  linux/arch/mips/toshiba-boards/jmr3927/irq.c
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 2000-2001 Toshiba Corporation
 *
 * $Id: irq.c,v 1.1.1.1 2004/04/07 08:36:50 louistsai Exp $
 */
#include <linux/config.h>
#include <linux/init.h>

#include <linux/errno.h>
#include <linux/kernel_stat.h>
#include <linux/signal.h>
#include <linux/sched.h>
#include <linux/types.h>
#include <linux/interrupt.h>
#include <linux/ioport.h>
#include <linux/timex.h>
#include <linux/slab.h>
#include <linux/random.h>
#include <linux/smp.h>
#include <linux/smp_lock.h>
#ifdef CONFIG_BLK_DEV_IDEPCI
#include <linux/pci.h>
#endif

#include <asm/bitops.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/mipsregs.h>
#include <asm/system.h>

#include <asm/ptrace.h>
#include <asm/processor.h>
#include <asm/toshiba-boards/irq.h>
#include <asm/toshiba-boards/jmr3927.h>
#include <asm/toshiba-boards/jmi39io2.h>

#if JMR3927_IRQ_END > NR_IRQS
#error JMR3927_IRQ_END > NR_IRQS
#endif

#define flush_wb()	\
	__asm__ __volatile__( \
		".set    push\n\t" \
		".set    noreorder\n\t" \
		"1: bc0f    1b\n\t" \
		"nop\n\t" \
		".set pop" \
	)

#if 0	/* Removed by Ethan on 04/07/2002 */

#define JMR3927_IRQ_ISACINT JMR3927_IRQ_IRC_INT(JMI39IO2_INT_ISAC)

static int jmr3927_gen_iack(void)
{
	/* generate ACK cycle */
#ifdef __BIG_ENDIAN
	return (tx3927_pcicptr->iiadp >> 24) & (NR_ISA_IRQS - 1);
#else
	return tx3927_pcicptr->iiadp & (NR_ISA_IRQS - 1);
#endif
}

#define flush_wb()	\
	__asm__ __volatile__( \
		".set    push\n\t" \
		".set    noreorder\n\t" \
		"1: bc0f    1b\n\t" \
		"nop\n\t" \
		".set pop" \
	)

/*
 * JMR3927 IOC controller definition
 */
static void jmr_ioc_irq_enable(unsigned int irq)
{
	int irq_nr = irq - JMR3927_IRQ_IOC;
	/* 0: mask */
	unsigned char imask =
		jmr3927_ioc_reg_in(JMR3927_IOC_INTM_ADDR);
	unsigned int bit = 1 << irq_nr;
	jmr3927_ioc_reg_out(imask | bit, JMR3927_IOC_INTM_ADDR);
	flush_wb();
}
static void jmr_ioc_irq_disable(unsigned int irq)
{
	int irq_nr = irq - JMR3927_IRQ_IOC;
	/* 0: mask */
	unsigned char imask =
		jmr3927_ioc_reg_in(JMR3927_IOC_INTM_ADDR);
	unsigned int bit = 1 << irq_nr;
	jmr3927_ioc_reg_out(imask & ~bit, JMR3927_IOC_INTM_ADDR);
	flush_wb();
}
static unsigned int jmr_ioc_irq_startup(unsigned int irq)
{
	jmr_ioc_irq_enable(irq);
	return 0;
}
#define	jmr_ioc_irq_shutdown	jmr_ioc_irq_disable

static void jmr_ioc_irq_ack(unsigned int irq)
{
	jmr_ioc_irq_disable(irq);
}
static void jmr_ioc_irq_end(unsigned int irq)
{
	if (!(irq_desc[irq].status & (IRQ_DISABLED|IRQ_INPROGRESS)))
		jmr_ioc_irq_enable(irq);
}

static hw_irq_controller jmr_ioc_irq_controller = {
	typename:	"IOC",
	startup:	jmr_ioc_irq_startup,
	shutdown:	jmr_ioc_irq_shutdown,
	enable:		jmr_ioc_irq_enable,
	disable:	jmr_ioc_irq_disable,
	ack:		jmr_ioc_irq_ack,
	end:		jmr_ioc_irq_end,
	set_affinity:	NULL,
};

static inline int jmr3927_ioc_irqroute(void)
{
	unsigned char istat = jmr3927_ioc_reg_in(JMR3927_IOC_INTS2_ADDR);
	int i, irq;
	for (i = 0; i < JMR3927_NR_IRQ_IOC; i++) {
		if (istat & (1 << i)) {
			irq = JMR3927_IRQ_IOC + i;
			return toshibaboards_i8259_irqroute(irq);
		}
	}
	return -1;
}

static int jmr3927_irc_irqdispatch(struct pt_regs *regs)
{
	int irq;
#ifdef CONFIG_TX_BRANCH_LIKELY_BUG_WORKAROUND
	tx_branch_likely_bug_fixup(regs);
#endif
	if ((regs->cp0_cause & CAUSEF_IP7) == 0)
		return -1;
	irq = (regs->cp0_cause >> CAUSEB_IP2) & 0x0f;
#if 1 /* XXX DEBUG */
	jmr3927_led_set(irq);
#endif

	irq += JMR3927_IRQ_IRC;
	switch (irq) {
	case JMR3927_IRQ_IOCINT:
		irq = jmr3927_ioc_irqroute();
		break;
	case JMR3927_IRQ_ISACINT:
		irq = jmi39io2_isac_irqroute();
		break;
	}
	if (irq < 0)
		return -1;
	do_IRQ(irq, regs);
	flush_wb();
	return 0;
}

static struct irqaction ioc_action = {
	no_action, 0, 0, "cascade(IOC)", NULL, NULL,
};

static struct irqaction isac_action = {
	no_action, 0, 0, "cascade(JMI39IO2 ISAC)", NULL, NULL,
};

static void jmr3927_isaerr_interrupt(int irq, void * dev_id, struct pt_regs * regs)
{
#if 1
	printk("ISA error interrupt (irq 0x%x).\n", irq);
#endif
}
static struct irqaction isaerr_action = {
	jmr3927_isaerr_interrupt, SA_INTERRUPT, 0, "ISA error", NULL, NULL,
};
#endif	/* Removed by Ethan */

static void jmr3927_pcierr_interrupt(int irq, void * dev_id, struct pt_regs * regs)
{
#ifdef CONFIG_BLK_DEV_IDEPCI
	/* ignore MasterAbort for ide probing... */
	if ((tx3927_pcicptr->pcistat & 0xf900) == PCI_STATUS_REC_MASTER_ABORT) {
		tx3927_pcicptr->pcistat |= PCI_STATUS_REC_MASTER_ABORT;
		return;
	}
#endif
#if 1
	printk("PCI error interrupt (irq 0x%x).\n", irq);
	printk("pcistat:%02x, lbstat:%04lx\n",
	       tx3927_pcicptr->pcistat, tx3927_pcicptr->lbstat);
#endif
}
static struct irqaction pcierr_action = {
	jmr3927_pcierr_interrupt, SA_INTERRUPT, 0, "PCI error", NULL, NULL,
};

int jmi_ether_irq = 0;

static int jmr3927_irc_irqdispatch(struct pt_regs *regs)
{
	int	irq;

#ifdef CONFIG_TX_BRANCH_LIKELY_BUG_WORKAROUND
	tx_branch_likely_bug_fixup(regs);
#endif
	if ((regs->cp0_cause & CAUSEF_IP7) == 0)
		return -1;
	irq = (regs->cp0_cause >> CAUSEB_IP2) & 0x0f;

	irq += JMR3927_IRQ_IRC;
/*
	switch (irq) {
	case JMR3927_IRQ_IOCINT:
		irq = jmr3927_ioc_irqroute();
		break;
	case JMR3927_IRQ_ISACINT:
		irq = jmi39io2_isac_irqroute();
		break;
	}
*/
	if (irq < 0)
		return -1;
	do_IRQ(irq, regs);
	flush_wb();
	return 0;
}

void __init jmr3927_irq_setup(void)
{
#if 1	/* Modified by Ethan on 04/07/2002 */

	toshibaboards_irqdispatch = jmr3927_irc_irqdispatch;
	/* setup irq descriptors */
	tx3927_irq_init(JMR3927_IRQ_IRC);
	setup_irq(JMR3927_IRQ_IRC_PCI, &pcierr_action);
	/* enable TX3927 IRC interrupt */
	set_cp0_status(CAUSEF_IP7);

#else
	int have_isac = have_jmi39io2();
	int i;

	/* Now, interrupt control disabled, */
	/* all IRC interrupts are masked, */
	/* all IRC interrupt mode are Low Active. */

#ifdef CONFIG_JMI39IO2_NET
	if (have_isac) {
		/* JMI90IO2 ETHER (NE2000 compatible 10M-Ether) parameter setup */
		/* temporary enable interrupt control */
		tx3927_ircptr->cer = 1;
		/* JMI39IO2 ETHER Int. Is High-Active. */
		if (tx3927_ircptr->ssr & (1 << TX3927_IR_INT(JMI39IO2_INT_ETHER_ALT)))
			jmi_ether_irq = JMR3927_IRQ_IRC_INT(JMI39IO2_INT_ETHER_ALT);
#if 0	/* INT3 may be asserted by onboard PCI ether (even after reboot...) */
		else if (tx3927_ircptr->ssr & (1 << TX3927_IR_INT(JMI39IO2_INT_ETHER)))
			jmi_ether_irq = JMR3927_IRQ_IRC_INT(JMI39IO2_INT_ETHER);
#endif
		/* disable interrupt control */
		tx3927_ircptr->cer = 0;

		/* Ether1: High Active */
		if (jmi_ether_irq) {
			int ether_irc = jmi_ether_irq - JMR3927_IRQ_IRC;
			printk(KERN_DEBUG "JMI39IO2 ether uses irq %d\n", jmi_ether_irq);
			tx3927_ircptr->cr[ether_irc / 8] |=
				TX3927_IRCR_HIGH << ((ether_irc % 8) * 2);
			early_jmi39io2_ether_setup(JMI39IO2_ETHER_ADDR(JMR3927_IOB_BASE) - mips_io_port_base,
						   jmi_ether_irq);
		}
	}
#endif

	/* mask all IOC interrupts */
	jmr3927_ioc_reg_out(0, JMR3927_IOC_INTM_ADDR);
	/* setup IOC interrupt mode (SOFT:High Active, Others:Low Active) */
	jmr3927_ioc_reg_out(JMR3927_IOC_INTF_SOFT, JMR3927_IOC_INTP_ADDR);

	/* clear PCI Soft interrupts */
	jmr3927_ioc_reg_out(0, JMR3927_IOC_INTS1_ADDR);
	/* clear PCI Reset interrupts */
	jmr3927_ioc_reg_out(0, JMR3927_IOC_RESET_ADDR);

	toshibaboards_irqdispatch = jmr3927_irc_irqdispatch;

	/* setup irq descriptors */
	tx3927_irq_init(JMR3927_IRQ_IRC);
	for (i = JMR3927_IRQ_IOC; i < JMR3927_IRQ_IOC + JMR3927_NR_IRQ_IOC; i++) {
#if 1
		/* MODEM int always asserted. (We can not change polarity... bug?) */
		if (i == JMR3927_IRQ_IOC_MODEM)
			continue;
#endif
		irq_desc[i].status = IRQ_DISABLED;
		irq_desc[i].action = NULL;
		irq_desc[i].depth = 1;
		irq_desc[i].handler = &jmr_ioc_irq_controller;
	}

	setup_irq(JMR3927_IRQ_IOCINT, &ioc_action);
	if (have_isac) {
		jmi39io2_isac_irq_init();
		setup_irq(JMR3927_IRQ_ISACINT, &isac_action);
		setup_irq(JMR3927_IRQ_ISAC + JMI39IO2_ISAC_INTB_ISAER, &isaerr_action);
	}
	setup_irq(JMR3927_IRQ_IRC_PCI, &pcierr_action);
	/* enable TX3927 IRC interrupt */
	set_cp0_status(CAUSEF_IP7);

	toshibaboards_gen_iack = jmr3927_gen_iack;
#endif	/* Modified by Ethan */
}
