/*
 *  linux/arch/mips/toshiba-boards/jmr3927/time.c
 *
 * Copyright (C) 2000-2001 Toshiba Corporation
 *
 * $Id: time.c,v 1.1.1.1 2004/04/07 08:36:50 louistsai Exp $
 */
#include <linux/errno.h>
#include <linux/init.h>
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/param.h>
#include <linux/string.h>
#include <linux/mm.h>
#include <linux/interrupt.h>

#include <asm/bootinfo.h>
#include <asm/mipsregs.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/time.h>

#include <asm/toshiba-boards/jmr3927.h>

/* Tick Timer divider */
#define JMR3927_TIMER_CCD	0	/* 1/2 */
#define JMR3927_TIMER_CLK	(JMR3927_IMCLK / (2 << JMR3927_TIMER_CCD))

/* This is for machines which generate the exact clock. */
#define USECS_PER_JIFFY (1000000/HZ)

static unsigned long jmr3927_do_gettimeoffset(void)
{
	unsigned long count;
	unsigned long res = 0;

	/* MUST read TRR before TISR. */
	count = jmr3927_tmrptr->trr;

	if (jmr3927_tmrptr->tisr & TXx927_TMTISR_TIIS) {
		/* timer interrupt is pending.  use Max value. */
		res = USECS_PER_JIFFY - 1;
	} else {
		/* convert to usec */
		/* res = count / (JMR3927_TIMER_CLK / 1000000); */
		res = (count << 7) / ((JMR3927_TIMER_CLK << 7) / 1000000);

		/*
		 * Due to possible jiffies inconsistencies, we need to check 
		 * the result so that we'll get a timer that is monotonic.
		 */
		if (res >= USECS_PER_JIFFY)
			res = USECS_PER_JIFFY-1;
	}

	return res;
}

static void
jmr3927_timer_interrupt(int irq, void *dev_id, struct pt_regs *regs)
{
	jmr3927_tmrptr->tisr = 0;	/* ack interrupt */
	timer_interrupt(irq, dev_id, regs);
}

extern void rtc_ds1742_init(void);
extern void s3511a_init(void);

void __init jmr3927_time_init(void)
{
#if 1	/* Modified by Ethan on 04/04/2002 */
	s3511a_init();
#else
	if (jmr3927_have_nvram()) {
		rtc_ds1742_init();
	}
#endif	/* Modified by Ethan */
}

extern int setup_irq(unsigned int irq, struct irqaction *irqaction);
void __init jmr3927_timer_setup(struct irqaction *irq)
{
	/* override default gettimeoffset routine */
	do_gettimeoffset = jmr3927_do_gettimeoffset;

	/* wrap default timer interupt handler */
	irq->handler = jmr3927_timer_interrupt;

	/* enable timer counter */
	jmr3927_tmrptr->cpra = JMR3927_TIMER_CLK / HZ;
	jmr3927_tmrptr->itmr = TXx927_TMTITMR_TIIE | TXx927_TMTITMR_TZCE;
	jmr3927_tmrptr->ccdr = JMR3927_TIMER_CCD;
	jmr3927_tmrptr->tcr =
		TXx927_TMTCR_TCE | TXx927_TMTCR_CCDE | TXx927_TMTCR_TMODE_ITVL;

	/* enable timer interrupt */
	setup_irq(JMR3927_IRQ_TICK, irq);
}
