/*
 *  linux/arch/mips/toshiba-boards/rbtx4927/time.c
 *
 * Copyright (C) 1999-2001 Toshiba Corporation
 *
 * $Id: time.c,v 1.1.1.1 2004/04/07 08:36:50 louistsai Exp $
 */
#include <linux/errno.h>
#include <linux/init.h>
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/param.h>
#include <linux/string.h>
#include <linux/mm.h>
#include <linux/interrupt.h>

#include <asm/bootinfo.h>
#include <asm/mipsregs.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/time.h>

#include <asm/toshiba-boards/rbtx4927.h>

/* We use onchip r4k counter or TMR timer as our system wide timer interrupt running at 100HZ. */
int rbtx4927_use_r4k_timer;
#define rbtx4927_tmrptr		tx4927_tmrptr(0)	/* TMR0 */

/* Tick Timer divider */
#define RBTX4927_TIMER_CCD	0	/* 1/2 */
#define RBTX4927_TIMER_CLK	(RBTX4927_IMCLK / (2 << RBTX4927_TIMER_CCD))

static void
rbtx4927_timer_interrupt(int irq, void *dev_id, struct pt_regs *regs)
{
	rbtx4927_tmrptr->tisr = 0;	/* ack interrupt */
	timer_interrupt(irq, dev_id, regs);
}

extern void rtc_ds1742_init(void);

void __init rbtx4927_time_init(void)
{
	unsigned int ct0;
	int i;

	rtc_ds1742_init();

	if (tx4927_ccfgptr->ccfg & TX4927_CCFG_TINTDIS) {
		printk("Tick timer: use TX4927 timer0 interrupt.\n");
		rbtx4927_use_r4k_timer = 0;
	} else {
		printk("Tick timer: use r4k counter interrupt.\n");
		rbtx4927_use_r4k_timer = 1;
	}

	printk("calculating counter_frequency... ");

	rbtx4927_tmrptr->cpra = RBTX4927_TIMER_CLK / HZ;
	rbtx4927_tmrptr->itmr = TXx927_TMTITMR_TIIE | TXx927_TMTITMR_TZCE;
	rbtx4927_tmrptr->ccdr = RBTX4927_TIMER_CCD;
	rbtx4927_tmrptr->tcr =
		TXx927_TMTCR_TCE | TXx927_TMTCR_CCDE | TXx927_TMTCR_TMODE_ITVL;

	/* clear interval timer Int. */
	rbtx4927_tmrptr->tisr = 0;
	/* waiting for a new tick. */
	while (!(rbtx4927_tmrptr->tisr & TXx927_TMTISR_TIIS))
		;
	ct0 = read_32bit_cp0_register(CP0_COUNT);
	for (i = 0; i < 16; i++) {
		/* clear interval timer Int. */
		rbtx4927_tmrptr->tisr = 0;
		/* waiting for a next tick. */
		while (!(rbtx4927_tmrptr->tisr & TXx927_TMTISR_TIIS))
			;
	}
	mips_counter_frequency =
		(read_32bit_cp0_register(CP0_COUNT) - ct0) / 16 * HZ;
}

extern int setup_irq(unsigned int irq, struct irqaction *irqaction);
void __init rbtx4927_timer_setup(struct irqaction *irq)
{
	if (rbtx4927_use_r4k_timer) {
		unsigned int count;

		/* we are using the cpu counter for timer interrupts */
		setup_irq(RBTX4927_IRQ_LOCAL_TIMER, irq);

		/* to generate the first timer interrupt */
		count = read_32bit_cp0_register(CP0_COUNT);
		write_32bit_cp0_register(CP0_COMPARE, count + mips_counter_frequency / HZ);
	} else {
		/* wrap default timer interupt handler */
		irq->handler = rbtx4927_timer_interrupt;
#if 0	/* disabled by TINTDIS */
		/* disable counter interrupt(IM7) */
		set_cp0_status(STATUSF_IP7, 0);
#endif
		/* enable timer interrupt */
		setup_irq(RBTX4927_IRQ_IRC_TMR(0), irq);
	}
	printk("%08x(%d)\n", mips_counter_frequency, mips_counter_frequency);
}
